/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfType;

public class PackageBinding
extends Binding
implements TypeConstants {
    public long tagBits = 0L;
    public char[][] compoundName;
    PackageBinding parent;
    public LookupEnvironment environment;
    HashtableOfType knownTypes;
    HashtableOfPackage knownPackages;

    protected PackageBinding() {
    }

    public PackageBinding(char[][] compoundName, PackageBinding parent, LookupEnvironment environment) {
        this.compoundName = compoundName;
        this.parent = parent;
        this.environment = environment;
        this.knownTypes = null;
        this.knownPackages = new HashtableOfPackage(3);
    }

    public PackageBinding(char[] topLevelPackageName, LookupEnvironment environment) {
        this(new char[][]{topLevelPackageName}, null, environment);
    }

    public PackageBinding(LookupEnvironment environment) {
        this(CharOperation.NO_CHAR_CHAR, null, environment);
    }

    private void addNotFoundPackage(char[] simpleName) {
        this.knownPackages.put(simpleName, LookupEnvironment.TheNotFoundPackage);
    }

    private void addNotFoundType(char[] simpleName) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(simpleName, LookupEnvironment.TheNotFoundType);
    }

    void addPackage(PackageBinding element) {
        this.knownPackages.put(element.compoundName[element.compoundName.length - 1], element);
    }

    void addType(ReferenceBinding element) {
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(element.compoundName[element.compoundName.length - 1], element);
    }

    public final int kind() {
        return 16;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        return CharOperation.concatWith(this.compoundName, '/');
    }

    private PackageBinding findPackage(char[] name) {
        if (!this.environment.isPackage(this.compoundName, name)) {
            return null;
        }
        char[][] subPkgCompoundName = CharOperation.arrayConcat(this.compoundName, name);
        PackageBinding subPackageBinding = new PackageBinding(subPkgCompoundName, this, this.environment);
        this.addPackage(subPackageBinding);
        return subPackageBinding;
    }

    PackageBinding getPackage(char[] name) {
        PackageBinding binding = this.getPackage0(name);
        if (binding != null) {
            if (binding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return binding;
        }
        binding = this.findPackage(name);
        if (binding != null) {
            return binding;
        }
        this.addNotFoundPackage(name);
        return null;
    }

    PackageBinding getPackage0(char[] name) {
        return this.knownPackages.get(name);
    }

    ReferenceBinding getType(char[] name) {
        ReferenceBinding typeBinding = this.getType0(name);
        if (typeBinding == null && (typeBinding = this.environment.askForType(this, name)) == null) {
            this.addNotFoundType(name);
            return null;
        }
        if (typeBinding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        if ((typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, false)).isNestedType()) {
            return new ProblemReferenceBinding(name, typeBinding, 4);
        }
        return typeBinding;
    }

    ReferenceBinding getType0(char[] name) {
        if (this.knownTypes == null) {
            return null;
        }
        return this.knownTypes.get(name);
    }

    public Binding getTypeOrPackage(char[] name) {
        ReferenceBinding typeBinding = this.getType0(name);
        if (typeBinding != null && typeBinding != LookupEnvironment.TheNotFoundType) {
            if ((typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, false)).isNestedType()) {
                return new ProblemReferenceBinding(name, typeBinding, 4);
            }
            return typeBinding;
        }
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            return packageBinding;
        }
        if (typeBinding == null) {
            typeBinding = this.environment.askForType(this, name);
            if (typeBinding != null) {
                if (typeBinding.isNestedType()) {
                    return new ProblemReferenceBinding(name, typeBinding, 4);
                }
                return typeBinding;
            }
            this.addNotFoundType(name);
        }
        if (packageBinding == null) {
            packageBinding = this.findPackage(name);
            if (packageBinding != null) {
                return packageBinding;
            }
            this.addNotFoundPackage(name);
        }
        return null;
    }

    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        if (this.compoundName == CharOperation.NO_CHAR_CHAR) {
            return "The Default Package";
        }
        return "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }
}

