/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHBaseCluster
extends HBaseClusterTestCase {
    private static final Log LOG = LogFactory.getLog(TestHBaseCluster.class);
    private HTableDescriptor desc = null;
    private HBaseAdmin admin = null;
    private HTable table = null;
    private static final int FIRST_ROW = 1;
    private static final int NUM_VALS = 1000;
    private static final byte[] CONTENTS_CF = Bytes.toBytes("contents");
    private static final String CONTENTS_CQ_STR = "basic";
    private static final byte[] CONTENTS_CQ = Bytes.toBytes("basic");
    private static final String CONTENTSTR = "contentstr";
    private static final byte[] ANCHOR_CF = Bytes.toBytes("anchor");
    private static final String ANCHORNUM_CQ = "anchornum-";
    private static final String ANCHORSTR_VALUE = "anchorstr";

    public TestHBaseCluster() {
        this.conf.setInt("hbase.server.thread.wakefrequency", 2000);
        this.conf.setInt("hbase.master.lease.period", 10000);
        this.conf.setLong("hbase.client.pause", 15000L);
    }

    public void testHBaseCluster() throws IOException {
        this.setup();
        this.basic();
        this.scanner();
        this.listTables();
    }

    private void setup() throws IOException {
        this.desc = new HTableDescriptor("test");
        this.desc.addFamily(new HColumnDescriptor(CONTENTS_CF));
        this.desc.addFamily(new HColumnDescriptor(ANCHOR_CF));
        this.admin = new HBaseAdmin(this.conf);
        this.admin.createTable(this.desc);
        this.table = new HTable(this.conf, this.desc.getName());
    }

    private void basic() throws IOException {
        long startTime = System.currentTimeMillis();
        for (int k = 1; k <= 1000; ++k) {
            Put put = new Put(Bytes.toBytes("row_" + k));
            put.add(CONTENTS_CF, CONTENTS_CQ, Bytes.toBytes(CONTENTSTR + k));
            put.add(ANCHOR_CF, Bytes.toBytes(ANCHORNUM_CQ + k), Bytes.toBytes(ANCHORSTR_VALUE + k));
            this.table.put(put);
        }
        LOG.info((Object)("Write 1000 rows. Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
        startTime = System.currentTimeMillis();
        byte[] collabel = null;
        for (int k = 1; k <= 1000; ++k) {
            String rowlabelStr = "row_" + k;
            byte[] rowlabel = Bytes.toBytes(rowlabelStr);
            Get get2 = new Get(rowlabel);
            get2.addColumn(CONTENTS_CF, CONTENTS_CQ);
            byte[] bodydata = this.table.get(get2).getValue(CONTENTS_CF, CONTENTS_CQ);
            TestHBaseCluster.assertNotNull((String)("no data for row " + rowlabelStr + "/" + CONTENTS_CQ_STR), (Object)bodydata);
            String bodystr = new String(bodydata, "UTF-8");
            String teststr = CONTENTSTR + k;
            TestHBaseCluster.assertTrue((String)("Incorrect value for key: (" + rowlabelStr + "/" + CONTENTS_CQ_STR + "), expected: '" + teststr + "' got: '" + bodystr + "'"), (teststr.compareTo(bodystr) == 0 ? 1 : 0) != 0);
            String collabelStr = ANCHORNUM_CQ + k;
            collabel = Bytes.toBytes(collabelStr);
            get2 = new Get(rowlabel);
            get2.addColumn(ANCHOR_CF, collabel);
            bodydata = this.table.get(get2).getValue(ANCHOR_CF, collabel);
            TestHBaseCluster.assertNotNull((String)("no data for row " + rowlabelStr + "/" + collabelStr), (Object)bodydata);
            bodystr = new String(bodydata, "UTF-8");
            teststr = ANCHORSTR_VALUE + k;
            TestHBaseCluster.assertTrue((String)("Incorrect value for key: (" + rowlabelStr + "/" + collabelStr + "), expected: '" + teststr + "' got: '" + bodystr + "'"), (teststr.compareTo(bodystr) == 0 ? 1 : 0) != 0);
        }
        LOG.info((Object)("Read 1000 rows. Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanner() throws IOException {
        long startTime = System.currentTimeMillis();
        Scan scan = new Scan();
        scan.addFamily(ANCHOR_CF);
        scan.addColumn(CONTENTS_CF, CONTENTS_CQ);
        ResultScanner s = this.table.getScanner(scan);
        try {
            int contentsFetched = 0;
            int anchorFetched = 0;
            int k = 0;
            for (Result curVals : s) {
                for (KeyValue kv : curVals.raw()) {
                    byte[] family = kv.getFamily();
                    byte[] qualifier = kv.getQualifier();
                    String strValue = new String(kv.getValue());
                    if (Bytes.equals(family, CONTENTS_CF)) {
                        TestHBaseCluster.assertTrue((String)("Error at:" + Bytes.toString(curVals.getRow()) + ", Value for " + Bytes.toString(qualifier) + " should start with: " + CONTENTSTR + ", but was fetched as: " + strValue), (boolean)strValue.startsWith(CONTENTSTR));
                        ++contentsFetched;
                        continue;
                    }
                    if (Bytes.equals(family, ANCHOR_CF)) {
                        TestHBaseCluster.assertTrue((String)("Error at:" + Bytes.toString(curVals.getRow()) + ", Value for " + Bytes.toString(qualifier) + " should start with: " + ANCHORSTR_VALUE + ", but was fetched as: " + strValue), (boolean)strValue.startsWith(ANCHORSTR_VALUE));
                        ++anchorFetched;
                        continue;
                    }
                    LOG.info((Object)("Family: " + Bytes.toString(family) + ", Qualifier: " + Bytes.toString(qualifier)));
                }
                ++k;
            }
            TestHBaseCluster.assertEquals((String)("Expected 1000 " + Bytes.toString(CONTENTS_CQ) + " values, but fetched " + contentsFetched), (int)1000, (int)contentsFetched);
            TestHBaseCluster.assertEquals((String)("Expected 1000 anchornum- values, but fetched " + anchorFetched), (int)1000, (int)anchorFetched);
            LOG.info((Object)("Scanned 1000 rows. Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
        }
        finally {
            s.close();
        }
    }

    private void listTables() throws IOException {
        HTableDescriptor[] tables = this.admin.listTables();
        TestHBaseCluster.assertEquals((int)1, (int)tables.length);
        TestHBaseCluster.assertTrue((boolean)Bytes.equals(this.desc.getName(), tables[0].getName()));
        Collection<HColumnDescriptor> families = tables[0].getFamilies();
        TestHBaseCluster.assertEquals((int)2, (int)families.size());
        TestHBaseCluster.assertTrue((boolean)tables[0].hasFamily(CONTENTS_CF));
        TestHBaseCluster.assertTrue((boolean)tables[0].hasFamily(ANCHOR_CF));
    }
}

