/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

public class TestHStoreKey
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMoreComparisons() throws Exception {
        HStoreKey a = new HStoreKey(".META.,,99999999999999");
        HStoreKey.MetaStoreKeyComparator c = new HStoreKey.RootStoreKeyComparator();
        HStoreKey b = new HStoreKey(".META.,,1");
        TestHStoreKey.assertTrue((c.compare(b.getBytes(), a.getBytes()) < 0 ? 1 : 0) != 0);
        HStoreKey aa = new HStoreKey(".META.,,1");
        HStoreKey bb = new HStoreKey(".META.,,1", "info:regioninfo", 1235943454602L);
        TestHStoreKey.assertTrue((c.compare(aa.getBytes(), bb.getBytes()) < 0 ? 1 : 0) != 0);
        HStoreKey aaa = new HStoreKey("TestScanMultipleVersions,row_0500,1236020145502");
        HStoreKey bbb = new HStoreKey("TestScanMultipleVersions,,99999999999999");
        c = new HStoreKey.MetaStoreKeyComparator();
        TestHStoreKey.assertTrue((c.compare(bbb.getBytes(), aaa.getBytes()) < 0 ? 1 : 0) != 0);
        HStoreKey aaaa = new HStoreKey("TestScanMultipleVersions,,1236023996656", "info:regioninfo", 1236024396271L);
        TestHStoreKey.assertTrue((c.compare(aaaa.getBytes(), bbb.getBytes()) < 0 ? 1 : 0) != 0);
        HStoreKey x = new HStoreKey("TestScanMultipleVersions,row_0500,1236034574162", "", Long.MAX_VALUE);
        HStoreKey y = new HStoreKey("TestScanMultipleVersions,row_0500,1236034574162", "info:regioninfo", 1236034574912L);
        TestHStoreKey.assertTrue((c.compare(x.getBytes(), y.getBytes()) < 0 ? 1 : 0) != 0);
        this.comparisons(new HStoreKey.HStoreKeyRootComparator());
        this.comparisons(new HStoreKey.HStoreKeyMetaComparator());
        this.comparisons(new HStoreKey.HStoreKeyComparator());
        this.metacomparisons(new HStoreKey.HStoreKeyRootComparator());
        this.metacomparisons(new HStoreKey.HStoreKeyMetaComparator());
    }

    public void testHStoreKeyBorderCases() throws IOException {
        HStoreKey rowA = new HStoreKey("testtable,www.hbase.org/,1234", "", Long.MAX_VALUE);
        byte[] rowABytes = Writables.getBytes((Writable)rowA);
        HStoreKey rowB = new HStoreKey("testtable,www.hbase.org/%20,99999", "", Long.MAX_VALUE);
        byte[] rowBBytes = Writables.getBytes((Writable)rowB);
        TestHStoreKey.assertTrue((rowA.compareTo(rowB) > 0 ? 1 : 0) != 0);
        HStoreKey.MetaStoreKeyComparator c = new HStoreKey.MetaStoreKeyComparator();
        TestHStoreKey.assertTrue((c.compare(rowABytes, rowBBytes) < 0 ? 1 : 0) != 0);
        rowA = new HStoreKey("testtable,,1234", "", Long.MAX_VALUE);
        rowB = new HStoreKey("testtable,$www.hbase.org/,99999", "", Long.MAX_VALUE);
        TestHStoreKey.assertTrue((rowA.compareTo(rowB) > 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((c.compare(Writables.getBytes((Writable)rowA), Writables.getBytes((Writable)rowB)) < 0 ? 1 : 0) != 0);
        rowA = new HStoreKey(".META.,testtable,www.hbase.org/,1234,4321", "", Long.MAX_VALUE);
        rowB = new HStoreKey(".META.,testtable,www.hbase.org/%20,99999,99999", "", Long.MAX_VALUE);
        TestHStoreKey.assertTrue((rowA.compareTo(rowB) > 0 ? 1 : 0) != 0);
        HStoreKey.RootStoreKeyComparator rootComparator = new HStoreKey.RootStoreKeyComparator();
        TestHStoreKey.assertTrue((rootComparator.compare(Writables.getBytes((Writable)rowA), Writables.getBytes((Writable)rowB)) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(HStoreKey.HStoreKeyComparator c) {
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,a,,0,1"), new HStoreKey(".META.,a,,0,1")) == 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,a,,0,1"), new HStoreKey(".META.,a,,0,2")) < 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,a,,0,2"), new HStoreKey(".META.,a,,0,1")) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(HStoreKey.HStoreKeyComparator c) {
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,,1"), new HStoreKey(".META.,,1")) == 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,,1"), new HStoreKey(".META.,,2")) < 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((c.compare(new HStoreKey(".META.,,2"), new HStoreKey(".META.,,1")) > 0 ? 1 : 0) != 0);
    }

    public void testBinaryKeys() throws Exception {
        TreeSet<HStoreKey> set = new TreeSet<HStoreKey>((Comparator<HStoreKey>)((Object)new HStoreKey.HStoreKeyComparator()));
        HStoreKey[] keys = new HStoreKey[]{new HStoreKey("aaaaa,\u0000\u0000,2", this.getName(), 2L), new HStoreKey("aaaaa,\u0001,3", this.getName(), 3L), new HStoreKey("aaaaa,,1", this.getName(), 1L), new HStoreKey("aaaaa,\u1000,5", this.getName(), 5L), new HStoreKey("aaaaa,a,4", this.getName(), 4L), new HStoreKey("a,a,0", this.getName(), 0L)};
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        boolean assertion = false;
        int count = 0;
        try {
            for (HStoreKey k : set) {
                TestHStoreKey.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        TestHStoreKey.assertTrue((boolean)assertion);
        set = new TreeSet(new HStoreKey.HStoreKeyMetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        count = 0;
        for (HStoreKey k : set) {
            TestHStoreKey.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
        HStoreKey[] rootKeys = new HStoreKey[]{new HStoreKey(".META.,aaaaa,\u0000\u0000,0,2", this.getName(), 2L), new HStoreKey(".META.,aaaaa,\u0001,0,3", this.getName(), 3L), new HStoreKey(".META.,aaaaa,,0,1", this.getName(), 1L), new HStoreKey(".META.,aaaaa,\u1000,0,5", this.getName(), 5L), new HStoreKey(".META.,aaaaa,a,0,4", this.getName(), 4L), new HStoreKey(".META.,,0", this.getName(), 0L)};
        set = new TreeSet(new HStoreKey.HStoreKeyMetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        assertion = false;
        count = 0;
        try {
            for (HStoreKey k : set) {
                TestHStoreKey.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        set = new TreeSet(new HStoreKey.HStoreKeyRootComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        count = 0;
        for (HStoreKey k : set) {
            TestHStoreKey.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }

    public void testSerialization() throws IOException {
        HStoreKey hsk = new HStoreKey(this.getName(), this.getName(), 123L);
        byte[] b = hsk.getBytes();
        HStoreKey hsk2 = HStoreKey.create(b);
        TestHStoreKey.assertTrue((boolean)hsk.equals(hsk2));
        hsk = new HStoreKey(this.getName());
        TestHStoreKey.assertTrue((boolean)Bytes.equals(hsk.getBytes(), HStoreKey.getBytes(Bytes.toBytes(this.getName()), null, Long.MAX_VALUE)));
    }

    public void testGetBytes() throws IOException {
        long now = System.currentTimeMillis();
        HStoreKey hsk = new HStoreKey("one", "two", now);
        byte[] writablesBytes = Writables.getBytes((Writable)hsk);
        byte[] selfSerializationBytes = hsk.getBytes();
        Bytes.equals(writablesBytes, selfSerializationBytes);
    }

    public void testByteBuffer() throws Exception {
        long ts = 123L;
        byte[] row = Bytes.toBytes("row");
        byte[] column = Bytes.toBytes("column");
        HStoreKey hsk = new HStoreKey(row, column, 123L);
        ByteBuffer bb = ByteBuffer.wrap(hsk.getBytes());
        TestHStoreKey.assertTrue((boolean)Bytes.equals(row, HStoreKey.getRow(bb)));
        TestHStoreKey.assertTrue((boolean)Bytes.equals(column, HStoreKey.getColumn(bb)));
        TestHStoreKey.assertEquals((long)123L, (long)HStoreKey.getTimestamp(bb));
    }

    public void testRawComparator() throws IOException {
        long timestamp = System.currentTimeMillis();
        byte[] a = Bytes.toBytes("a");
        HStoreKey past = new HStoreKey(a, a, timestamp - 10L);
        byte[] pastBytes = Writables.getBytes((Writable)past);
        HStoreKey now = new HStoreKey(a, a, timestamp);
        byte[] nowBytes = Writables.getBytes((Writable)now);
        HStoreKey future = new HStoreKey(a, a, timestamp + 10L);
        byte[] futureBytes = Writables.getBytes((Writable)future);
        HStoreKey.StoreKeyComparator comparator = new HStoreKey.StoreKeyComparator();
        TestHStoreKey.assertTrue((past.compareTo(now) > 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((comparator.compare(pastBytes, nowBytes) > 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((now.compareTo(now) == 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((comparator.compare(nowBytes, nowBytes) == 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((future.compareTo(now) < 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((comparator.compare(futureBytes, nowBytes) < 0 ? 1 : 0) != 0);
        HStoreKey nocolumn = new HStoreKey(a, timestamp);
        byte[] nocolumnBytes = Writables.getBytes((Writable)nocolumn);
        HStoreKey withcolumn = new HStoreKey(a, a, timestamp);
        byte[] withcolumnBytes = Writables.getBytes((Writable)withcolumn);
        TestHStoreKey.assertTrue((nocolumn.compareTo(withcolumn) < 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((comparator.compare(nocolumnBytes, withcolumnBytes) < 0 ? 1 : 0) != 0);
        nocolumn = new HStoreKey(a, Long.MAX_VALUE);
        nocolumnBytes = Writables.getBytes((Writable)nocolumn);
        withcolumn = new HStoreKey(a, a, timestamp);
        withcolumnBytes = Writables.getBytes((Writable)withcolumn);
        TestHStoreKey.assertTrue((nocolumn.compareTo(withcolumn) < 0 ? 1 : 0) != 0);
        TestHStoreKey.assertTrue((comparator.compare(nocolumnBytes, withcolumnBytes) < 0 ? 1 : 0) != 0);
    }
}

