/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

public class TestKeyValue
extends TestCase {
    private final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void testColumnCompare() throws Exception {
        byte[] a = Bytes.toBytes("aaa");
        byte[] column1 = Bytes.toBytes("abc:def");
        byte[] column2 = Bytes.toBytes("abcd:ef");
        byte[] family2 = Bytes.toBytes("abcd");
        byte[] qualifier2 = Bytes.toBytes("ef");
        KeyValue aaa = new KeyValue(a, column1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(column2));
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(column1));
        aaa = new KeyValue(a, column2, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(column1));
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(family2, qualifier2));
        column1 = Bytes.toBytes("abcd:");
        aaa = new KeyValue(a, column1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(family2, null));
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(family2, qualifier2));
    }

    public void testBasics() throws Exception {
        this.LOG.info((Object)("LOWKEY: " + KeyValue.LOWESTKEY.toString()));
        this.check(Bytes.toBytes(this.getName()), Bytes.toBytes(this.getName() + ":" + this.getName()), 1L, Bytes.toBytes(this.getName()));
        this.check(Bytes.toBytes(this.getName()), null, 1L, null);
        this.check(HConstants.EMPTY_BYTE_ARRAY, null, 1L, null);
    }

    private void check(byte[] row, byte[] column, long timestamp, byte[] value) {
        KeyValue kv = new KeyValue(row, column, timestamp, value);
        TestKeyValue.assertTrue((Bytes.compareTo(kv.getRow(), row) == 0 ? 1 : 0) != 0);
        if (column != null && column.length > 0) {
            int index = KeyValue.getFamilyDelimiterIndex(column, 0, column.length);
            byte[] family = new byte[index];
            System.arraycopy(column, 0, family, 0, family.length);
            TestKeyValue.assertTrue((boolean)kv.matchingFamily(family));
        }
        this.LOG.info((Object)kv.toString());
    }

    public void testPlainCompare() throws Exception {
        byte[] a = Bytes.toBytes("aaa");
        byte[] b = Bytes.toBytes("bbb");
        byte[] column = Bytes.toBytes("col:umn");
        KeyValue aaa = new KeyValue(a, column, a);
        KeyValue bbb = new KeyValue(b, column, b);
        byte[] keyabb = aaa.getKey();
        byte[] keybbb = bbb.getKey();
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keyabb, 0, keyabb.length, keybbb, 0, keybbb.length) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keybbb, 0, keybbb.length, keyabb, 0, keyabb.length) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, bbb) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keybbb, 0, keybbb.length, keybbb, 0, keybbb.length) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keyabb, 0, keyabb.length, keyabb, 0, keyabb.length) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, column, 1L, a);
        bbb = new KeyValue(a, column, 2L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, column, 1L, KeyValue.Type.Delete, a);
        bbb = new KeyValue(a, column, 1L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
    }

    public void testMoreComparisons() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes(".META.,,99999999999999"), now);
        KeyValue.MetaComparator c = new KeyValue.RootComparator();
        KeyValue b = new KeyValue(Bytes.toBytes(".META.,,1"), now);
        TestKeyValue.assertTrue((c.compare(b, a) < 0 ? 1 : 0) != 0);
        KeyValue aa = new KeyValue(Bytes.toBytes(".META.,,1"), now);
        KeyValue bb = new KeyValue(Bytes.toBytes(".META.,,1"), Bytes.toBytes("info:regioninfo"), 1235943454602L);
        TestKeyValue.assertTrue((c.compare(aa, bb) < 0 ? 1 : 0) != 0);
        KeyValue aaa = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236020145502"), now);
        KeyValue bbb = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,,99999999999999"), now);
        c = new KeyValue.MetaComparator();
        TestKeyValue.assertTrue((c.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        KeyValue aaaa = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,,1236023996656"), Bytes.toBytes("info:regioninfo"), 1236024396271L);
        TestKeyValue.assertTrue((c.compare(aaaa, bbb) < 0 ? 1 : 0) != 0);
        KeyValue x = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes(""), Long.MAX_VALUE);
        KeyValue y = new KeyValue(Bytes.toBytes("TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes("info:regioninfo"), 1236034574912L);
        TestKeyValue.assertTrue((c.compare(x, y) < 0 ? 1 : 0) != 0);
        this.comparisons(new KeyValue.MetaComparator());
        this.comparisons(new KeyValue.KVComparator());
        this.metacomparisons(new KeyValue.RootComparator());
        this.metacomparisons(new KeyValue.MetaComparator());
    }

    public void testKeyValueBorderCases() throws IOException {
        KeyValue rowB;
        KeyValue rowA = new KeyValue(Bytes.toBytes("testtable,www.hbase.org/,1234"), Bytes.toBytes(""), Long.MAX_VALUE);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB = new KeyValue(Bytes.toBytes("testtable,www.hbase.org/%20,99999"), Bytes.toBytes(""), Long.MAX_VALUE)) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes("testtable,,1234"), Bytes.toBytes(""), Long.MAX_VALUE);
        rowB = new KeyValue(Bytes.toBytes("testtable,$www.hbase.org/,99999"), Bytes.toBytes(""), Long.MAX_VALUE);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes(".META.,testtable,www.hbase.org/,1234,4321"), Bytes.toBytes(""), Long.MAX_VALUE);
        rowB = new KeyValue(Bytes.toBytes(".META.,testtable,www.hbase.org/%20,99999,99999"), Bytes.toBytes(""), Long.MAX_VALUE);
        TestKeyValue.assertTrue((KeyValue.ROOT_COMPARATOR.compare(rowA, rowB) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(KeyValue.MetaComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(".META.,a,,0,1"), now), new KeyValue(Bytes.toBytes(".META.,a,,0,1"), now)) == 0 ? 1 : 0) != 0);
        KeyValue a = new KeyValue(Bytes.toBytes(".META.,a,,0,1"), now);
        KeyValue b = new KeyValue(Bytes.toBytes(".META.,a,,0,2"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(".META.,a,,0,2"), now), new KeyValue(Bytes.toBytes(".META.,a,,0,1"), now)) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(KeyValue.KVComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(".META.,,1"), now), new KeyValue(Bytes.toBytes(".META.,,1"), now)) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(".META.,,1"), now), new KeyValue(Bytes.toBytes(".META.,,2"), now)) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes(".META.,,2"), now), new KeyValue(Bytes.toBytes(".META.,,1"), now)) > 0 ? 1 : 0) != 0);
    }

    public void testBinaryKeys() throws Exception {
        TreeSet<KeyValue> set = new TreeSet<KeyValue>(KeyValue.COMPARATOR);
        byte[] column = Bytes.toBytes("col:umn");
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes("aaaaa,\u0000\u0000,2"), column, 2L), new KeyValue(Bytes.toBytes("aaaaa,\u0001,3"), column, 3L), new KeyValue(Bytes.toBytes("aaaaa,,1"), column, 1L), new KeyValue(Bytes.toBytes("aaaaa,\u1000,5"), column, 5L), new KeyValue(Bytes.toBytes("aaaaa,a,4"), column, 4L), new KeyValue(Bytes.toBytes("a,a,0"), column, 0L)};
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        boolean assertion = false;
        int count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        TestKeyValue.assertTrue((boolean)assertion);
        set = new TreeSet<KeyValue>(new KeyValue.MetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
        KeyValue[] rootKeys = new KeyValue[]{new KeyValue(Bytes.toBytes(".META.,aaaaa,\u0000\u0000,0,2"), column, 2L), new KeyValue(Bytes.toBytes(".META.,aaaaa,\u0001,0,3"), column, 3L), new KeyValue(Bytes.toBytes(".META.,aaaaa,,0,1"), column, 1L), new KeyValue(Bytes.toBytes(".META.,aaaaa,\u1000,0,5"), column, 5L), new KeyValue(Bytes.toBytes(".META.,aaaaa,a,0,4"), column, 4L), new KeyValue(Bytes.toBytes(".META.,,0"), column, 0L)};
        set = new TreeSet<KeyValue>(new KeyValue.MetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        assertion = false;
        count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        set = new TreeSet<KeyValue>(new KeyValue.RootComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }

    public void testStackedUpKeyValue() {
    }
}

