/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scanner;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;

public class TestBatchUpdate
extends HBaseClusterTestCase {
    private static final String CONTENTS_STR = "contents:";
    private static final byte[] CONTENTS = Bytes.toBytes("contents:");
    private static final String SMALLFAM_STR = "smallfam:";
    private static final byte[] SMALLFAM = Bytes.toBytes("smallfam:");
    private static final int SMALL_LENGTH = 1;
    private static final int NB_BATCH_ROWS = 10;
    private byte[] value = Bytes.toBytes("abcd");
    private byte[] smallValue = Bytes.toBytes("a");
    private HTableDescriptor desc = null;
    private HTable table = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.desc = new HTableDescriptor("test");
        this.desc.addFamily(new HColumnDescriptor(CONTENTS_STR));
        this.desc.addFamily(new HColumnDescriptor(SMALLFAM, 3, HColumnDescriptor.DEFAULT_COMPRESSION, false, true, 1, Integer.MAX_VALUE, false));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(this.desc);
        this.table = new HTable(this.conf, this.desc.getName());
    }

    public void testRowsBatchUpdateBufferedOneFlush() {
        this.table.setAutoFlush(false);
        ArrayList<BatchUpdate> rowsUpdate = new ArrayList<BatchUpdate>();
        for (int i = 0; i < 100; ++i) {
            BatchUpdate batchUpdate = new BatchUpdate("row" + i);
            batchUpdate.put(CONTENTS, this.value);
            rowsUpdate.add(batchUpdate);
        }
        try {
            this.table.commit(rowsUpdate);
            byte[][] columns = new byte[][]{CONTENTS};
            Scanner scanner = this.table.getScanner(columns, HConstants.EMPTY_START_ROW);
            int nbRows = 0;
            for (RowResult row : scanner) {
                ++nbRows;
            }
            TestBatchUpdate.assertEquals((int)0, (int)nbRows);
            scanner.close();
            this.table.flushCommits();
            scanner = this.table.getScanner(columns, HConstants.EMPTY_START_ROW);
            nbRows = 0;
            for (RowResult row : scanner) {
                ++nbRows;
            }
            TestBatchUpdate.assertEquals((int)100, (int)nbRows);
        }
        catch (IOException e) {
            TestBatchUpdate.fail((String)("This is unexpected : " + e));
        }
    }

    public void testRowsBatchUpdateBufferedManyManyFlushes() throws IOException {
        this.table.setAutoFlush(false);
        this.table.setWriteBufferSize(10L);
        ArrayList<BatchUpdate> rowsUpdate = new ArrayList<BatchUpdate>();
        for (int i = 0; i < 100; ++i) {
            BatchUpdate batchUpdate = new BatchUpdate("row" + i);
            batchUpdate.put(CONTENTS, this.value);
            rowsUpdate.add(batchUpdate);
        }
        try {
            this.table.commit(rowsUpdate);
            this.table.flushCommits();
            byte[][] columns = new byte[][]{CONTENTS};
            Scanner scanner = this.table.getScanner(columns, HConstants.EMPTY_START_ROW);
            int nbRows = 0;
            for (RowResult row : scanner) {
                ++nbRows;
            }
            TestBatchUpdate.assertEquals((int)100, (int)nbRows);
        }
        catch (IOException e) {
            TestBatchUpdate.fail((String)("This is unexpected : " + e));
        }
    }

    public void testBatchUpdate() throws IOException {
        BatchUpdate bu = new BatchUpdate("row1");
        bu.put(CONTENTS, this.value);
        this.table.commit(bu);
        bu = new BatchUpdate("row2");
        bu.put(CONTENTS, this.value);
        byte[][] getColumns = bu.getColumns();
        TestBatchUpdate.assertEquals((int)getColumns.length, (int)1);
        TestBatchUpdate.assertTrue((boolean)Arrays.equals(getColumns[0], CONTENTS));
        TestBatchUpdate.assertTrue((boolean)bu.hasColumn(CONTENTS));
        TestBatchUpdate.assertFalse((boolean)bu.hasColumn(new byte[0]));
        byte[] getValue = bu.get(getColumns[0]);
        TestBatchUpdate.assertTrue((boolean)Arrays.equals(getValue, this.value));
        this.table.commit(bu);
        byte[][] columns = new byte[][]{CONTENTS};
        Scanner scanner = this.table.getScanner(columns, HConstants.EMPTY_START_ROW);
        for (RowResult r : scanner) {
            for (Map.Entry<byte[], Cell> e : r.entrySet()) {
                System.out.println(Bytes.toString(r.getRow()) + ": row: " + e.getKey() + " value: " + new String(e.getValue().getValue(), "UTF-8"));
            }
        }
    }

    public void testRowsBatchUpdate() {
        ArrayList<BatchUpdate> rowsUpdate = new ArrayList<BatchUpdate>();
        for (int i = 0; i < 10; ++i) {
            BatchUpdate batchUpdate = new BatchUpdate("row" + i);
            batchUpdate.put(CONTENTS, this.value);
            rowsUpdate.add(batchUpdate);
        }
        try {
            this.table.commit(rowsUpdate);
            byte[][] columns = new byte[][]{CONTENTS};
            Scanner scanner = this.table.getScanner(columns, HConstants.EMPTY_START_ROW);
            int nbRows = 0;
            for (RowResult row : scanner) {
                ++nbRows;
            }
            TestBatchUpdate.assertEquals((int)10, (int)nbRows);
        }
        catch (IOException e) {
            TestBatchUpdate.fail((String)("This is unexpected : " + e));
        }
    }
}

