/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TestGet
extends HBaseClusterTestCase {
    private static final byte[] FAMILY = Bytes.toBytes("family");
    private static final byte[] ROW = Bytes.toBytes("row");
    private static final byte[] QUALIFIER = Bytes.toBytes("qualifier");
    private static final byte[] VALUE = Bytes.toBytes("value");
    private static final byte[] MISSING_ROW = Bytes.toBytes("missingrow");
    private HTableDescriptor desc = null;
    private HTable table = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.desc = new HTableDescriptor("testGet");
        this.desc.addFamily(new HColumnDescriptor(FAMILY));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(this.desc);
        this.table = new HTable(this.conf, this.desc.getName());
    }

    public void testGet_EmptyTable() throws IOException {
        Get get2 = new Get(ROW);
        get2.addFamily(FAMILY);
        Result r = this.table.get(get2);
        TestGet.assertTrue((boolean)r.isEmpty());
    }

    public void testGet_NonExistentRow() throws IOException {
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        this.table.put(put);
        System.out.println("Row put");
        Get get2 = new Get(ROW);
        get2.addFamily(FAMILY);
        Result r = this.table.get(get2);
        TestGet.assertFalse((boolean)r.isEmpty());
        System.out.println("Row retrieved successfully");
        get2 = new Get(MISSING_ROW);
        get2.addFamily(FAMILY);
        r = this.table.get(get2);
        TestGet.assertTrue((boolean)r.isEmpty());
        System.out.println("Row missing as it should be");
    }
}

