/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TestGetRowVersions
extends HBaseClusterTestCase {
    private static final Log LOG = LogFactory.getLog(TestGetRowVersions.class);
    private static final String TABLE_NAME = "test";
    private static final byte[] CONTENTS = Bytes.toBytes("contents");
    private static final byte[] ROW = Bytes.toBytes("row");
    private static final byte[] VALUE1 = Bytes.toBytes("value1");
    private static final byte[] VALUE2 = Bytes.toBytes("value2");
    private static final long TIMESTAMP1 = 100L;
    private static final long TIMESTAMP2 = 200L;
    private HBaseAdmin admin = null;
    private HTable table = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME);
        desc.addFamily(new HColumnDescriptor(CONTENTS));
        this.admin = new HBaseAdmin(this.conf);
        this.admin.createTable(desc);
        this.table = new HTable(this.conf, TABLE_NAME);
    }

    public void testGetRowMultipleVersions() throws Exception {
        Put put = new Put(ROW);
        put.setTimeStamp(100L);
        put.add(CONTENTS, CONTENTS, VALUE1);
        this.table.put(put);
        this.cluster.shutdown();
        this.zooKeeperCluster.shutdown();
        LOG.debug((Object)"HBase cluster shut down -- restarting");
        this.hBaseClusterSetup();
        this.table = new HTable(this.conf, TABLE_NAME);
        put = new Put(ROW);
        put.setTimeStamp(200L);
        put.add(CONTENTS, CONTENTS, VALUE2);
        this.table.put(put);
        Get get2 = new Get(ROW);
        Result r = this.table.get(get2);
        TestGetRowVersions.assertNotNull((Object)r);
        TestGetRowVersions.assertFalse((boolean)r.isEmpty());
        TestGetRowVersions.assertTrue((r.size() == 1 ? 1 : 0) != 0);
        byte[] value = r.getValue(CONTENTS, CONTENTS);
        TestGetRowVersions.assertTrue((value.length != 0 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals(value, VALUE2));
        get2 = new Get(ROW);
        get2.setMaxVersions();
        r = this.table.get(get2);
        TestGetRowVersions.assertTrue((r.size() == 2 ? 1 : 0) != 0);
        value = r.getValue(CONTENTS, CONTENTS);
        TestGetRowVersions.assertTrue((value.length != 0 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals(value, VALUE2));
        NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> map = r.getMap();
        NavigableMap familyMap = (NavigableMap)map.get(CONTENTS);
        NavigableMap versionMap = (NavigableMap)familyMap.get(CONTENTS);
        TestGetRowVersions.assertTrue((versionMap.size() == 2 ? 1 : 0) != 0);
        TestGetRowVersions.assertTrue((boolean)Bytes.equals(VALUE1, (byte[])versionMap.get(100L)));
        TestGetRowVersions.assertTrue((boolean)Bytes.equals(VALUE2, (byte[])versionMap.get(200L)));
    }
}

