/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHTable
extends HBaseClusterTestCase
implements HConstants {
    private static final HColumnDescriptor column = new HColumnDescriptor(CATALOG_FAMILY);
    private static final byte[] nosuchTable = Bytes.toBytes("nosuchTable");
    private static final byte[] tableAname = Bytes.toBytes("tableA");
    private static final byte[] tableBname = Bytes.toBytes("tableB");
    private static final byte[] row = Bytes.toBytes("row");
    private static final byte[] attrName = Bytes.toBytes("TESTATTR");
    private static final byte[] attrValue = Bytes.toBytes("somevalue");

    public void testGet() throws IOException {
        HTable table = null;
        try {
            HColumnDescriptor column2 = new HColumnDescriptor(Bytes.toBytes("info2:"));
            HBaseAdmin admin = new HBaseAdmin(this.conf);
            HTableDescriptor testTableADesc = new HTableDescriptor(tableAname);
            testTableADesc.addFamily(column);
            testTableADesc.addFamily(column2);
            admin.createTable(testTableADesc);
            table = new HTable(this.conf, tableAname);
            System.out.println("Adding row to table");
            Put put = new Put(row);
            for (int i = 0; i < 5; ++i) {
                put.add(CATALOG_FAMILY, Bytes.toBytes(Integer.toString(i)), Bytes.toBytes(i));
            }
            table.put(put);
            Get get2 = null;
            Result result = null;
            get2 = new Get(row);
            get2.addFamily(CATALOG_FAMILY);
            System.out.println("Getting row");
            long start = System.nanoTime();
            result = table.get(get2);
            long stop = System.nanoTime();
            System.out.println("timer " + (stop - start));
            System.out.println("result " + result);
            for (int i = 0; i < 5; ++i) {
                TestHTable.assertTrue((boolean)result.containsColumn(CATALOG_FAMILY, Bytes.toBytes(Integer.toString(i))));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHTable.fail((String)("Should not have any exception " + e.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHTable() throws IOException {
        byte[] value = "value".getBytes("UTF-8");
        try {
            new HTable(this.conf, nosuchTable);
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHTable.fail();
        }
        HTableDescriptor tableAdesc = new HTableDescriptor(tableAname);
        tableAdesc.addFamily(column);
        HTableDescriptor tableBdesc = new HTableDescriptor(tableBname);
        tableBdesc.addFamily(column);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(tableAdesc);
        admin.createTable(tableBdesc);
        HTable a = new HTable(this.conf, tableAname);
        HTableDescriptor meta = a.getConnection().getHTableDescriptor(tableAdesc.getName());
        TestHTable.assertTrue((boolean)meta.equals(tableAdesc));
        Put put = new Put(row);
        put.add(CATALOG_FAMILY, null, value);
        a.put(put);
        HTable newA = new HTable(this.conf, tableAname);
        HTable b = new HTable(this.conf, tableBname);
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        ResultScanner s = newA.getScanner(scan);
        try {
            for (Result r : s) {
                put = new Put(r.getRow());
                for (KeyValue kv : r.sorted()) {
                    put.add(kv);
                }
                b.put(put);
            }
        }
        finally {
            s.close();
        }
        try {
            HTable anotherA = new HTable(this.conf, tableAname);
            Get get2 = new Get(row);
            get2.addFamily(CATALOG_FAMILY);
            anotherA.get(get2);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestHTable.fail();
        }
        try {
            HTableDescriptor desc = new HTableDescriptor(a.getTableDescriptor());
            admin.disableTable(tableAname);
            desc.setValue(attrName, attrValue);
            for (HColumnDescriptor c : desc.getFamilies()) {
                c.setValue(attrName, attrValue);
            }
            admin.modifyTable(tableAname, HConstants.Modify.TABLE_SET_HTD, desc);
            admin.enableTable(tableAname);
            desc = a.getTableDescriptor();
            if (Bytes.compareTo(desc.getName(), tableAname) != 0) {
                TestHTable.fail((String)"wrong table descriptor returned");
            }
            if ((value = desc.getValue(attrName)) == null) {
                TestHTable.fail((String)"missing HTD attribute value");
            }
            if (Bytes.compareTo(value, attrValue) != 0) {
                TestHTable.fail((String)"HTD attribute value is incorrect");
            }
            for (HColumnDescriptor c : desc.getFamilies()) {
                value = c.getValue(attrName);
                if (value == null) {
                    TestHTable.fail((String)"missing HCD attribute value");
                }
                if (Bytes.compareTo(value, attrValue) == 0) continue;
                TestHTable.fail((String)"HCD attribute value is incorrect");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestHTable.fail();
        }
    }

    public void testTableNotFoundExceptionWithoutAnyTables() {
        try {
            new HTable(this.conf, "notATable");
            TestHTable.fail((String)"Should have thrown a TableNotFoundException");
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHTable.fail((String)("Should have thrown a TableNotFoundException instead of a " + e.getClass()));
        }
    }

    public void testGetClosestRowBefore() throws IOException {
        HColumnDescriptor column2 = new HColumnDescriptor(Bytes.toBytes("info2:"));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor testTableADesc = new HTableDescriptor(tableAname);
        testTableADesc.addFamily(column);
        testTableADesc.addFamily(column2);
        admin.createTable(testTableADesc);
        byte[] firstRow = Bytes.toBytes("ro");
        byte[] beforeFirstRow = Bytes.toBytes("rn");
        byte[] beforeSecondRow = Bytes.toBytes("rov");
        HTable table = new HTable(this.conf, tableAname);
        Put put = new Put(firstRow);
        Put put2 = new Put(row);
        byte[] zero = new byte[]{0};
        byte[] one = new byte[]{1};
        put.add(CATALOG_FAMILY, null, zero);
        put2.add(CATALOG_FAMILY, null, one);
        table.put(put);
        table.put(put2);
        Result result = null;
        result = table.getRowOrBefore(beforeFirstRow, CATALOG_FAMILY);
        TestHTable.assertTrue((result == null ? 1 : 0) != 0);
        result = table.getRowOrBefore(firstRow, CATALOG_FAMILY);
        TestHTable.assertTrue((boolean)result.containsColumn(CATALOG_FAMILY, null));
        TestHTable.assertTrue((boolean)Bytes.equals(result.getValue(CATALOG_FAMILY, null), zero));
        result = table.getRowOrBefore(beforeSecondRow, CATALOG_FAMILY);
        TestHTable.assertTrue((boolean)result.containsColumn(CATALOG_FAMILY, null));
        TestHTable.assertTrue((boolean)Bytes.equals(result.getValue(CATALOG_FAMILY, null), zero));
        result = table.getRowOrBefore(row, CATALOG_FAMILY);
        TestHTable.assertTrue((boolean)result.containsColumn(CATALOG_FAMILY, null));
        TestHTable.assertTrue((boolean)Bytes.equals(result.getValue(CATALOG_FAMILY, null), one));
        result = table.getRowOrBefore(Bytes.add(row, one), CATALOG_FAMILY);
        TestHTable.assertTrue((boolean)result.containsColumn(CATALOG_FAMILY, null));
        TestHTable.assertTrue((boolean)Bytes.equals(result.getValue(CATALOG_FAMILY, null), one));
    }

    public void testTableNotFoundExceptionWithATable() {
        try {
            HBaseAdmin admin = new HBaseAdmin(this.conf);
            HTableDescriptor testTableADesc = new HTableDescriptor("table");
            testTableADesc.addFamily(column);
            admin.createTable(testTableADesc);
            new HTable(this.conf, "notATable");
            TestHTable.fail((String)"Should have thrown a TableNotFoundException");
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestHTable.fail((String)("Should have thrown a TableNotFoundException instead of a " + e.getClass()));
        }
    }

    public void testScanVariableReuse() throws Exception {
        Scan scan = new Scan();
        scan.addFamily(CATALOG_FAMILY);
        scan.addColumn(CATALOG_FAMILY, row);
        TestHTable.assertTrue((scan.getFamilyMap().get(CATALOG_FAMILY).size() == 1 ? 1 : 0) != 0);
        scan = new Scan();
        scan.addFamily(CATALOG_FAMILY);
        TestHTable.assertTrue((scan.getFamilyMap().get(CATALOG_FAMILY).size() == 0 ? 1 : 0) != 0);
    }
}

