/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHTablePool
extends HBaseTestCase {
    public void testTableWithStringName() {
        HTablePool pool = new HTablePool(null, Integer.MAX_VALUE);
        String tableName = "testTable";
        HTable table = pool.getTable(tableName);
        TestHTablePool.assertNotNull((Object)table);
        pool.putTable(table);
        HTable sameTable = pool.getTable(tableName);
        TestHTablePool.assertSame((Object)table, (Object)sameTable);
    }

    public void testTableWithByteArrayName() {
        HTablePool pool = new HTablePool(null, Integer.MAX_VALUE);
        byte[] tableName = Bytes.toBytes("testTable");
        HTable table = pool.getTable(tableName);
        TestHTablePool.assertNotNull((Object)table);
        pool.putTable(table);
        HTable sameTable = pool.getTable(tableName);
        TestHTablePool.assertSame((Object)table, (Object)sameTable);
    }

    public void testTableWithMaxSize() {
        HTablePool pool = new HTablePool(null, 2);
        String tableName = "testTable";
        HTable table1 = pool.getTable(tableName);
        HTable table2 = pool.getTable(tableName);
        HTable table3 = pool.getTable(tableName);
        pool.putTable(table1);
        pool.putTable(table2);
        pool.putTable(table3);
        HTable sameTable1 = pool.getTable(tableName);
        HTable sameTable2 = pool.getTable(tableName);
        HTable sameTable3 = pool.getTable(tableName);
        TestHTablePool.assertSame((Object)table1, (Object)sameTable1);
        TestHTablePool.assertSame((Object)table2, (Object)sameTable2);
        TestHTablePool.assertNotSame((Object)table3, (Object)sameTable3);
    }

    public void testTablesWithDifferentNames() {
        HTablePool pool = new HTablePool(null, Integer.MAX_VALUE);
        String tableName1 = "testTable1";
        String tableName2 = "testTable2";
        HTable table1 = pool.getTable(tableName1);
        HTable table2 = pool.getTable(tableName2);
        TestHTablePool.assertNotNull((Object)table2);
        pool.putTable(table1);
        pool.putTable(table2);
        HTable sameTable1 = pool.getTable(tableName1);
        HTable sameTable2 = pool.getTable(tableName2);
        TestHTablePool.assertSame((Object)table1, (Object)sameTable1);
        TestHTablePool.assertSame((Object)table2, (Object)sameTable2);
    }
}

