/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scanner;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.util.Bytes;

public class TestOldAPIHTable
extends HBaseClusterTestCase
implements HConstants {
    private static final String COLUMN_FAMILY_STR = "contents:";
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes("contents:");
    private static final byte[][] COLUMN_FAMILY_ARRAY = new byte[][]{COLUMN_FAMILY};
    private static final HColumnDescriptor column = new HColumnDescriptor(COLUMN_FAMILY);
    private static final byte[] nosuchTable = Bytes.toBytes("nosuchTable");
    private static final byte[] tableAname = Bytes.toBytes("tableA");
    private static final byte[] tableBname = Bytes.toBytes("tableB");
    private static final byte[] row = Bytes.toBytes("row");
    private static final byte[] attrName = Bytes.toBytes("TESTATTR");
    private static final byte[] attrValue = Bytes.toBytes("somevalue");

    public void testTableNotFoundExceptionWithoutAnyTables() {
        try {
            new HTable(this.conf, "notATable");
            TestOldAPIHTable.fail((String)"Should have thrown a TableNotFoundException");
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestOldAPIHTable.fail((String)("Should have thrown a TableNotFoundException instead of a " + e.getClass()));
        }
    }

    public void testGetClosestRowBefore() throws IOException {
        HColumnDescriptor column2 = new HColumnDescriptor(Bytes.toBytes("info2:"));
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor testTableADesc = new HTableDescriptor(tableAname);
        testTableADesc.addFamily(column);
        testTableADesc.addFamily(column2);
        admin.createTable(testTableADesc);
        byte[] firstRow = Bytes.toBytes("ro");
        byte[] beforeFirstRow = Bytes.toBytes("rn");
        byte[] beforeSecondRow = Bytes.toBytes("rov");
        HTable table = new HTable(this.conf, tableAname);
        BatchUpdate batchUpdate = new BatchUpdate(firstRow);
        BatchUpdate batchUpdate2 = new BatchUpdate(row);
        byte[] zero = new byte[]{0};
        byte[] one = new byte[]{1};
        byte[] columnFamilyBytes = Bytes.toBytes(COLUMN_FAMILY_STR);
        batchUpdate.put(COLUMN_FAMILY_STR, zero);
        batchUpdate2.put(COLUMN_FAMILY_STR, one);
        table.commit(batchUpdate);
        table.commit(batchUpdate2);
        RowResult result = null;
        result = table.getClosestRowBefore(beforeFirstRow, columnFamilyBytes);
        TestOldAPIHTable.assertTrue((result == null ? 1 : 0) != 0);
        result = table.getClosestRowBefore(firstRow, columnFamilyBytes);
        TestOldAPIHTable.assertTrue((boolean)result.containsKey(COLUMN_FAMILY_STR));
        TestOldAPIHTable.assertTrue((boolean)Bytes.equals(result.get(COLUMN_FAMILY_STR).getValue(), zero));
        result = table.getClosestRowBefore(beforeSecondRow, columnFamilyBytes);
        TestOldAPIHTable.assertTrue((boolean)result.containsKey(COLUMN_FAMILY_STR));
        TestOldAPIHTable.assertTrue((boolean)Bytes.equals(result.get(COLUMN_FAMILY_STR).getValue(), zero));
        result = table.getClosestRowBefore(row, columnFamilyBytes);
        TestOldAPIHTable.assertTrue((boolean)result.containsKey(COLUMN_FAMILY_STR));
        TestOldAPIHTable.assertTrue((boolean)Bytes.equals(result.get(COLUMN_FAMILY_STR).getValue(), one));
        result = table.getClosestRowBefore(Bytes.add(row, one), columnFamilyBytes);
        TestOldAPIHTable.assertTrue((boolean)result.containsKey(COLUMN_FAMILY_STR));
        TestOldAPIHTable.assertTrue((boolean)Bytes.equals(result.get(COLUMN_FAMILY_STR).getValue(), one));
    }

    public void testTableNotFoundExceptionWithATable() {
        try {
            HBaseAdmin admin = new HBaseAdmin(this.conf);
            HTableDescriptor testTableADesc = new HTableDescriptor("table");
            testTableADesc.addFamily(column);
            admin.createTable(testTableADesc);
            new HTable(this.conf, "notATable");
            TestOldAPIHTable.fail((String)"Should have thrown a TableNotFoundException");
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestOldAPIHTable.fail((String)("Should have thrown a TableNotFoundException instead of a " + e.getClass()));
        }
    }

    public void testGetRow() {
        HTable table = null;
        try {
            int i;
            int i2;
            HColumnDescriptor column2 = new HColumnDescriptor(Bytes.toBytes("info2:"));
            HBaseAdmin admin = new HBaseAdmin(this.conf);
            HTableDescriptor testTableADesc = new HTableDescriptor(tableAname);
            testTableADesc.addFamily(column);
            testTableADesc.addFamily(column2);
            admin.createTable(testTableADesc);
            table = new HTable(this.conf, tableAname);
            BatchUpdate batchUpdate = new BatchUpdate(row);
            for (i2 = 0; i2 < 5; ++i2) {
                batchUpdate.put(COLUMN_FAMILY_STR + i2, Bytes.toBytes(i2));
            }
            table.commit(batchUpdate);
            TestOldAPIHTable.assertTrue((boolean)table.exists(row));
            for (i2 = 0; i2 < 5; ++i2) {
                TestOldAPIHTable.assertTrue((boolean)table.exists(row, Bytes.toBytes(COLUMN_FAMILY_STR + i2)));
            }
            RowResult result = null;
            result = table.getRow(row, new byte[][]{COLUMN_FAMILY});
            for (i = 0; i < 5; ++i) {
                TestOldAPIHTable.assertTrue((boolean)result.containsKey(Bytes.toBytes(COLUMN_FAMILY_STR + i)));
            }
            result = table.getRow(row);
            for (i = 0; i < 5; ++i) {
                TestOldAPIHTable.assertTrue((boolean)result.containsKey(Bytes.toBytes(COLUMN_FAMILY_STR + i)));
            }
            batchUpdate = new BatchUpdate(row);
            batchUpdate.put("info2:a", Bytes.toBytes("a"));
            table.commit(batchUpdate);
            result = table.getRow(row, new byte[][]{COLUMN_FAMILY, Bytes.toBytes("info2:a")});
            for (i = 0; i < 5; ++i) {
                TestOldAPIHTable.assertTrue((boolean)result.containsKey(Bytes.toBytes(COLUMN_FAMILY_STR + i)));
            }
            TestOldAPIHTable.assertTrue((boolean)result.containsKey(Bytes.toBytes("info2:a")));
        }
        catch (IOException e) {
            e.printStackTrace();
            TestOldAPIHTable.fail((String)("Should not have any exception " + e.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHTable() throws IOException {
        byte[] value = "value".getBytes("UTF-8");
        try {
            new HTable(this.conf, nosuchTable);
        }
        catch (TableNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            TestOldAPIHTable.fail();
        }
        HTableDescriptor tableAdesc = new HTableDescriptor(tableAname);
        tableAdesc.addFamily(column);
        HTableDescriptor tableBdesc = new HTableDescriptor(tableBname);
        tableBdesc.addFamily(column);
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        admin.createTable(tableAdesc);
        admin.createTable(tableBdesc);
        HTable a = new HTable(this.conf, tableAname);
        HTableDescriptor meta = a.getConnection().getHTableDescriptor(tableAdesc.getName());
        TestOldAPIHTable.assertTrue((boolean)meta.equals(tableAdesc));
        BatchUpdate batchUpdate = new BatchUpdate(row);
        batchUpdate.put(COLUMN_FAMILY, value);
        a.commit(batchUpdate);
        HTable newA = new HTable(this.conf, tableAname);
        HTable b = new HTable(this.conf, tableBname);
        Scanner s = newA.getScanner(COLUMN_FAMILY_ARRAY, EMPTY_START_ROW);
        try {
            for (RowResult r : s) {
                batchUpdate = new BatchUpdate(r.getRow());
                for (Map.Entry<byte[], Cell> e : r.entrySet()) {
                    batchUpdate.put(e.getKey(), e.getValue().getValue());
                }
                b.commit(batchUpdate);
            }
        }
        finally {
            s.close();
        }
        try {
            HTable anotherA = new HTable(this.conf, tableAname);
            anotherA.get(row, COLUMN_FAMILY);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestOldAPIHTable.fail();
        }
        try {
            HTableDescriptor desc = new HTableDescriptor(a.getTableDescriptor());
            admin.disableTable(tableAname);
            desc.setValue(attrName, attrValue);
            for (HColumnDescriptor c : desc.getFamilies()) {
                c.setValue(attrName, attrValue);
            }
            admin.modifyTable(tableAname, HConstants.Modify.TABLE_SET_HTD, desc);
            admin.enableTable(tableAname);
            desc = a.getTableDescriptor();
            if (Bytes.compareTo(desc.getName(), tableAname) != 0) {
                TestOldAPIHTable.fail((String)"wrong table descriptor returned");
            }
            if ((value = desc.getValue(attrName)) == null) {
                TestOldAPIHTable.fail((String)"missing HTD attribute value");
            }
            if (Bytes.compareTo(value, attrValue) != 0) {
                TestOldAPIHTable.fail((String)"HTD attribute value is incorrect");
            }
            for (HColumnDescriptor c : desc.getFamilies()) {
                value = c.getValue(attrName);
                if (value == null) {
                    TestOldAPIHTable.fail((String)"missing HCD attribute value");
                }
                if (Bytes.compareTo(value, attrValue) == 0) continue;
                TestOldAPIHTable.fail((String)"HCD attribute value is incorrect");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestOldAPIHTable.fail();
        }
    }
}

