/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class TestHFileOutputFormat
extends HBaseTestCase {
    private static final int ROWSPERSPLIT = 1024;

    public void testWritingPEData() throws Exception {
        this.conf.setInt("io.sort.mb", 20);
        this.conf.setLong("hbase.hregion.max.filesize", 65536L);
        Job job = new Job((Configuration)this.conf, this.getName());
        job.setInputFormatClass(PEInputFormat.class);
        job.setMapperClass(PEtoKVMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
        job.setReducerClass(KeyValueSortReducer.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)this.testDir);
        TestHFileOutputFormat.assertTrue((boolean)job.waitForCompletion(false));
        FileStatus[] files = this.fs.listStatus(this.testDir);
        TestHFileOutputFormat.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    static class PEtoKVMapper
    extends Mapper<ImmutableBytesWritable, ImmutableBytesWritable, ImmutableBytesWritable, KeyValue> {
        PEtoKVMapper() {
        }

        protected void map(ImmutableBytesWritable key, ImmutableBytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)new KeyValue(key.get(), PerformanceEvaluation.FAMILY_NAME, PerformanceEvaluation.QUALIFIER_NAME, value.get()));
        }
    }

    static class PEInputFormat
    extends InputFormat<ImmutableBytesWritable, ImmutableBytesWritable> {
        PEInputFormat() {
        }

        public RecordReader<ImmutableBytesWritable, ImmutableBytesWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            final int startrow = ((PEInputSplit)split).getIndex() * 1024;
            return new RecordReader<ImmutableBytesWritable, ImmutableBytesWritable>(){
                private int counter;
                private ImmutableBytesWritable key;
                private ImmutableBytesWritable value;
                private final Random random;
                {
                    this.counter = startrow;
                    this.random = new Random(System.currentTimeMillis());
                }

                public void close() throws IOException {
                }

                public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                    return this.key;
                }

                public ImmutableBytesWritable getCurrentValue() throws IOException, InterruptedException {
                    return this.value;
                }

                public float getProgress() throws IOException, InterruptedException {
                    return (1024 - this.counter) / this.counter;
                }

                public void initialize(InputSplit arg0, TaskAttemptContext arg1) throws IOException, InterruptedException {
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    if (this.counter - startrow > 1024) {
                        return false;
                    }
                    ++this.counter;
                    this.key = new ImmutableBytesWritable(PerformanceEvaluation.format(this.counter));
                    this.value = new ImmutableBytesWritable(PerformanceEvaluation.generateValue(this.random));
                    return true;
                }
            };
        }

        public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
            int count = context.getConfiguration().getInt("mapred.map.tasks", 1);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(count);
            for (int i = 0; i < count; ++i) {
                splits.add(new PEInputSplit(i));
            }
            return splits;
        }

        static class PEInputSplit
        extends InputSplit
        implements Writable {
            private int index = -1;

            PEInputSplit() {
            }

            PEInputSplit(int i) {
                this.index = i;
            }

            int getIndex() {
                return this.index;
            }

            public long getLength() throws IOException, InterruptedException {
                return 1024L;
            }

            public String[] getLocations() throws IOException, InterruptedException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
                this.index = in.readInt();
            }

            public void write(DataOutput out) throws IOException {
                out.writeInt(this.index);
            }
        }
    }
}

