/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RegionServerOperation;

abstract class ProcessRegionStatusChange
extends RegionServerOperation {
    protected final boolean isMetaTable;
    protected final HRegionInfo regionInfo;
    private volatile MetaRegion metaRegion = null;
    protected volatile byte[] metaRegionName = null;

    public ProcessRegionStatusChange(HMaster master, HRegionInfo regionInfo) {
        super(master);
        this.regionInfo = regionInfo;
        this.isMetaTable = regionInfo.isMetaTable();
    }

    protected boolean metaRegionAvailable() {
        boolean available = true;
        if (this.isMetaTable) {
            if (!this.rootAvailable()) {
                this.requeue();
                available = false;
            }
        } else if (!this.master.regionManager.isInitialRootScanComplete() || !this.metaTableAvailable()) {
            this.requeue();
            available = false;
        }
        return available;
    }

    protected MetaRegion getMetaRegion() {
        if (this.isMetaTable) {
            this.metaRegionName = HRegionInfo.ROOT_REGIONINFO.getRegionName();
            this.metaRegion = new MetaRegion(this.master.getRootRegionLocation(), HRegionInfo.ROOT_REGIONINFO);
        } else {
            this.metaRegion = this.master.regionManager.getFirstMetaRegionForRegion(this.regionInfo);
            if (this.metaRegion != null) {
                this.metaRegionName = this.metaRegion.getRegionName();
            }
        }
        return this.metaRegion;
    }
}

