/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen.regionserver;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.migration.nineteen.io.BloomFilterMapFile;
import org.apache.hadoop.hbase.migration.nineteen.io.HalfMapFileReader;
import org.apache.hadoop.hbase.migration.nineteen.io.Reference;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;

public class HStoreFile
implements HConstants {
    static final Log LOG = LogFactory.getLog((String)HStoreFile.class.getName());
    static final byte INFO_SEQ_NUM = 0;
    static final byte MAJOR_COMPACTION = 1;
    static final String HSTORE_DATFILE_DIR = "mapfiles";
    static final String HSTORE_INFO_DIR = "info";
    static final String HSTORE_FILTER_DIR = "filter";
    private static final Random rand = new Random();
    private final Path basedir;
    private final int encodedRegionName;
    private final byte[] colFamily;
    private final long fileId;
    private final HBaseConfiguration conf;
    private final FileSystem fs;
    private final Reference reference;
    private final HRegionInfo hri;
    private boolean majorCompaction = false;
    private long indexLength;
    private static final Pattern REF_NAME_PARSER = Pattern.compile("^(\\d+)(?:\\.(.+))?$");

    public HStoreFile(HBaseConfiguration conf, FileSystem fs, Path basedir, int encodedName, byte[] colFamily, long fileId, Reference ref) throws IOException {
        this(conf, fs, basedir, encodedName, colFamily, fileId, ref, false);
    }

    HStoreFile(HBaseConfiguration conf, FileSystem fs, Path basedir, int encodedName, byte[] colFamily, long fileId, Reference ref, boolean mc) throws IOException {
        this.conf = conf;
        this.fs = fs;
        this.basedir = basedir;
        this.encodedRegionName = encodedName;
        this.colFamily = colFamily;
        this.hri = null;
        long id = fileId;
        if (id == -1L) {
            Path mapdir = HStoreFile.getMapDir(basedir, this.encodedRegionName, colFamily);
            Path testpath = null;
            while (fs.exists(testpath = new Path(mapdir, HStoreFile.createHStoreFilename(id = Math.abs(rand.nextLong()), -1)))) {
            }
        }
        this.fileId = id;
        this.reference = ref;
        this.majorCompaction = mc;
    }

    boolean isReference() {
        return this.reference != null;
    }

    public static boolean isReference(Path p) {
        return HStoreFile.isReference(p, REF_NAME_PARSER.matcher(p.getName()));
    }

    private static boolean isReference(Path p, Matcher m) {
        if (m == null || !m.matches()) {
            LOG.warn((Object)("Failed match of store file name " + p.toString()));
            throw new RuntimeException("Failed match of store file name " + p.toString());
        }
        return m.groupCount() > 1 && m.group(2) != null;
    }

    Reference getReference() {
        return this.reference;
    }

    int getEncodedRegionName() {
        return this.encodedRegionName;
    }

    byte[] getColFamily() {
        return this.colFamily;
    }

    long getFileId() {
        return this.fileId;
    }

    Path getMapFilePath() {
        if (this.isReference()) {
            return this.getMapFilePath(this.encodedRegionName, this.fileId, this.reference.getEncodedRegionName());
        }
        return this.getMapFilePath(this.encodedRegionName, this.fileId);
    }

    private Path getMapFilePath(Reference r) {
        if (r == null) {
            return this.getMapFilePath();
        }
        return this.getMapFilePath(r.getEncodedRegionName(), r.getFileId());
    }

    private Path getMapFilePath(int encodedName, long fid) {
        return this.getMapFilePath(encodedName, fid, -1);
    }

    private Path getMapFilePath(int encodedName, long fid, int ern) {
        return new Path(HStoreFile.getMapDir(this.basedir, encodedName, this.colFamily), HStoreFile.createHStoreFilename(fid, ern));
    }

    Path getInfoFilePath() {
        if (this.isReference()) {
            return this.getInfoFilePath(this.encodedRegionName, this.fileId, this.reference.getEncodedRegionName());
        }
        return this.getInfoFilePath(this.encodedRegionName, this.fileId);
    }

    private Path getInfoFilePath(int encodedName, long fid) {
        return this.getInfoFilePath(encodedName, fid, -1);
    }

    private Path getInfoFilePath(int encodedName, long fid, int ern) {
        return new Path(HStoreFile.getInfoDir(this.basedir, encodedName, this.colFamily), HStoreFile.createHStoreFilename(fid, ern));
    }

    void splitStoreFile(HStoreFile dstA, HStoreFile dstB, FileSystem fs) throws IOException {
        dstA.writeReferenceFiles(fs);
        dstB.writeReferenceFiles(fs);
    }

    void writeReferenceFiles(FileSystem fs) throws IOException {
        this.createOrFail(fs, this.getMapFilePath());
        this.writeSplitInfo(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSplitInfo(FileSystem fs) throws IOException {
        Path p = this.getInfoFilePath();
        if (fs.exists(p)) {
            throw new IOException("File already exists " + p.toString());
        }
        FSDataOutputStream out = fs.create(p);
        try {
            this.reference.write((DataOutput)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Reference readSplitInfo(Path p, FileSystem fs) throws IOException {
        FSDataInputStream in = fs.open(p);
        try {
            Reference r = new Reference();
            r.readFields((DataInput)in);
            Reference reference = r;
            return reference;
        }
        finally {
            in.close();
        }
    }

    private void createOrFail(FileSystem fs, Path p) throws IOException {
        if (fs.exists(p)) {
            throw new IOException("File already exists " + p.toString());
        }
        if (!fs.createNewFile(p)) {
            throw new IOException("Failed create of " + p);
        }
    }

    public long loadInfo(FileSystem filesystem) throws IOException {
        Path p = null;
        p = this.isReference() ? this.getInfoFilePath(this.reference.getEncodedRegionName(), this.reference.getFileId()) : this.getInfoFilePath();
        long length = filesystem.getFileStatus(p).getLen();
        boolean hasMoreThanSeqNum = length > 16L;
        DataInputStream in = new DataInputStream((InputStream)filesystem.open(p));
        try {
            byte flag = in.readByte();
            if (flag == 0) {
                if (hasMoreThanSeqNum && (flag = in.readByte()) == 1) {
                    this.majorCompaction = in.readBoolean();
                }
                long l = in.readLong();
                return l;
            }
            throw new IOException("Cannot process log file: " + p);
        }
        finally {
            in.close();
        }
    }

    void writeInfo(FileSystem filesystem, long infonum) throws IOException {
        this.writeInfo(filesystem, infonum, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInfo(FileSystem filesystem, long infonum, boolean mc) throws IOException {
        Path p = this.getInfoFilePath();
        FSDataOutputStream out = filesystem.create(p);
        try {
            out.writeByte(0);
            out.writeLong(infonum);
            if (mc) {
                this.majorCompaction = mc;
                out.writeByte(1);
                out.writeBoolean(mc);
            }
        }
        finally {
            out.close();
        }
    }

    public void delete() throws IOException {
        this.fs.delete(this.getMapFilePath(), true);
        this.fs.delete(this.getInfoFilePath(), true);
    }

    public boolean rename(FileSystem fs, HStoreFile hsf) throws IOException {
        Path src = this.getMapFilePath();
        if (!fs.exists(src)) {
            throw new FileNotFoundException(src.toString());
        }
        boolean success = fs.rename(src, hsf.getMapFilePath());
        if (!success) {
            LOG.warn((Object)("Failed rename of " + src + " to " + hsf.getMapFilePath()));
        } else {
            src = this.getInfoFilePath();
            if (!fs.exists(src)) {
                throw new FileNotFoundException(src.toString());
            }
            success = fs.rename(src, hsf.getInfoFilePath());
            if (!success) {
                LOG.warn((Object)("Failed rename of " + src + " to " + hsf.getInfoFilePath()));
            }
        }
        return success;
    }

    public synchronized BloomFilterMapFile.Reader getReader(FileSystem fs, boolean bloomFilter, boolean blockCacheEnabled) throws IOException {
        if (this.isReference()) {
            return new HalfMapFileReader(fs, this.getMapFilePath(this.reference).toString(), this.conf, this.reference.getFileRegion(), this.reference.getMidkey(), bloomFilter, blockCacheEnabled, this.hri);
        }
        return new BloomFilterMapFile.Reader(fs, this.getMapFilePath().toString(), this.conf, bloomFilter, blockCacheEnabled, this.hri);
    }

    public MapFile.Writer getWriter(FileSystem fs, SequenceFile.CompressionType compression, boolean bloomFilter, int nrows) throws IOException {
        if (this.isReference()) {
            throw new IOException("Illegal Access: Cannot get a writer on aHStoreFile reference");
        }
        return new BloomFilterMapFile.Writer(this.conf, fs, this.getMapFilePath().toString(), compression, bloomFilter, nrows, this.hri);
    }

    public long length() throws IOException {
        Path p = new Path(this.getMapFilePath(this.reference), "data");
        long l = p.getFileSystem((Configuration)this.conf).getFileStatus(p).getLen();
        return this.isReference() ? l / 2L : l;
    }

    public synchronized long indexLength() throws IOException {
        if (this.indexLength == 0L) {
            Path p = new Path(this.getMapFilePath(this.reference), "index");
            this.indexLength = p.getFileSystem((Configuration)this.conf).getFileStatus(p).getLen();
        }
        return this.indexLength;
    }

    public String toString() {
        return this.encodedRegionName + "/" + Bytes.toString(this.colFamily) + "/" + this.fileId + (this.isReference() ? "-" + this.reference.toString() : "");
    }

    public boolean isMajorCompaction() {
        return this.majorCompaction;
    }

    private static String createHStoreFilename(long fid, int encodedRegionName) {
        return Long.toString(fid) + (encodedRegionName != -1 ? "." + encodedRegionName : "");
    }

    public static Path getMapDir(Path dir, int encodedRegionName, byte[] f) {
        return HStoreFile.getFamilySubDir(dir, encodedRegionName, f, HSTORE_DATFILE_DIR);
    }

    public static Path getInfoDir(Path dir, int encodedRegionName, byte[] f) {
        return HStoreFile.getFamilySubDir(dir, encodedRegionName, f, HSTORE_INFO_DIR);
    }

    @Deprecated
    public static Path getFilterDir(Path dir, int encodedRegionName, byte[] f) {
        return HStoreFile.getFamilySubDir(dir, encodedRegionName, f, HSTORE_FILTER_DIR);
    }

    private static Path getFamilySubDir(Path base, int encodedRegionName, byte[] f, String subdir) {
        return new Path(base, new Path(Integer.toString(encodedRegionName), new Path(Bytes.toString(f), subdir)));
    }
}

