/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.LeaseListener;
import org.apache.hadoop.hbase.Leases;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.UnknownRowLockException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerConnection;
import org.apache.hadoop.hbase.client.ServerConnectionManager;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.LogFlusher;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWrapper;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class HRegionServer
implements HConstants,
HRegionInterface,
HBaseRPCErrorHandler,
Runnable,
Watcher {
    static final Log LOG = LogFactory.getLog(HRegionServer.class);
    private static final HMsg REPORT_EXITING = new HMsg(HMsg.Type.MSG_REPORT_EXITING);
    private static final HMsg REPORT_QUIESCED = new HMsg(HMsg.Type.MSG_REPORT_QUIESCED);
    protected final AtomicBoolean stopRequested = new AtomicBoolean(false);
    protected final AtomicBoolean quiesced = new AtomicBoolean(false);
    protected final AtomicBoolean safeMode = new AtomicBoolean(true);
    protected volatile boolean abortRequested;
    protected volatile boolean fsOk;
    protected HServerInfo serverInfo;
    protected final HBaseConfiguration conf;
    private final ServerConnection connection;
    protected final AtomicBoolean haveRootRegion = new AtomicBoolean(false);
    private FileSystem fs;
    private Path rootDir;
    private final Random rand = new Random();
    protected final Map<Integer, HRegion> onlineRegions = new ConcurrentHashMap<Integer, HRegion>();
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<HMsg> outboundMsgs = Collections.synchronizedList(new ArrayList());
    final int numRetries;
    protected final int threadWakeFrequency;
    private final int msgInterval;
    private final int serverLeaseTimeout;
    protected final int numRegionsToReport;
    private final long maxScannerResultSize;
    private HMasterRegionInterface hbaseMaster;
    HBaseServer server;
    private Leases leases;
    private volatile AtomicInteger requestCount = new AtomicInteger();
    InfoServer infoServer;
    public static final String REGIONSERVER = "regionserver";
    private final LinkedList<byte[]> reservedSpace = new LinkedList();
    private RegionServerMetrics metrics;
    CompactSplitThread compactSplitThread;
    MemStoreFlusher cacheFlusher;
    Chore majorCompactionChecker;
    protected volatile HLog hlog;
    LogRoller hlogRoller;
    LogFlusher hlogFlusher;
    protected volatile boolean isOnline;
    final Map<String, InternalScanner> scanners = new ConcurrentHashMap<String, InternalScanner>();
    private ZooKeeperWrapper zooKeeperWrapper;
    private final Sleeper sleeper;
    private final long rpcTimeout;
    private final HServerAddress address;
    private Thread regionServerThread;
    private final AtomicBoolean shutdownHDFS = new AtomicBoolean(true);
    private final String machineName;
    private Thread hdfsShutdownThread;
    final BlockingQueue<ToDoEntry> toDo = new LinkedBlockingQueue<ToDoEntry>();
    private Worker worker;
    private Thread workerThread;
    Map<String, Integer> rowlocks = new ConcurrentHashMap<String, Integer>();

    public HRegionServer(HBaseConfiguration conf) throws IOException {
        this.machineName = DNS.getDefaultHost((String)conf.get("hbase.regionserver.dns.interface", "default"), (String)conf.get("hbase.regionserver.dns.nameserver", "default"));
        String addressStr = this.machineName + ":" + conf.get("hbase.regionserver.port", Integer.toString(60020));
        this.address = new HServerAddress(addressStr);
        LOG.info((Object)("My address is " + this.address));
        this.abortRequested = false;
        this.fsOk = true;
        this.conf = conf;
        this.connection = ServerConnectionManager.getConnection(conf);
        this.isOnline = false;
        this.numRetries = conf.getInt("hbase.client.retries.number", 2);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 1000);
        this.serverLeaseTimeout = conf.getInt("hbase.master.lease.period", 120000);
        this.sleeper = new Sleeper(this.msgInterval, this.stopRequested);
        this.maxScannerResultSize = conf.getLong("hbase.client.scanner.max.result.size", Long.MAX_VALUE);
        this.worker = new Worker();
        this.numRegionsToReport = conf.getInt("hbase.regionserver.numregionstoreport", 10);
        this.rpcTimeout = conf.getLong("hbase.regionserver.lease.period", 60000L);
        this.reinitialize();
    }

    private void reinitialize() throws IOException {
        this.abortRequested = false;
        this.stopRequested.set(false);
        this.shutdownHDFS.set(true);
        this.server = HBaseRPC.getServer(this, this.address.getBindAddress(), this.address.getPort(), this.conf.getInt("hbase.regionserver.handler.count", 10), false, this.conf);
        this.server.setErrorHandler(this);
        this.serverInfo = new HServerInfo(new HServerAddress(new InetSocketAddress(this.address.getBindAddress(), this.server.getListenerAddress().getPort())), System.currentTimeMillis(), this.conf.getInt("hbase.regionserver.info.port", 60030), this.machineName);
        if (this.serverInfo.getServerAddress() == null) {
            throw new NullPointerException("Server address cannot be null; hbase-958 debugging");
        }
        this.reinitializeThreads();
        this.reinitializeZooKeeper();
        int nbBlocks = this.conf.getInt("hbase.regionserver.nbreservationblocks", 4);
        for (int i = 0; i < nbBlocks; ++i) {
            this.reservedSpace.add(new byte[0x500000]);
        }
    }

    private void reinitializeZooKeeper() throws IOException {
        this.zooKeeperWrapper = new ZooKeeperWrapper(this.conf, this);
        this.watchMasterAddress();
    }

    private void reinitializeThreads() {
        this.workerThread = new Thread(this.worker);
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplitThread(this);
        this.hlogRoller = new LogRoller(this);
        this.hlogFlusher = new LogFlusher(this.threadWakeFrequency, this.stopRequested);
        int multiplier = this.conf.getInt("hbase.server.thread.wakefrequency.multiplier", 1000);
        this.majorCompactionChecker = new MajorCompactionChecker(this, this.threadWakeFrequency * multiplier, this.stopRequested);
        this.leases = new Leases(this.conf.getInt("hbase.regionserver.lease.period", 60000), this.threadWakeFrequency);
    }

    public void process(WatchedEvent event) {
        Watcher.Event.EventType type = event.getType();
        Watcher.Event.KeeperState state = event.getState();
        LOG.info((Object)("Got ZooKeeper event, state: " + state + ", type: " + type + ", path: " + event.getPath()));
        if (this.stopRequested.get()) {
            LOG.debug((Object)"Ignoring ZooKeeper event while shutting down");
            return;
        }
        if (state == Watcher.Event.KeeperState.Expired) {
            LOG.error((Object)"ZooKeeper session expired");
            boolean restart = this.conf.getBoolean("hbase.regionserver.restart.on.zk.expire", false);
            if (restart) {
                this.restart();
            } else {
                this.abort();
            }
        } else if (type == Watcher.Event.EventType.NodeDeleted) {
            this.watchMasterAddress();
        } else if (type == Watcher.Event.EventType.NodeCreated) {
            this.getMaster();
            this.watchMasterAddress();
        }
    }

    private void watchMasterAddress() {
        while (!this.stopRequested.get() && !this.zooKeeperWrapper.watchMasterAddress(this)) {
            LOG.warn((Object)"Unable to set watcher on ZooKeeper master address. Retrying.");
            this.sleeper.sleep();
        }
    }

    private void restart() {
        LOG.info((Object)"Restarting Region Server");
        this.shutdownHDFS.set(false);
        this.abort();
        Threads.shutdown(this.regionServerThread);
        boolean done = false;
        while (!done) {
            try {
                this.reinitialize();
                done = true;
            }
            catch (IOException e) {
                LOG.debug((Object)"Error trying to reinitialize ZooKeeper", (Throwable)e);
            }
        }
        Thread t = new Thread(this);
        String name = this.regionServerThread.getName();
        t.setName(name);
        t.start();
    }

    public ZooKeeperWrapper getZooKeeperWrapper() {
        return this.zooKeeperWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LruBlockCache c;
        block53: {
            this.regionServerThread = Thread.currentThread();
            boolean quiesceRequested = false;
            try {
                MapWritable w = null;
                while (!this.stopRequested.get()) {
                    w = this.reportForDuty();
                    if (w != null) {
                        this.init(w);
                        break;
                    }
                    this.sleeper.sleep();
                    LOG.warn((Object)"No response from master on reportForDuty. Sleeping and then trying again.");
                }
                HMsg[] outboundArray = null;
                long lastMsg = 0L;
                int tries = 0;
                while (!this.stopRequested.get() && this.isHealthy()) {
                    HServerAddress rootServer;
                    if (!this.haveRootRegion.get() && (rootServer = this.zooKeeperWrapper.readRootRegionLocation()) != null) {
                        this.connection.setRootRegionLocation(new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, rootServer));
                        this.haveRootRegion.set(true);
                    }
                    long now = System.currentTimeMillis();
                    if (lastMsg != 0L && now - lastMsg >= (long)this.serverLeaseTimeout) {
                        LOG.warn((Object)("unable to report to master for " + (now - lastMsg) + " milliseconds - retrying"));
                    }
                    if (now - lastMsg >= (long)this.msgInterval || (outboundArray == null || outboundArray.length == 0) && !this.outboundMsgs.isEmpty()) {
                        try {
                            this.doMetrics();
                            MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                            HServerLoad hsl = new HServerLoad(this.requestCount.get(), (int)(memory.getUsed() / 1024L / 1024L), (int)(memory.getMax() / 1024L / 1024L));
                            for (HRegion r : this.onlineRegions.values()) {
                                hsl.addRegionInfo(this.createRegionLoad(r));
                            }
                            this.serverInfo.setLoad(hsl);
                            this.requestCount.set(0);
                            outboundArray = this.getOutboundMsgs(outboundArray);
                            HMsg[] msgs = this.hbaseMaster.regionServerReport(this.serverInfo, outboundArray, this.getMostLoadedRegions());
                            lastMsg = System.currentTimeMillis();
                            outboundArray = this.updateOutboundMsgs(outboundArray);
                            if (this.quiesced.get() && this.onlineRegions.size() == 0) {
                                LOG.info((Object)"Server quiesced and not serving any regions. Starting shutdown");
                                this.stopRequested.set(true);
                                this.outboundMsgs.clear();
                                continue;
                            }
                            boolean restart = false;
                            block31: for (int i = 0; !restart && !this.stopRequested.get() && i < msgs.length; ++i) {
                                LOG.info((Object)msgs[i].toString());
                                if (this.safeMode.get() && this.zooKeeperWrapper.checkOutOfSafeMode()) {
                                    this.connection.unsetRootRegionLocation();
                                    AtomicBoolean atomicBoolean = this.safeMode;
                                    synchronized (atomicBoolean) {
                                        this.safeMode.set(false);
                                        this.safeMode.notifyAll();
                                    }
                                }
                                switch (msgs[i].getType()) {
                                    case MSG_CALL_SERVER_STARTUP: {
                                        if (this.checkFileSystem()) {
                                            this.closeAllRegions();
                                            try {
                                                this.hlog.closeAndDelete();
                                            }
                                            catch (Exception e) {
                                                LOG.error((Object)"error closing and deleting HLog", (Throwable)e);
                                            }
                                            try {
                                                this.serverInfo.setStartCode(System.currentTimeMillis());
                                                this.hlog = this.setupHLog();
                                                this.hlogFlusher.setHLog(this.hlog);
                                            }
                                            catch (IOException e) {
                                                this.abortRequested = true;
                                                this.stopRequested.set(true);
                                                e = RemoteExceptionHandler.checkIOException(e);
                                                LOG.fatal((Object)"error restarting server", (Throwable)e);
                                                continue block31;
                                            }
                                            this.reportForDuty();
                                            restart = true;
                                            continue block31;
                                        }
                                        LOG.fatal((Object)"file system available check failed. Shutting down server.");
                                        continue block31;
                                    }
                                    case MSG_REGIONSERVER_STOP: {
                                        this.stopRequested.set(true);
                                        continue block31;
                                    }
                                    case MSG_REGIONSERVER_QUIESCE: {
                                        if (quiesceRequested) continue block31;
                                        try {
                                            this.toDo.put(new ToDoEntry(msgs[i]));
                                        }
                                        catch (InterruptedException e) {
                                            throw new RuntimeException("Putting into msgQueue was interrupted.", e);
                                        }
                                        quiesceRequested = true;
                                        continue block31;
                                    }
                                    default: {
                                        if (!this.fsOk) continue block31;
                                        try {
                                            this.toDo.put(new ToDoEntry(msgs[i]));
                                            continue block31;
                                        }
                                        catch (InterruptedException e) {
                                            throw new RuntimeException("Putting into msgQueue was interrupted.", e);
                                        }
                                    }
                                }
                            }
                            tries = 0;
                            if (restart || this.stopRequested.get()) {
                                this.toDo.clear();
                                continue;
                            }
                        }
                        catch (Exception e2) {
                            IOException e2;
                            if (e2 instanceof IOException) {
                                e2 = RemoteExceptionHandler.checkIOException((IOException)e2);
                            }
                            if (++tries > 0 && tries % this.numRetries == 0) {
                                this.checkFileSystem();
                            }
                            if (this.stopRequested.get()) {
                                LOG.info((Object)"Stop requested, clearing toDo despite exception");
                                this.toDo.clear();
                                continue;
                            }
                            LOG.warn((Object)("Attempt=" + tries), (Throwable)e2);
                            lastMsg = System.currentTimeMillis();
                        }
                    }
                    this.housekeeping();
                    this.sleeper.sleep(lastMsg);
                }
            }
            catch (Throwable t) {
                if (this.checkOOME(t)) break block53;
                LOG.fatal((Object)"Unhandled exception. Aborting...", t);
                this.abort();
            }
        }
        this.leases.closeAfterLeasesExpire();
        this.worker.stop();
        this.server.stop();
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((c = (LruBlockCache)StoreFile.getBlockCache(this.conf)) != null) {
            c.shutdown();
        }
        this.cacheFlusher.interruptIfNecessary();
        this.hlogFlusher.interrupt();
        this.compactSplitThread.interruptIfNecessary();
        this.hlogRoller.interruptIfNecessary();
        this.majorCompactionChecker.interrupt();
        if (this.abortRequested) {
            if (this.fsOk) {
                try {
                    if (this.hlog != null) {
                        this.hlog.close();
                        LOG.info((Object)"On abort, closed hlog");
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to close log in abort", RemoteExceptionHandler.checkThrowable(e));
                }
                this.closeAllRegions();
            }
            LOG.info((Object)("aborting server at: " + this.serverInfo.getServerAddress().toString()));
        } else {
            ArrayList<HRegion> closedRegions = this.closeAllRegions();
            try {
                if (this.hlog != null) {
                    this.hlog.closeAndDelete();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Close and delete failed", RemoteExceptionHandler.checkThrowable(e));
            }
            try {
                HMsg[] exitMsg = new HMsg[closedRegions.size() + 1];
                exitMsg[0] = REPORT_EXITING;
                int i = 1;
                for (HRegion region : closedRegions) {
                    exitMsg[i++] = new HMsg(HMsg.Type.MSG_REPORT_CLOSE, region.getRegionInfo());
                }
                LOG.info((Object)("telling master that region server is shutting down at: " + this.serverInfo.getServerAddress().toString()));
                this.hbaseMaster.regionServerReport(this.serverInfo, exitMsg, null);
            }
            catch (Throwable e) {
                LOG.warn((Object)"Failed to send exiting message to master: ", RemoteExceptionHandler.checkThrowable(e));
            }
            LOG.info((Object)("stopping server at: " + this.serverInfo.getServerAddress().toString()));
        }
        if (this.hbaseMaster != null) {
            HBaseRPC.stopProxy(this.hbaseMaster);
            this.hbaseMaster = null;
        }
        this.join();
        this.zooKeeperWrapper.close();
        if (this.shutdownHDFS.get()) {
            this.runThread(this.hdfsShutdownThread, this.conf.getLong("hbase.dfs.shutdown.wait", 30000L));
        }
        LOG.info((Object)(Thread.currentThread().getName() + " exiting"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HMsg[] getOutboundMsgs(HMsg[] msgs) {
        if (msgs != null) {
            return msgs;
        }
        List<HMsg> list = this.outboundMsgs;
        synchronized (list) {
            return this.outboundMsgs.toArray(new HMsg[this.outboundMsgs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HMsg[] updateOutboundMsgs(HMsg[] msgs) {
        if (msgs == null) {
            return null;
        }
        List<HMsg> list = this.outboundMsgs;
        synchronized (list) {
            for (HMsg m : msgs) {
                int index = this.outboundMsgs.indexOf(m);
                if (index == -1) continue;
                this.outboundMsgs.remove(index);
            }
        }
        return null;
    }

    public void runThread(Thread t, long dfsShutdownWait) {
        if (t == null) {
            return;
        }
        t.start();
        Threads.shutdown(t, dfsShutdownWait);
    }

    public Thread setHDFSShutdownThreadOnExit(Thread t) {
        Thread old = this.hdfsShutdownThread;
        this.hdfsShutdownThread = t;
        return old;
    }

    protected void init(MapWritable c) throws IOException {
        try {
            for (Map.Entry e : c.entrySet()) {
                String key = ((Writable)e.getKey()).toString();
                String value = ((Writable)e.getValue()).toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Config from master: " + key + "=" + value));
                }
                this.conf.set(key, value);
            }
            String hra = this.conf.get("hbase.regionserver.address");
            if (this.address != null) {
                HServerAddress hsa = new HServerAddress(hra, this.serverInfo.getServerAddress().getPort());
                LOG.info((Object)("Master passed us address to use. Was=" + this.serverInfo.getServerAddress() + ", Now=" + hra));
                this.serverInfo.setServerAddress(hsa);
            }
            this.conf.set("fs.default.name", this.conf.get("hbase.rootdir"));
            this.fs = FileSystem.get((Configuration)this.conf);
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(this, Thread.currentThread()));
            this.hdfsShutdownThread = this.suppressHdfsShutdownHook();
            this.rootDir = new Path(this.conf.get("hbase.rootdir"));
            this.hlog = this.setupHLog();
            this.hlogFlusher.setHLog(this.hlog);
            this.metrics = new RegionServerMetrics();
            this.startServiceThreads();
            this.isOnline = true;
        }
        catch (Throwable e) {
            this.isOnline = false;
            this.stopRequested.set(true);
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HServerLoad.RegionLoad createRegionLoad(HRegion r) {
        byte[] name = r.getRegionName();
        int stores = 0;
        int storefiles = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.memstoreSize.get() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        Map<byte[], Store> map = r.stores;
        synchronized (map) {
            stores += r.stores.size();
            for (Store store : r.stores.values()) {
                storefiles += store.getStorefilesCount();
                storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
                storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
            }
        }
        return new HServerLoad.RegionLoad(name, stores, storefiles, storefileSizeMB, memstoreSizeMB, storefileIndexSizeMB);
    }

    public HServerLoad.RegionLoad createRegionLoad(byte[] regionName) {
        return this.createRegionLoad(this.onlineRegions.get(Bytes.mapKey(regionName)));
    }

    private Throwable cleanup(Throwable t) {
        return this.cleanup(t, null);
    }

    private Throwable cleanup(Throwable t, String msg) {
        if (msg == null) {
            LOG.error((Object)"", RemoteExceptionHandler.checkThrowable(t));
        } else {
            LOG.error((Object)msg, RemoteExceptionHandler.checkThrowable(t));
        }
        if (!this.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    private IOException convertThrowableToIOE(Throwable t) {
        return this.convertThrowableToIOE(t, null);
    }

    private IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
            LOG.fatal((Object)"OutOfMemoryError, aborting.", e);
            this.abort();
            stop = true;
        }
        return stop;
    }

    protected boolean checkFileSystem() {
        if (this.fsOk && this.fs != null) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
            }
            catch (IOException e) {
                LOG.fatal((Object)"Shutting down HRegionServer: file system not available", (Throwable)e);
                this.abort();
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    private Thread suppressHdfsShutdownHook() {
        try {
            Field field = FileSystem.class.getDeclaredField("clientFinalizer");
            field.setAccessible(true);
            Thread hdfsClientFinalizer = (Thread)field.get(null);
            if (hdfsClientFinalizer == null) {
                throw new RuntimeException("client finalizer is null, can't suppress!");
            }
            Runtime.getRuntime().removeShutdownHook(hdfsClientFinalizer);
            return hdfsClientFinalizer;
        }
        catch (NoSuchFieldException nsfe) {
            LOG.fatal((Object)"Couldn't find field 'clientFinalizer' in FileSystem!", (Throwable)nsfe);
            throw new RuntimeException("Failed to suppress HDFS shutdown hook");
        }
        catch (IllegalAccessException iae) {
            LOG.fatal((Object)"Couldn't access field 'clientFinalizer' in FileSystem!", (Throwable)iae);
            throw new RuntimeException("Failed to suppress HDFS shutdown hook");
        }
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    private HLog setupHLog() throws RegionServerRunningException, IOException {
        Path logdir = new Path(this.rootDir, HLog.getHLogDirectoryName(this.serverInfo));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Log dir " + logdir));
        }
        if (this.fs.exists(logdir)) {
            throw new RegionServerRunningException("region server already running at " + this.serverInfo.getServerAddress().toString() + " because logdir " + logdir.toString() + " exists");
        }
        HLog newlog = this.instantiateHLog(logdir);
        return newlog;
    }

    protected HLog instantiateHLog(Path logdir) throws IOException {
        HLog newlog = new HLog(this.fs, logdir, this.conf, this.hlogRoller);
        return newlog;
    }

    protected LogRoller getLogRoller() {
        return this.hlogRoller;
    }

    protected void doMetrics() {
        try {
            this.metrics();
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed metrics", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void metrics() {
        this.metrics.regions.set(this.onlineRegions.size());
        this.metrics.incrementRequests(this.requestCount.get());
        int stores = 0;
        int storefiles = 0;
        long memstoreSize = 0L;
        long storefileIndexSize = 0L;
        Map<Integer, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (Map.Entry<Integer, HRegion> e : this.onlineRegions.entrySet()) {
                HRegion r = e.getValue();
                memstoreSize += r.memstoreSize.get();
                Map<byte[], Store> map2 = r.stores;
                synchronized (map2) {
                    stores += r.stores.size();
                    for (Map.Entry<byte[], Store> ee : r.stores.entrySet()) {
                        Store store = ee.getValue();
                        storefiles += store.getStorefilesCount();
                        storefileIndexSize += store.getStorefilesIndexSize();
                    }
                }
            }
        }
        this.metrics.stores.set(stores);
        this.metrics.storefiles.set(storefiles);
        this.metrics.memstoreSizeMB.set((int)(memstoreSize / 0x100000L));
        this.metrics.storefileIndexSizeMB.set((int)(storefileIndexSize / 0x100000L));
        this.metrics.compactionQueueSize.set(this.compactSplitThread.getCompactionQueueSize());
        LruBlockCache lruBlockCache = (LruBlockCache)StoreFile.getBlockCache(this.conf);
        if (lruBlockCache != null) {
            this.metrics.blockCacheCount.set(lruBlockCache.size());
            this.metrics.blockCacheFree.set(lruBlockCache.getFreeSize());
            this.metrics.blockCacheSize.set(lruBlockCache.getCurrentSize());
            double ratio = lruBlockCache.getStats().getHitRatio();
            int percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitRatio.set(percent);
        }
    }

    public RegionServerMetrics getMetrics() {
        return this.metrics;
    }

    private void startServiceThreads() throws IOException {
        String n = Thread.currentThread().getName();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HRegionServer.this.abort();
                LOG.fatal((Object)("Set stop flag in " + t.getName()), e);
            }
        };
        Threads.setDaemonThreadRunning(this.hlogRoller, n + ".logRoller", handler);
        Threads.setDaemonThreadRunning(this.hlogFlusher, n + ".logFlusher", handler);
        Threads.setDaemonThreadRunning(this.cacheFlusher, n + ".cacheFlusher", handler);
        Threads.setDaemonThreadRunning(this.compactSplitThread, n + ".compactor", handler);
        Threads.setDaemonThreadRunning(this.workerThread, n + ".worker", handler);
        Threads.setDaemonThreadRunning(this.majorCompactionChecker, n + ".majorCompactionChecker", handler);
        this.leases.setName(n + ".leaseChecker");
        this.leases.start();
        int port = this.conf.getInt("hbase.regionserver.info.port", 60030);
        if (port >= 0) {
            String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
            boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
            while (true) {
                try {
                    this.infoServer = new InfoServer(REGIONSERVER, addr, port, false);
                    this.infoServer.setAttribute(REGIONSERVER, this);
                    this.infoServer.start();
                }
                catch (BindException e) {
                    if (!auto) {
                        throw e;
                    }
                    LOG.info((Object)("Failed binding http info server to port: " + port));
                    this.serverInfo.setInfoPort(++port);
                    continue;
                }
                break;
            }
        }
        this.server.start();
        LOG.info((Object)("HRegionServer started at: " + this.serverInfo.getServerAddress().toString()));
    }

    private boolean isHealthy() {
        if (!this.fsOk) {
            return false;
        }
        if (!(this.leases.isAlive() && this.compactSplitThread.isAlive() && this.cacheFlusher.isAlive() && this.hlogRoller.isAlive() && this.workerThread.isAlive() && this.majorCompactionChecker.isAlive())) {
            this.stop();
            return false;
        }
        return true;
    }

    private void housekeeping() {
        if (this.toDo.isEmpty()) {
            return;
        }
        for (ToDoEntry e : this.toDo) {
            if (e == null) {
                LOG.warn((Object)"toDo gave a null entry during iteration");
                break;
            }
            HMsg msg = e.msg;
            if (msg != null) {
                if (!msg.isType(HMsg.Type.MSG_REGION_OPEN)) continue;
                this.addProcessingMessage(msg.getRegionInfo());
                continue;
            }
            LOG.warn((Object)("Message is empty: " + e));
        }
    }

    HLog getLog() {
        return this.hlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopRequested.set(true);
        HRegionServer hRegionServer = this;
        synchronized (hRegionServer) {
            this.notifyAll();
        }
    }

    public void abort() {
        this.abortRequested = true;
        this.reservedSpace.clear();
        LOG.info((Object)("Dump of metrics: " + this.metrics.toString()));
        this.stop();
    }

    void join() {
        Threads.shutdown(this.majorCompactionChecker);
        Threads.shutdown(this.workerThread);
        Threads.shutdown(this.cacheFlusher);
        Threads.shutdown(this.compactSplitThread);
        Threads.shutdown(this.hlogRoller);
    }

    private boolean getMaster() {
        HServerAddress masterAddress = null;
        while (masterAddress == null) {
            if (this.stopRequested.get()) {
                return false;
            }
            try {
                masterAddress = this.zooKeeperWrapper.readMasterAddressOrThrow();
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to read master address from ZooKeeper. Retrying. Error was:", (Throwable)e);
                this.sleeper.sleep();
            }
        }
        LOG.info((Object)("Telling master at " + masterAddress + " that we are up"));
        HMasterRegionInterface master = null;
        while (!this.stopRequested.get() && master == null) {
            try {
                master = (HMasterRegionInterface)HBaseRPC.waitForProxy(HMasterRegionInterface.class, 21L, masterAddress.getInetSocketAddress(), this.conf, -1, this.rpcTimeout);
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to connect to master. Retrying. Error was:", (Throwable)e);
                this.sleeper.sleep();
            }
        }
        this.hbaseMaster = master;
        return true;
    }

    private MapWritable reportForDuty() {
        while (!this.stopRequested.get() && !this.getMaster()) {
            this.sleeper.sleep();
            LOG.warn((Object)"Unable to get master for initialization");
        }
        MapWritable result = null;
        long lastMsg = 0L;
        while (!this.stopRequested.get()) {
            try {
                this.requestCount.set(0);
                MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                HServerLoad hsl = new HServerLoad(0, (int)memory.getUsed() / 1024 / 1024, (int)memory.getMax() / 1024 / 1024);
                this.serverInfo.setLoad(hsl);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("sending initial server load: " + hsl));
                }
                lastMsg = System.currentTimeMillis();
                boolean startCodeOk = false;
                while (!startCodeOk) {
                    this.serverInfo.setStartCode(System.currentTimeMillis());
                    startCodeOk = this.zooKeeperWrapper.writeRSLocation(this.serverInfo);
                    if (startCodeOk) continue;
                    LOG.debug((Object)"Start code already taken, trying another one");
                }
                result = this.hbaseMaster.regionServerStartup(this.serverInfo);
                break;
            }
            catch (Leases.LeaseStillHeldException e) {
                LOG.info((Object)("Lease " + e.getName() + " already held on master. Check " + "DNS configuration so that all region servers are" + "reporting their true IPs and not 127.0.0.1. Otherwise, this" + "problem should resolve itself after the lease period of " + this.conf.get("hbase.master.lease.period") + " seconds expires over on the master"));
            }
            catch (IOException e) {
                LOG.warn((Object)"error telling master we are up", (Throwable)e);
            }
            this.sleeper.sleep(lastMsg);
        }
        return result;
    }

    private void reportOpen(HRegionInfo region) {
        this.outboundMsgs.add(new HMsg(HMsg.Type.MSG_REPORT_OPEN, region));
    }

    private void reportClose(HRegionInfo region) {
        this.reportClose(region, null);
    }

    private void reportClose(HRegionInfo region, byte[] message) {
        this.outboundMsgs.add(new HMsg(HMsg.Type.MSG_REPORT_CLOSE, region, message));
    }

    void reportSplit(HRegionInfo oldRegion, HRegionInfo newRegionA, HRegionInfo newRegionB) {
        this.outboundMsgs.add(new HMsg(HMsg.Type.MSG_REPORT_SPLIT, oldRegion, ("Daughters; " + newRegionA.getRegionNameAsString() + ", " + newRegionB.getRegionNameAsString()).getBytes()));
        this.outboundMsgs.add(new HMsg(HMsg.Type.MSG_REPORT_OPEN, newRegionA));
        this.outboundMsgs.add(new HMsg(HMsg.Type.MSG_REPORT_OPEN, newRegionB));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openRegion(HRegionInfo regionInfo) {
        Integer mapKey = Bytes.mapKey(regionInfo.getRegionName());
        HRegion region = this.onlineRegions.get(mapKey);
        if (region == null) {
            try {
                region = this.instantiateRegion(regionInfo);
                if (region.hasReferences() || region.hasTooManyStoreFiles()) {
                    this.compactSplitThread.compactionRequested(region, region.hasReferences() ? "Region has references on open" : "Region has too many store files");
                }
            }
            catch (Throwable e) {
                Throwable t = this.cleanup(e, "Error opening " + regionInfo.getRegionNameAsString());
                this.reportClose(regionInfo, StringUtils.stringifyException((Throwable)t).getBytes());
                return;
            }
            this.lock.writeLock().lock();
            try {
                this.hlog.setSequenceNumber(region.getMinSequenceId());
                this.onlineRegions.put(mapKey, region);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.reportOpen(regionInfo);
    }

    protected HRegion instantiateRegion(final HRegionInfo regionInfo) throws IOException {
        HRegion r = HRegion.newHRegion(HTableDescriptor.getTableDir(this.rootDir, regionInfo.getTableDesc().getName()), this.hlog, this.fs, this.conf, regionInfo, this.cacheFlusher);
        r.initialize(null, new Progressable(){

            public void progress() {
                HRegionServer.this.addProcessingMessage(regionInfo);
            }
        });
        return r;
    }

    public void addProcessingMessage(HRegionInfo hri) {
        this.getOutboundMsgs().add(new HMsg(HMsg.Type.MSG_REPORT_PROCESS_OPEN, hri));
    }

    protected void closeRegion(HRegionInfo hri, boolean reportWhenCompleted) throws IOException {
        HRegion region = this.removeFromOnlineRegions(hri);
        if (region != null) {
            region.close();
            if (reportWhenCompleted) {
                this.reportClose(hri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<HRegion> closeAllRegions() {
        ArrayList<HRegion> regionsToClose = new ArrayList<HRegion>();
        this.lock.writeLock().lock();
        try {
            regionsToClose.addAll(this.onlineRegions.values());
            this.onlineRegions.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (Map.Entry<String, InternalScanner> e : this.scanners.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
        for (HRegion region : regionsToClose) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("closing region " + Bytes.toString(region.getRegionName())));
            }
            try {
                region.close(this.abortRequested);
            }
            catch (Throwable e) {
                this.cleanup(e, "Error closing " + Bytes.toString(region.getRegionName()));
            }
        }
        return regionsToClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUserRegions() {
        ArrayList<HRegion> regionsToClose = new ArrayList<HRegion>();
        this.lock.writeLock().lock();
        try {
            Map<Integer, HRegion> map = this.onlineRegions;
            synchronized (map) {
                Iterator<Map.Entry<Integer, HRegion>> i = this.onlineRegions.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Integer, HRegion> entry = i.next();
                    HRegion r = entry.getValue();
                    if (r.getRegionInfo().isMetaRegion()) continue;
                    regionsToClose.add(r);
                    i.remove();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        HashSet<RegionCloserThread> threads = new HashSet<RegionCloserThread>();
        try {
            for (HRegion hRegion : regionsToClose) {
                RegionCloserThread t = new RegionCloserThread(hRegion);
                t.start();
                threads.add(t);
            }
        }
        finally {
            for (Thread thread : threads) {
                while (thread.isAlive()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.quiesced.set(true);
        if (this.onlineRegions.size() == 0) {
            this.outboundMsgs.add(REPORT_EXITING);
        } else {
            this.outboundMsgs.add(REPORT_QUIESCED);
        }
    }

    @Override
    public HRegionInfo getRegionInfo(byte[] regionName) throws NotServingRegionException {
        this.requestCount.incrementAndGet();
        return this.getRegion(regionName).getRegionInfo();
    }

    @Override
    public Result getClosestRowBefore(byte[] regionName, byte[] row, byte[] family) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Result r = region.getClosestRowBefore(row, family);
            return r;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public Result get(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.get(get2, this.getLockFromId(get2.getLockId()));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean exists(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Result r = region.get(get2, this.getLockFromId(get2.getLockId()));
            return r != null && !r.isEmpty();
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void put(byte[] regionName, Put put) throws IOException {
        if (put.getRow() == null) {
            throw new IllegalArgumentException("update has null row");
        }
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            region.put(put, this.getLockFromId(put.getLockId()));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int put(byte[] regionName, Put[] puts) throws IOException {
        int i = 0;
        this.checkOpen();
        try {
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Integer[] locks = new Integer[puts.length];
            for (i = 0; i < puts.length; ++i) {
                this.requestCount.incrementAndGet();
                locks[i] = this.getLockFromId(puts[i].getLockId());
                region.put(puts[i], locks[i]);
            }
        }
        catch (WrongRegionException ex) {
            LOG.debug((Object)("Batch puts: " + i), (Throwable)ex);
            return i;
        }
        catch (NotServingRegionException ex) {
            return i;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
        return -1;
    }

    @Override
    public boolean checkAndPut(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        Get get2 = new Get(row);
        get2.addColumn(family, qualifier);
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            return region.checkAndPut(row, family, qualifier, value, put, this.getLockFromId(put.getLockId()), true);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (scan == null) {
            npe = new NullPointerException("scan is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to openScanner", npe);
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion r = this.getRegion(regionName);
            return this.addScanner(r.getScanner(scan));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Failed openScanner"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addScanner(InternalScanner s) throws Leases.LeaseStillHeldException {
        long scannerId = -1L;
        scannerId = this.rand.nextLong();
        String scannerName = String.valueOf(scannerId);
        Map<String, InternalScanner> map = this.scanners;
        synchronized (map) {
            this.scanners.put(scannerName, s);
        }
        this.leases.createLease(scannerName, new ScannerListener(scannerName));
        return scannerId;
    }

    @Override
    public Result next(long scannerId) throws IOException {
        Result[] res = this.next(scannerId, 1);
        if (res == null || res.length == 0) {
            return null;
        }
        return res[0];
    }

    @Override
    public Result[] next(long scannerId, int nbRows) throws IOException {
        try {
            String scannerName = String.valueOf(scannerId);
            InternalScanner s = this.scanners.get(scannerName);
            if (s == null) {
                throw new UnknownScannerException("Name: " + scannerName);
            }
            try {
                this.checkOpen();
            }
            catch (IOException e) {
                this.leases.cancelLease(scannerName);
                throw e;
            }
            this.leases.renewLease(scannerName);
            ArrayList<Result> results = new ArrayList<Result>();
            long currentScanResultSize = 0L;
            for (int i = 0; i < nbRows && currentScanResultSize < this.maxScannerResultSize; ++i) {
                this.requestCount.incrementAndGet();
                ArrayList<KeyValue> values = new ArrayList<KeyValue>();
                boolean moreRows = s.next(values);
                if (!values.isEmpty()) {
                    for (KeyValue kv : values) {
                        currentScanResultSize += kv.heapSize();
                    }
                    results.add(new Result(values));
                }
                if (!moreRows) break;
            }
            return ((HRegion.RegionScanner)s).isFilterDone() && results.isEmpty() ? null : results.toArray(new Result[0]);
        }
        catch (Throwable t) {
            if (t instanceof NotServingRegionException) {
                String scannerName = String.valueOf(scannerId);
                this.scanners.remove(scannerName);
            }
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long scannerId) throws IOException {
        try {
            this.checkOpen();
            this.requestCount.incrementAndGet();
            String scannerName = String.valueOf(scannerId);
            InternalScanner s = null;
            Map<String, InternalScanner> map = this.scanners;
            synchronized (map) {
                s = this.scanners.remove(scannerName);
            }
            if (s != null) {
                s.close();
                this.leases.cancelLease(scannerName);
            }
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void delete(byte[] regionName, Delete delete) throws IOException {
        this.checkOpen();
        try {
            boolean writeToWAL = true;
            this.requestCount.incrementAndGet();
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Integer lid = this.getLockFromId(delete.getLockId());
            region.delete(delete, lid, writeToWAL);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int delete(byte[] regionName, Delete[] deletes) throws IOException {
        int i = 0;
        this.checkOpen();
        try {
            boolean writeToWAL = true;
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Integer[] locks = new Integer[deletes.length];
            for (i = 0; i < deletes.length; ++i) {
                this.requestCount.incrementAndGet();
                locks[i] = this.getLockFromId(deletes[i].getLockId());
                region.delete(deletes[i], locks[i], writeToWAL);
            }
        }
        catch (WrongRegionException ex) {
            LOG.debug((Object)("Batch deletes: " + i), (Throwable)ex);
            return i;
        }
        catch (NotServingRegionException ex) {
            return i;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
        return -1;
    }

    @Override
    public long lockRow(byte[] regionName, byte[] row) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (row == null) {
            npe = new NullPointerException("row to lock is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to lockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Integer r = region.obtainRowLock(row);
            long lockId = this.addRowLock(r, region);
            LOG.debug((Object)("Row lock " + lockId + " explicitly acquired by client"));
            return lockId;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Error obtaining row lock (fsOk: " + this.fsOk + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long addRowLock(Integer r, HRegion region) throws Leases.LeaseStillHeldException {
        long lockId = -1L;
        lockId = this.rand.nextLong();
        String lockName = String.valueOf(lockId);
        Map<String, Integer> map = this.rowlocks;
        synchronized (map) {
            this.rowlocks.put(lockName, r);
        }
        this.leases.createLease(lockName, new RowLockListener(lockName, region));
        return lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getLockFromId(long lockId) throws IOException {
        if (lockId == -1L) {
            return null;
        }
        String lockName = String.valueOf(lockId);
        Integer rl = null;
        Map<String, Integer> map = this.rowlocks;
        synchronized (map) {
            rl = this.rowlocks.get(lockName);
        }
        if (rl == null) {
            throw new IOException("Invalid row lock");
        }
        this.leases.renewLease(lockName);
        return rl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockRow(byte[] regionName, long lockId) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (lockId == -1L) {
            npe = new NullPointerException("lockId is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to unlockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            String lockName = String.valueOf(lockId);
            Integer r = null;
            Map<String, Integer> map = this.rowlocks;
            synchronized (map) {
                r = this.rowlocks.remove(lockName);
            }
            if (r == null) {
                throw new UnknownRowLockException(lockName);
            }
            region.releaseRowLock(r);
            this.leases.cancelLease(lockName);
            LOG.debug((Object)("Row lock " + lockId + " has been explicitly released by client"));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    public boolean isInSafeMode() {
        return this.safeMode.get();
    }

    public HBaseConfiguration getConfiguration() {
        return this.conf;
    }

    ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    public Collection<HRegion> getOnlineRegions() {
        return Collections.unmodifiableCollection(this.onlineRegions.values());
    }

    @Override
    public HRegion[] getOnlineRegionsAsArray() {
        return this.getOnlineRegions().toArray(new HRegion[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<HRegionInfo> getSortedOnlineRegionInfos() {
        TreeSet<HRegionInfo> result = new TreeSet<HRegionInfo>();
        Map<Integer, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion r : this.onlineRegions.values()) {
                result.add(r.getRegionInfo());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HRegion removeFromOnlineRegions(HRegionInfo hri) {
        this.lock.writeLock().lock();
        HRegion toReturn = null;
        try {
            toReturn = this.onlineRegions.remove(Bytes.mapKey(hri.getRegionName()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedBySize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return -1 * a.compareTo(b);
            }
        });
        Map<Integer, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion region : this.onlineRegions.values()) {
                sortedRegions.put(region.memstoreSize.get(), region);
            }
        }
        return sortedRegions;
    }

    public HRegion getOnlineRegion(byte[] regionName) {
        return this.onlineRegions.get(Bytes.mapKey(regionName));
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HRegion getRegion(byte[] regionName) throws NotServingRegionException {
        HRegion region = null;
        this.lock.readLock().lock();
        try {
            region = this.onlineRegions.get(Bytes.hashCode(regionName));
            if (region == null) {
                throw new NotServingRegionException(regionName);
            }
            HRegion hRegion = region;
            return hRegion;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HRegionInfo[] getMostLoadedRegions() {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        Map<Integer, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion r : this.onlineRegions.values()) {
                if (r.isClosed() || r.isClosing()) continue;
                if (regions.size() >= this.numRegionsToReport) break;
                regions.add(r.getRegionInfo());
            }
        }
        return regions.toArray(new HRegionInfo[regions.size()]);
    }

    protected void checkOpen() throws IOException {
        if (this.stopRequested.get() || this.abortRequested) {
            throw new IOException("Server not running" + (this.abortRequested ? ", aborting" : ""));
        }
        if (!this.fsOk) {
            throw new IOException("File system not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<HRegion> getRegionsToCheck() {
        HashSet<HRegion> regionsToCheck = new HashSet<HRegion>();
        this.lock.readLock().lock();
        try {
            regionsToCheck.addAll(this.onlineRegions.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
        Iterator i = regionsToCheck.iterator();
        while (i.hasNext()) {
            HRegion r = (HRegion)i.next();
            if (!r.isClosed()) continue;
            i.remove();
        }
        return regionsToCheck;
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(HRegionInterface.class.getName())) {
            return 21L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    protected List<HMsg> getOutboundMsgs() {
        return this.outboundMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGlobalMemStoreSize() {
        long total = 0L;
        Map<Integer, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion region : this.onlineRegions.values()) {
                total += region.memstoreSize.get();
            }
        }
        return total;
    }

    protected Leases getLeases() {
        return this.leases;
    }

    protected Path getRootDir() {
        return this.rootDir;
    }

    protected FileSystem getFileSystem() {
        return this.fs;
    }

    private static void printUsageAndExit() {
        HRegionServer.printUsageAndExit(null);
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println("Usage: java org.apache.hbase.HRegionServer start|stop");
        System.exit(0);
    }

    protected static void doMain(String[] args, Class<? extends HRegionServer> regionServerClass) {
        if (args.length < 1) {
            HRegionServer.printUsageAndExit();
        }
        HBaseConfiguration conf = new HBaseConfiguration();
        for (String cmd : args) {
            if (cmd.equals("start")) {
                try {
                    if (LocalHBaseCluster.isLocal(conf)) {
                        LOG.warn((Object)"Not starting a distinct region server because hbase.cluster.distributed is false");
                        break;
                    }
                    RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                    if (runtime != null) {
                        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
                    }
                    Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(HBaseConfiguration.class);
                    HRegionServer hrs = c.newInstance(new Object[]{conf});
                    Thread t = new Thread(hrs);
                    t.setName(REGIONSERVER + hrs.server.getListenerAddress());
                    t.start();
                }
                catch (Throwable t) {
                    LOG.error((Object)("Can not start region server because " + StringUtils.stringifyException((Throwable)t)));
                }
                break;
            }
            if (cmd.equals("stop")) {
                HRegionServer.printUsageAndExit("To shutdown the regionserver run bin/hbase-daemon.sh stop regionserver or send a kill signal tothe regionserver pid");
            }
            HRegionServer.printUsageAndExit();
        }
    }

    @Override
    public long incrementColumnValue(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to incrementColumnValue regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    public HRegionInfo[] getRegionsAssignment() throws IOException {
        HRegionInfo[] regions = new HRegionInfo[this.onlineRegions.size()];
        Iterator<HRegion> ite = this.onlineRegions.values().iterator();
        int i = 0;
        while (ite.hasNext()) {
            regions[i] = ite.next().getRegionInfo();
            ++i;
        }
        return regions;
    }

    @Override
    public HServerInfo getHServerInfo() throws IOException {
        return this.serverInfo;
    }

    public static void main(String[] args) {
        HBaseConfiguration conf = new HBaseConfiguration();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        HRegionServer.doMain(args, regionServerClass);
    }

    private class RowLockListener
    implements LeaseListener {
        private final String lockName;
        private final HRegion region;

        RowLockListener(String lockName, HRegion region) {
            this.lockName = lockName;
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void leaseExpired() {
            LOG.info((Object)("Row Lock " + this.lockName + " lease expired"));
            Integer r = null;
            Map<String, Integer> map = HRegionServer.this.rowlocks;
            synchronized (map) {
                r = HRegionServer.this.rowlocks.remove(this.lockName);
            }
            if (r != null) {
                this.region.releaseRowLock(r);
            }
        }
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void leaseExpired() {
            LOG.info((Object)("Scanner " + this.scannerName + " lease expired"));
            InternalScanner s = null;
            Map<String, InternalScanner> map = HRegionServer.this.scanners;
            synchronized (map) {
                s = HRegionServer.this.scanners.remove(this.scannerName);
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Closing scanner", (Throwable)e);
                }
            }
        }
    }

    private static class RegionCloserThread
    extends Thread {
        private final HRegion r;

        protected RegionCloserThread(HRegion r) {
            super(Thread.currentThread().getName() + ".regionCloser." + r.toString());
            this.r = r;
        }

        @Override
        public void run() {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Closing region " + this.r.toString()));
                }
                this.r.close();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error closing region " + this.r.toString()), RemoteExceptionHandler.checkThrowable(e));
            }
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            BlockingQueue<ToDoEntry> blockingQueue = HRegionServer.this.toDo;
            synchronized (blockingQueue) {
                HRegionServer.this.toDo.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                block21: while (true) {
                    try {
                        while (!HRegionServer.this.stopRequested.get()) {
                            ToDoEntry e = null;
                            try {
                                e = HRegionServer.this.toDo.poll(HRegionServer.this.threadWakeFrequency, TimeUnit.MILLISECONDS);
                                if (e == null) continue block21;
                                if (HRegionServer.this.stopRequested.get()) continue;
                                LOG.info((Object)("Worker: " + e.msg));
                                HRegion region = null;
                                HRegionInfo info = e.msg.getRegionInfo();
                                switch (e.msg.getType()) {
                                    case MSG_REGIONSERVER_QUIESCE: {
                                        HRegionServer.this.closeUserRegions();
                                        break;
                                    }
                                    case MSG_REGION_OPEN: {
                                        if (!HRegionServer.this.haveRootRegion.get() && !info.isRootRegion()) {
                                            LOG.info((Object)"putting region open request back into queue because root region is not yet available");
                                            try {
                                                HRegionServer.this.toDo.put(e);
                                            }
                                            catch (InterruptedException ex) {
                                                LOG.warn((Object)"insertion into toDo queue was interrupted", (Throwable)ex);
                                                break;
                                            }
                                        }
                                        HRegionServer.this.openRegion(info);
                                        break;
                                    }
                                    case MSG_REGION_CLOSE: {
                                        HRegionServer.this.closeRegion(e.msg.getRegionInfo(), true);
                                        break;
                                    }
                                    case MSG_REGION_CLOSE_WITHOUT_REPORT: {
                                        HRegionServer.this.closeRegion(e.msg.getRegionInfo(), false);
                                        break;
                                    }
                                    case MSG_REGION_SPLIT: {
                                        region = HRegionServer.this.getRegion(info.getRegionName());
                                        region.flushcache();
                                        region.shouldSplit(true);
                                        HRegionServer.this.compactSplitThread.compactionRequested(region, e.msg.getType().name());
                                        break;
                                    }
                                    case MSG_REGION_MAJOR_COMPACT: 
                                    case MSG_REGION_COMPACT: {
                                        region = HRegionServer.this.getRegion(info.getRegionName());
                                        HRegionServer.this.compactSplitThread.compactionRequested(region, e.msg.isType(HMsg.Type.MSG_REGION_MAJOR_COMPACT), e.msg.getType().name());
                                        break;
                                    }
                                    case MSG_REGION_FLUSH: {
                                        region = HRegionServer.this.getRegion(info.getRegionName());
                                        region.flushcache();
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError((Object)("Impossible state during msg processing.  Instruction: " + e.msg.toString()));
                                    }
                                }
                                continue block21;
                            }
                            catch (InterruptedException ex) {
                            }
                            catch (Exception ex2) {
                                IOException ex2;
                                if (ex2 instanceof IOException) {
                                    ex2 = RemoteExceptionHandler.checkIOException((IOException)ex2);
                                }
                                if (e != null && e.tries.get() < HRegionServer.this.numRetries) {
                                    LOG.warn((Object)ex2);
                                    e.tries.incrementAndGet();
                                    try {
                                        HRegionServer.this.toDo.put(e);
                                    }
                                    catch (InterruptedException ie) {
                                        throw new RuntimeException("Putting into msgQueue was interrupted.", ex2);
                                    }
                                    continue block21;
                                }
                                LOG.error((Object)("unable to process message" + (e != null ? ": " + e.msg.toString() : "")), (Throwable)ex2);
                                if (HRegionServer.this.checkFileSystem()) continue;
                                break block27;
                            }
                        }
                        break block27;
                    }
                    catch (Throwable t) {
                        if (!HRegionServer.this.checkOOME(t)) {
                            LOG.fatal((Object)"Unhandled exception", t);
                        }
                        break block27;
                    }
                    break;
                }
                finally {
                    LOG.info((Object)"worker thread exiting");
                }
            }
        }
    }

    private static final class ToDoEntry {
        protected final AtomicInteger tries = new AtomicInteger(0);
        protected final HMsg msg;

        ToDoEntry(HMsg msg) {
            this.msg = msg;
        }
    }

    private static class MajorCompactionChecker
    extends Chore {
        private final HRegionServer instance;

        MajorCompactionChecker(HRegionServer h, int sleepTime, AtomicBoolean stopper) {
            super(sleepTime, stopper);
            this.instance = h;
            LOG.info((Object)("Runs every " + sleepTime + "ms"));
        }

        @Override
        protected void chore() {
            Set<Integer> keys = this.instance.onlineRegions.keySet();
            for (Integer i : keys) {
                HRegion r = this.instance.onlineRegions.get(i);
                try {
                    if (r == null || !r.isMajorCompaction()) continue;
                    this.instance.compactSplitThread.compactionRequested(r, this.getName() + " requests major compaction");
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed major compaction check on " + r), (Throwable)e);
                }
            }
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final HRegionServer instance;
        private final Thread mainThread;

        public ShutdownThread(HRegionServer instance, Thread mainThread) {
            this.instance = instance;
            this.mainThread = mainThread;
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting shutdown thread.");
            this.instance.stop();
            Threads.shutdown(this.mainThread);
            LOG.info((Object)"Shutdown thread complete");
        }
    }
}

