/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestCompaction
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog((String)TestCompaction.class.getName());
    private HRegion r = null;
    private Path compactionDir = null;
    private Path regionCompactionDir = null;
    private static final byte[] COLUMN_FAMILY = fam1;
    private final byte[] STARTROW = Bytes.toBytes(this.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private static final int COMPACTION_THRESHOLD = 3;
    private MiniDFSCluster cluster;

    public TestCompaction() {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 10);
        this.cluster = null;
    }

    @Override
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster((Configuration)this.conf, 2, true, (String[])null);
        this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        super.setUp();
        HTableDescriptor htd = this.createTableDescriptor(this.getName());
        this.r = this.createNewHRegion(htd, null, null);
        this.compactionDir = HRegion.getCompactionDir(this.r.getBaseDir());
        this.regionCompactionDir = new Path(this.compactionDir, Integer.toString(this.r.getRegionInfo().getEncodedName()));
    }

    @Override
    public void tearDown() throws Exception {
        HLog hlog = this.r.getLog();
        this.r.close();
        hlog.closeAndDelete();
        if (this.cluster != null) {
            TestCompaction.shutdownDfs(this.cluster);
        }
        super.tearDown();
    }

    public void testMajorCompactingToNoOutput() throws IOException {
        ArrayList<KeyValue> results;
        boolean result;
        boolean result2;
        this.createStoreFile(this.r);
        for (int i = 0; i < 3; ++i) {
            this.createStoreFile(this.r);
        }
        InternalScanner s = this.r.getScanner(new Scan());
        do {
            ArrayList<KeyValue> results2 = new ArrayList<KeyValue>();
            result2 = s.next(results2);
            this.r.delete(new Delete(((KeyValue)results2.get(0)).getRow()), null, false);
        } while (result2);
        this.r.flushcache();
        this.r.compactStores(true);
        s = this.r.getScanner(new Scan());
        int counter = 0;
        while (result = s.next(results = new ArrayList<KeyValue>())) {
            ++counter;
        }
        TestCompaction.assertEquals((int)0, (int)counter);
    }

    public void testCompaction() throws Exception {
        this.createStoreFile(this.r);
        for (int i = 0; i < 3; ++i) {
            this.createStoreFile(this.r);
        }
        TestCompaction.addContent(new HBaseTestCase.HRegionIncommon(this.r), Bytes.toString(COLUMN_FAMILY));
        Result result = this.r.get(new Get(this.STARTROW).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)3, (int)result.size());
        this.r.flushcache();
        this.r.compactStores();
        TestCompaction.assertTrue((boolean)this.cluster.getFileSystem().exists(this.compactionDir));
        TestCompaction.assertTrue((!this.cluster.getFileSystem().exists(this.regionCompactionDir) ? 1 : 0) != 0);
        byte[] secondRowBytes = this.START_KEY.getBytes("UTF-8");
        int n = START_KEY_BYTES.length - 1;
        secondRowBytes[n] = (byte)(secondRowBytes[n] + 1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertEquals((int)3, (int)result.size());
        Delete delete = new Delete(secondRowBytes, System.currentTimeMillis(), null);
        byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
        delete.deleteFamily(famAndQf[0]);
        this.r.delete(delete, null, true);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((boolean)result.isEmpty());
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((boolean)result.isEmpty());
        this.createSmallerStoreFile(this.r);
        this.r.flushcache();
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((boolean)result.isEmpty());
        this.r.compactStores(true);
        TestCompaction.assertEquals((int)this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles().size(), (int)1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).setMaxVersions(100), null);
        TestCompaction.assertTrue((boolean)result.isEmpty());
        int count = 0;
        boolean containsStartRow = false;
        for (StoreFile f : this.r.stores.get(COLUMN_FAMILY_TEXT).getStorefiles().values()) {
            HFileScanner scanner = f.getReader().getScanner(false);
            scanner.seekTo();
            do {
                byte[] row;
                if (Bytes.equals(row = scanner.getKeyValue().getRow(), this.STARTROW)) {
                    containsStartRow = true;
                    ++count;
                    continue;
                }
                TestCompaction.assertFalse((boolean)Bytes.equals(row, secondRowBytes));
            } while (scanner.next());
        }
        TestCompaction.assertTrue((boolean)containsStartRow);
        TestCompaction.assertTrue((count == 3 ? 1 : 0) != 0);
        boolean ttlInSeconds = true;
        for (Store store : this.r.stores.values()) {
            store.ttl = 1000L;
        }
        Thread.sleep(1000L);
        this.r.compactStores(true);
        count = this.count();
        TestCompaction.assertTrue((count == 0 ? 1 : 0) != 0);
    }

    private int count() throws IOException {
        int count = 0;
        for (StoreFile f : this.r.stores.get(COLUMN_FAMILY_TEXT).getStorefiles().values()) {
            HFileScanner scanner = f.getReader().getScanner();
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, Bytes.toString(COLUMN_FAMILY));
        loader.flushcache();
    }

    private void createSmallerStoreFile(HRegion region) throws IOException {
        HBaseTestCase.HRegionIncommon loader = new HBaseTestCase.HRegionIncommon(region);
        TestCompaction.addContent(loader, Bytes.toString(COLUMN_FAMILY), "bbb".getBytes(), null);
        loader.flushcache();
    }
}

