/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.HLogKey;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class TestHLog
extends HBaseTestCase
implements HConstants {
    private Path dir;
    private MiniDFSCluster cluster;

    @Override
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster((Configuration)this.conf, 2, true, (String[])null);
        this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        super.setUp();
        this.dir = new Path("/hbase", this.getName());
        if (this.fs.exists(this.dir)) {
            this.fs.delete(this.dir, true);
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.fs.exists(this.dir)) {
            this.fs.delete(this.dir, true);
        }
        TestHLog.shutdownDfs(this.cluster);
        super.tearDown();
    }

    public void testFindMemstoresWithEditsOlderThan() throws IOException {
        HashMap<byte[], Long> regionsToSeqids = new HashMap<byte[], Long>();
        for (int i = 0; i < 10; ++i) {
            Long l = new Long(i);
            regionsToSeqids.put(l.toString().getBytes(), l);
        }
        byte[][] regions = HLog.findMemstoresWithEditsOlderThan(1L, regionsToSeqids);
        TestHLog.assertEquals((int)1, (int)regions.length);
        TestHLog.assertTrue((boolean)Bytes.equals(regions[0], "0".getBytes()));
        regions = HLog.findMemstoresWithEditsOlderThan(3L, regionsToSeqids);
        int count = 3;
        TestHLog.assertEquals((int)count, (int)regions.length);
        for (int i = 0; i < count; ++i) {
            TestHLog.assertTrue((Bytes.equals(regions[i], "0".getBytes()) || Bytes.equals(regions[i], "1".getBytes()) || Bytes.equals(regions[i], "2".getBytes()) ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplit() throws IOException {
        byte[] tableName;
        byte[] rowName = tableName = Bytes.toBytes(this.getName());
        HLog log = new HLog(this.fs, this.dir, this.conf, null);
        int howmany = 3;
        try {
            for (int ii = 0; ii < 3; ++ii) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        ArrayList<KeyValue> edit = new ArrayList<KeyValue>();
                        byte[] column = Bytes.toBytes("column:" + Integer.toString(j));
                        edit.add(new KeyValue(rowName, column, System.currentTimeMillis(), column));
                        System.out.println("Region " + i + ": " + edit);
                        log.append(Bytes.toBytes("" + i), tableName, edit, false, System.currentTimeMillis());
                    }
                }
                log.rollWriter();
            }
            List<Path> splits = HLog.splitLog(this.testDir, this.dir, this.fs, this.conf);
            this.verifySplits(splits, 3);
            log = null;
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySplits(List<Path> splits, int howmany) throws IOException {
        TestHLog.assertEquals((int)howmany, (int)splits.size());
        for (int i = 0; i < splits.size(); ++i) {
            SequenceFile.Reader r = new SequenceFile.Reader(this.fs, splits.get(i), (Configuration)this.conf);
            try {
                HLogKey key = new HLogKey();
                KeyValue kv = new KeyValue();
                int count = 0;
                String previousRegion = null;
                long seqno = -1L;
                while (r.next((Writable)key, (Writable)kv)) {
                    String region = Bytes.toString(key.getRegionName());
                    if (previousRegion != null) {
                        TestHLog.assertEquals(previousRegion, (String)region);
                    }
                    TestHLog.assertTrue((seqno < key.getLogSeqNum() ? 1 : 0) != 0);
                    seqno = key.getLogSeqNum();
                    previousRegion = region;
                    System.out.println(key + " " + kv);
                    ++count;
                }
                TestHLog.assertEquals((int)(howmany * howmany), (int)count);
                continue;
            }
            finally {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppend() throws IOException {
        int COL_COUNT = 10;
        byte[] regionName = Bytes.toBytes("regionname");
        byte[] tableName = Bytes.toBytes("tablename");
        byte[] row = Bytes.toBytes("row");
        SequenceFile.Reader reader = null;
        HLog log = new HLog(this.fs, this.dir, this.conf, null);
        try {
            long timestamp = System.currentTimeMillis();
            ArrayList<KeyValue> cols = new ArrayList<KeyValue>();
            for (int i = 0; i < 10; ++i) {
                cols.add(new KeyValue(row, Bytes.toBytes("column:" + Integer.toString(i)), timestamp, new byte[]{(byte)(i + 48)}));
            }
            log.append(regionName, tableName, cols, false, System.currentTimeMillis());
            long logSeqId = log.startCacheFlush();
            log.completeCacheFlush(regionName, tableName, logSeqId);
            log.close();
            Path filename = log.computeFilename(log.getFilenum());
            log = null;
            reader = new SequenceFile.Reader(this.fs, filename, (Configuration)this.conf);
            HLogKey key = new HLogKey();
            KeyValue val = new KeyValue();
            for (int i = 0; i < 10; ++i) {
                reader.next((Writable)key, (Writable)val);
                TestHLog.assertTrue((boolean)Bytes.equals(regionName, key.getRegionName()));
                TestHLog.assertTrue((boolean)Bytes.equals(tableName, key.getTablename()));
                TestHLog.assertTrue((boolean)Bytes.equals(row, val.getRow()));
                TestHLog.assertEquals((byte)((byte)(i + 48)), (byte)val.getValue()[0]);
                System.out.println(key + " " + val);
            }
            while (reader.next((Writable)key, (Writable)val)) {
                TestHLog.assertTrue((boolean)Bytes.equals(regionName, key.getRegionName()));
                TestHLog.assertTrue((boolean)Bytes.equals(tableName, key.getTablename()));
                TestHLog.assertTrue((boolean)Bytes.equals(HLog.METAROW, val.getRow()));
                TestHLog.assertTrue((boolean)Bytes.equals(HLog.METAFAMILY, val.getFamily()));
                TestHLog.assertEquals((int)0, (int)Bytes.compareTo(HLog.COMPLETE_CACHE_FLUSH, val.getValue()));
                System.out.println(key + " " + val);
            }
        }
        finally {
            if (log != null) {
                log.closeAndDelete();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

