/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHRegion
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestHRegion.class);
    HRegion region = null;
    private final String DIR = "test/build/data/TestHRegion/";
    private final int MAX_VERSIONS = 2;
    protected final byte[] tableName = Bytes.toBytes("testtable");
    protected final byte[] qual1 = Bytes.toBytes("qual1");
    protected final byte[] qual2 = Bytes.toBytes("qual2");
    protected final byte[] qual3 = Bytes.toBytes("qual3");
    protected final byte[] value1 = Bytes.toBytes("value1");
    protected final byte[] value2 = Bytes.toBytes("value2");
    protected final byte[] row = Bytes.toBytes("rowA");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes("testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes("trans-blob"), Bytes.toBytes("trans-type"), Bytes.toBytes("trans-date"), Bytes.toBytes("trans-tags"), Bytes.toBytes("trans-group")};
        this.initHRegion(TABLE, this.getName(), FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = "prefix1";
        String keyPrefix2 = "prefix2";
        String keyPrefix3 = "prefix3";
        this.putRows(this.region, 3, value, keyPrefix1);
        this.putRows(this.region, 3, value, keyPrefix2);
        this.putRows(this.region, 3, value, keyPrefix3);
        this.putRows(this.region, 3, value2, keyPrefix1);
        this.putRows(this.region, 3, value2, keyPrefix2);
        this.putRows(this.region, 3, value2, keyPrefix3);
        System.out.println("Checking values for key: " + keyPrefix1);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix1, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix2);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix2, value2, this.region));
        System.out.println("Checking values for key: " + keyPrefix3);
        TestHRegion.assertEquals((String)"Got back incorrect number of rows from scan", (int)3, (int)this.getNumberOfRows(keyPrefix3, value2, this.region));
        this.deleteColumns(this.region, value2, keyPrefix1);
        this.deleteColumns(this.region, value2, keyPrefix2);
        this.deleteColumns(this.region, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (int)0, (int)this.getNumberOfRows(keyPrefix1, value2, this.region));
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (int)0, (int)this.getNumberOfRows(keyPrefix2, value2, this.region));
        TestHRegion.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (int)0, (int)this.getNumberOfRows(keyPrefix3, value2, this.region));
    }

    private void deleteColumns(HRegion r, String value, String keyPrefix) throws IOException {
        InternalScanner scanner = this.buildScanner(keyPrefix, value, r);
        int count = 0;
        boolean more = false;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        do {
            more = scanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++count;
            Delete delete = new Delete(((KeyValue)results.get(0)).getRow());
            delete.deleteColumn(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"));
            r.delete(delete, null, false);
            results.clear();
        } while (more);
        TestHRegion.assertEquals((String)"Did not perform correct number of deletes", (int)3, (int)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HRegion r) throws Exception {
        InternalScanner resultScanner = this.buildScanner(keyPrefix, value, r);
        int numberOfResults = 0;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        boolean more = false;
        do {
            more = resultScanner.next(results);
            if (results == null || results.isEmpty()) break;
            ++numberOfResults;
            for (KeyValue kv : results) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString(kv.getValue()));
            }
            results.clear();
        } while (more);
        return numberOfResults;
    }

    private InternalScanner buildScanner(String keyPrefix, String value, HRegion r) throws IOException {
        FilterList allFilters = new FilterList();
        allFilters.addFilter(new PrefixFilter(Bytes.toBytes(keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes(value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter(filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes("trans-blob"));
        scan.addFamily(Bytes.toBytes("trans-type"));
        scan.addFamily(Bytes.toBytes("trans-date"));
        scan.addFamily(Bytes.toBytes("trans-tags"));
        scan.addFamily(Bytes.toBytes("trans-group"));
        scan.setFilter(allFilters);
        return r.getScanner(scan);
    }

    private void putRows(HRegion r, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + i;
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes(row));
            put.add(Bytes.toBytes("trans-blob"), null, Bytes.toBytes("value for blob"));
            put.add(Bytes.toBytes("trans-type"), null, Bytes.toBytes("statement"));
            put.add(Bytes.toBytes("trans-date"), null, Bytes.toBytes("20090921010101999"));
            put.add(Bytes.toBytes("trans-tags"), Bytes.toBytes("qual2"), Bytes.toBytes(value));
            put.add(Bytes.toBytes("trans-group"), null, Bytes.toBytes("adhocTransactionGroupId"));
            r.put(put);
        }
    }

    public void testFamilyWithAndWithoutColon() throws Exception {
        byte[] b = Bytes.toBytes(this.getName());
        byte[] cf = Bytes.toBytes("cf");
        this.initHRegion(b, this.getName(), new byte[][]{cf});
        Put p = new Put(b);
        byte[] cfwithcolon = Bytes.toBytes("cf:");
        p.add(cfwithcolon, cfwithcolon, cfwithcolon);
        boolean exception = false;
        try {
            this.region.put(p);
        }
        catch (NoSuchColumnFamilyException e) {
            exception = true;
        }
        TestHRegion.assertTrue((boolean)exception);
        p = new Put(b);
        p.add(cfwithcolon, System.currentTimeMillis(), cfwithcolon);
        this.region.put(p);
    }

    public void testCheckAndPut_WithEmptyRowValue() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] qf1 = Bytes.toBytes("qualifier");
        byte[] emptyVal = new byte[]{};
        byte[] val1 = Bytes.toBytes("value1");
        byte[] val2 = Bytes.toBytes("value2");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        boolean res = this.region.checkAndPut(row1, fam1, qf1, emptyVal, put, lockId, true);
        TestHRegion.assertTrue((boolean)res);
        res = this.region.checkAndPut(row1, fam1, qf1, emptyVal, put, lockId, true);
        TestHRegion.assertFalse((boolean)res);
        put = new Put(row1);
        put.add(fam1, qf1, val2);
        res = this.region.checkAndPut(row1, fam1, qf1, val1, put, lockId, true);
        TestHRegion.assertTrue((boolean)res);
    }

    public void testCheckAndPut_WithWrongValue() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] qf1 = Bytes.toBytes("qualifier");
        byte[] val1 = Bytes.toBytes("value1");
        byte[] val2 = Bytes.toBytes("value2");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        boolean res = this.region.checkAndPut(row1, fam1, qf1, val2, put, lockId, true);
        TestHRegion.assertEquals((boolean)false, (boolean)res);
    }

    public void testCheckAndPut_WithCorrectValue() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] qf1 = Bytes.toBytes("qualifier");
        byte[] val1 = Bytes.toBytes("value1");
        Integer lockId = null;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        boolean res = this.region.checkAndPut(row1, fam1, qf1, val1, put, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
    }

    public void testCheckAndPut_ThatPutWasWritten() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[] qf1 = Bytes.toBytes("qualifier");
        byte[] val1 = Bytes.toBytes("value1");
        byte[] val2 = Bytes.toBytes("value2");
        Integer lockId = null;
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = new Put(row1);
        put.add(fam1, qf1, val1);
        this.region.put(put);
        long ts = System.currentTimeMillis();
        KeyValue kv = new KeyValue(row1, fam2, qf1, ts, KeyValue.Type.Put, val2);
        put = new Put(row1);
        put.add(kv);
        Store store = this.region.getStore(fam1);
        store.memstore.kvset.size();
        boolean res = this.region.checkAndPut(row1, fam1, qf1, val1, put, lockId, true);
        TestHRegion.assertEquals((boolean)true, (boolean)res);
        store.memstore.kvset.size();
        Get get2 = new Get(row1);
        get2.addColumn(fam2, qf1);
        KeyValue[] actual = this.region.get(get2, null).raw();
        KeyValue[] expected = new KeyValue[]{kv};
        TestHRegion.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            TestHRegion.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    public void testDelete_CheckFamily() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[] fam3 = Bytes.toBytes("fam3");
        byte[] fam4 = Bytes.toBytes("fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, fam4, null, null));
        byte[] family = fam2;
        try {
            this.region.delete(family, kvs, true);
        }
        catch (Exception e) {
            TestHRegion.assertTrue((String)("Family " + new String(family) + " does not exist"), (boolean)false);
        }
        boolean ok = false;
        family = fam4;
        try {
            this.region.delete(family, kvs, true);
        }
        catch (Exception e) {
            ok = true;
        }
        TestHRegion.assertEquals((String)("Family " + new String(family) + " does exist"), (boolean)true, (boolean)ok);
    }

    public void testDelete_mixed() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] fam = Bytes.toBytes("info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        byte[] row = Bytes.toBytes("table_name");
        byte[] serverinfo = Bytes.toBytes("serverinfo");
        byte[] splitA = Bytes.toBytes("splitA");
        byte[] splitB = Bytes.toBytes("splitB");
        Put put = new Put(row);
        put.add(fam, splitA, Bytes.toBytes("reference_A"));
        this.region.put(put);
        put = new Put(row);
        put.add(fam, splitB, Bytes.toBytes("reference_B"));
        this.region.put(put);
        put = new Put(row);
        put.add(fam, serverinfo, Bytes.toBytes("ip_address"));
        this.region.put(put);
        Delete delete = new Delete(row);
        delete.deleteColumns(fam, splitA);
        this.region.delete(delete, null, true);
        Get get2 = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        get2 = new Get(row).addColumn(fam, splitA);
        result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)0, (int)result.size());
        get2 = new Get(row).addColumn(fam, splitB);
        result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
    }

    public void testDeleteRowWithFutureTs() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] fam = Bytes.toBytes("info");
        byte[][] families = new byte[][]{fam};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        byte[] row = Bytes.toBytes("table_name");
        byte[] serverinfo = Bytes.toBytes("serverinfo");
        Put put = new Put(row);
        put.add(fam, serverinfo, 0x7FFFFFFFFFFFFFFAL, Bytes.toBytes("value"));
        this.region.put(put);
        Delete delete = new Delete(row);
        this.region.delete(delete, null, true);
        Get get2 = new Get(row).addColumn(fam, serverinfo);
        Result result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        delete = new Delete(row, 0x7FFFFFFFFFFFFFFCL, null);
        this.region.delete(delete, null, true);
        get2 = new Get(row).addColumn(fam, serverinfo);
        result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)0, (int)result.size());
    }

    public void testScanner_DeleteOneFamilyNotAnother() throws IOException {
        byte[] tableName = Bytes.toBytes("test_table");
        byte[] fam1 = Bytes.toBytes("columnA");
        byte[] fam2 = Bytes.toBytes("columnB");
        this.initHRegion(tableName, this.getName(), fam1, fam2);
        byte[] rowA = Bytes.toBytes("rowA");
        byte[] rowB = Bytes.toBytes("rowB");
        byte[] value = Bytes.toBytes("value");
        Delete delete = new Delete(rowA);
        delete.deleteFamily(fam1);
        this.region.delete(delete, null, true);
        Put put = new Put(rowA);
        put.add(fam2, null, value);
        this.region.put(put);
        put = new Put(rowB);
        put.add(fam1, null, value);
        put.add(fam2, null, value);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam1).addFamily(fam2);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        s.next(results);
        TestHRegion.assertTrue((boolean)Bytes.equals(rowA, ((KeyValue)results.get(0)).getRow()));
        results.clear();
        s.next(results);
        TestHRegion.assertTrue((boolean)Bytes.equals(rowB, ((KeyValue)results.get(0)).getRow()));
    }

    public void testDeleteColumns_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteColumns(fam1, this.qual1);
        this.doTestDelete_AndPostInsert(delete);
    }

    public void testDeleteFamily_PostInsert() throws IOException, InterruptedException {
        Delete delete = new Delete(this.row);
        delete.deleteFamily(fam1);
        this.doTestDelete_AndPostInsert(delete);
    }

    public void doTestDelete_AndPostInsert(Delete delete) throws IOException, InterruptedException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, this.value1);
        this.region.put(put);
        Thread.sleep(10L);
        this.region.delete(delete, null, true);
        Thread.sleep(10L);
        put = new Put(this.row);
        put.add(fam1, this.qual1, this.value2);
        this.region.put(put);
        Get get2 = new Get(this.row);
        get2.addColumn(fam1, this.qual1);
        Result r = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)r.size());
        this.assertByteEquals(this.value2, r.getValue(fam1, this.qual1));
        Scan scan = new Scan(this.row);
        scan.addColumn(fam1, this.qual1);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        TestHRegion.assertEquals((boolean)false, (boolean)s.next(results));
        TestHRegion.assertEquals((int)1, (int)results.size());
        KeyValue kv = (KeyValue)results.get(0);
        this.assertByteEquals(this.value2, kv.getValue());
        this.assertByteEquals(fam1, kv.getFamily());
        this.assertByteEquals(this.qual1, kv.getQualifier());
        this.assertByteEquals(this.row, kv.getRow());
    }

    public void testDelete_CheckTimestampUpdated() throws IOException {
        byte[] row1 = Bytes.toBytes("row1");
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        String method = this.getName();
        this.initHRegion(this.tableName, method, new byte[][]{fam1});
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(row1, fam1, col1, null));
        kvs.add(new KeyValue(row1, fam1, col2, null));
        kvs.add(new KeyValue(row1, fam1, col3, null));
        this.region.delete(fam1, kvs, true);
        long now = System.currentTimeMillis();
        KeyValue firstKv = this.region.getStore((byte[])TestHRegion.fam1).memstore.kvset.first();
        TestHRegion.assertTrue((firstKv.getTimestamp() <= now ? 1 : 0) != 0);
        now = firstKv.getTimestamp();
        for (KeyValue kv : this.region.getStore((byte[])TestHRegion.fam1).memstore.kvset) {
            TestHRegion.assertTrue((kv.getTimestamp() <= now ? 1 : 0) != 0);
            now = kv.getTimestamp();
        }
    }

    public void testGet_FamilyChecker() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("False");
        byte[] col1 = Bytes.toBytes("col1");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Get get2 = new Get(row1);
        get2.addColumn(fam2, col1);
        try {
            this.region.get(get2, null);
        }
        catch (NoSuchColumnFamilyException e) {
            TestHRegion.assertFalse((boolean)false);
            return;
        }
        TestHRegion.assertFalse((boolean)true);
    }

    public void testGet_Basic() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = new Put(row1);
        put.add(fam1, col1, null);
        put.add(fam1, col2, null);
        put.add(fam1, col3, null);
        put.add(fam1, col4, null);
        put.add(fam1, col5, null);
        this.region.put(put);
        Get get2 = new Get(row1);
        get2.addColumn(fam1, col2);
        get2.addColumn(fam1, col4);
        KeyValue kv1 = new KeyValue(row1, fam1, col2);
        KeyValue kv2 = new KeyValue(row1, fam1, col4);
        KeyValue[] expected = new KeyValue[]{kv1, kv2};
        Result res = this.region.get(get2, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getRow(), res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getFamily(), res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getQualifier(), res.raw()[i].getQualifier()));
        }
        Get g = new Get(row1);
        int count = 2;
        g.setFilter(new ColumnCountGetFilter(2));
        res = this.region.get(g, null);
        TestHRegion.assertEquals((int)2, (int)res.size());
    }

    public void testGet_Empty() throws IOException {
        byte[] tableName = Bytes.toBytes("emptytable");
        byte[] row = Bytes.toBytes("row");
        byte[] fam = Bytes.toBytes("fam");
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam});
        Get get2 = new Get(row);
        get2.addFamily(fam);
        Result r = this.region.get(get2, null);
        TestHRegion.assertTrue((boolean)r.isEmpty());
    }

    public void stestGet_Root() throws IOException {
        int i;
        String method = this.getName();
        this.initHRegion(HConstants.ROOT_TABLE_NAME, method, new byte[][]{HConstants.CATALOG_FAMILY});
        Put put = new Put(HConstants.EMPTY_START_ROW);
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, null);
        this.region.put(put);
        Get get2 = new Get(HConstants.EMPTY_START_ROW);
        get2.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        KeyValue kv1 = new KeyValue(HConstants.EMPTY_START_ROW, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        KeyValue[] expected = new KeyValue[]{kv1};
        Result res = this.region.get(get2, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getRow(), res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getFamily(), res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getQualifier(), res.raw()[i].getQualifier()));
        }
        this.region.flushcache();
        res = this.region.get(get2, null);
        TestHRegion.assertEquals((int)expected.length, (int)res.size());
        for (i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getRow(), res.raw()[i].getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getFamily(), res.raw()[i].getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i].getQualifier(), res.raw()[i].getQualifier()));
        }
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        s.next(result);
        TestHRegion.assertEquals((int)expected.length, (int)result.size());
        for (int i2 = 0; i2 < res.size(); ++i2) {
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i2].getRow(), ((KeyValue)result.get(i2)).getRow()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i2].getFamily(), ((KeyValue)result.get(i2)).getFamily()));
            TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(expected[i2].getQualifier(), ((KeyValue)result.get(i2)).getQualifier()));
        }
    }

    public void testLocks() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        HBaseConfiguration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        int threadCount = 10;
        int lockCount = 10;
        ArrayList<1> threads = new ArrayList<1>(10);
        for (int i = 0; i < 10; ++i) {
            threads.add(new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    int i;
                    Integer[] lockids = new Integer[10];
                    for (i = 0; i < 10; ++i) {
                        try {
                            byte[] rowid = Bytes.toBytes(Integer.toString(i));
                            lockids[i] = TestHRegion.this.region.obtainRowLock(rowid);
                            Assert.assertEquals((Object)rowid, (Object)TestHRegion.this.region.getRowFromLock(lockids[i]));
                            LOG.debug((Object)(this.getName() + " locked " + Bytes.toString(rowid)));
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    LOG.debug((Object)(this.getName() + " set " + Integer.toString(10) + " locks"));
                    for (i = 9; i >= 0; --i) {
                        TestHRegion.this.region.releaseRowLock(lockids[i]);
                        LOG.debug((Object)(this.getName() + " unlocked " + i));
                    }
                    LOG.debug((Object)(this.getName() + " released " + Integer.toString(10) + " locks"));
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            while (thread.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
        LOG.info((Object)"locks completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMerge() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        HBaseConfiguration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + TestHRegion.addContent(this.region, fam3)));
            this.region.flushcache();
            byte[] splitRow = this.region.compactStores();
            TestHRegion.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString(splitRow)));
            HRegion[] regions = this.split(this.region, splitRow);
            try {
                for (int i = 0; i < regions.length; ++i) {
                    regions[i] = this.openClosedRegion(regions[i]);
                }
                Path oldRegionPath = this.region.getRegionDir();
                long startTime = System.currentTimeMillis();
                HRegion[] subregions = this.region.splitRegion(splitRow);
                if (subregions != null) {
                    LOG.info((Object)("Split region elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
                    TestHRegion.assertEquals((String)"Number of subregions", (int)subregions.length, (int)2);
                    for (int i = 0; i < subregions.length; ++i) {
                        subregions[i] = this.openClosedRegion(subregions[i]);
                        subregions[i].compactStores();
                    }
                    Path oldRegion1 = subregions[0].getRegionDir();
                    Path oldRegion2 = subregions[1].getRegionDir();
                    startTime = System.currentTimeMillis();
                    this.region = HRegion.mergeAdjacent(subregions[0], subregions[1]);
                    LOG.info((Object)("Merge regions elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
                    this.fs.delete(oldRegion1, true);
                    this.fs.delete(oldRegion2, true);
                    this.fs.delete(oldRegionPath, true);
                }
                LOG.info((Object)"splitAndMerge completed.");
            }
            finally {
                for (int i = 0; i < regions.length; ++i) {
                    try {
                        regions[i].close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    public void testGetScanner_WithOkFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[][] families = new byte[][]{fam1, fam2};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Scan scan = new Scan();
        scan.addFamily(fam1);
        scan.addFamily(fam2);
        try {
            this.region.getScanner(scan);
        }
        catch (Exception e) {
            TestHRegion.assertTrue((String)"Families could not be found in Region", (boolean)false);
        }
    }

    public void testGetScanner_WithNotOkFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[][] families = new byte[][]{fam1};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        boolean ok = false;
        try {
            this.region.getScanner(scan);
        }
        catch (Exception e) {
            ok = true;
        }
        TestHRegion.assertTrue((String)"Families could not be found in Region", (boolean)ok);
    }

    public void testGetScanner_WithNoFamilies() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[] fam3 = Bytes.toBytes("fam3");
        byte[] fam4 = Bytes.toBytes("fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = new Put(row1);
        put.add(fam1, null, null);
        put.add(fam2, null, null);
        put.add(fam3, null, null);
        put.add(fam4, null, null);
        this.region.put(put);
        Scan scan = null;
        InternalScanner is = null;
        scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        is = this.region.getScanner(scan);
        TestHRegion.assertEquals((int)1, (int)((HRegion.RegionScanner)is).getStoreHeap().getHeap().size());
        scan = new Scan();
        is = this.region.getScanner(scan);
        TestHRegion.assertEquals((int)(families.length - 1), (int)((HRegion.RegionScanner)is).getStoreHeap().getHeap().size());
    }

    public void testRegionScanner_Next() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] row2 = Bytes.toBytes("row2");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] fam2 = Bytes.toBytes("fam2");
        byte[] fam3 = Bytes.toBytes("fam3");
        byte[] fam4 = Bytes.toBytes("fam4");
        byte[][] families = new byte[][]{fam1, fam2, fam3, fam4};
        long ts = System.currentTimeMillis();
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        put = new Put(row1);
        put.add(fam1, null, ts, null);
        put.add(fam2, null, ts, null);
        put.add(fam3, null, ts, null);
        put.add(fam4, null, ts, null);
        this.region.put(put);
        put = new Put(row2);
        put.add(fam1, null, ts, null);
        put.add(fam2, null, ts, null);
        put.add(fam3, null, ts, null);
        put.add(fam4, null, ts, null);
        this.region.put(put);
        Scan scan = new Scan();
        scan.addFamily(fam2);
        scan.addFamily(fam4);
        InternalScanner is = this.region.getScanner(scan);
        ArrayList<KeyValue> res = null;
        ArrayList<KeyValue> expected1 = new ArrayList<KeyValue>();
        expected1.add(new KeyValue(row1, fam2, null, ts, KeyValue.Type.Put, null));
        expected1.add(new KeyValue(row1, fam4, null, ts, KeyValue.Type.Put, null));
        res = new ArrayList<KeyValue>();
        is.next(res);
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals(expected1.get(i), res.get(i));
        }
        ArrayList<KeyValue> expected2 = new ArrayList<KeyValue>();
        expected2.add(new KeyValue(row2, fam2, null, ts, KeyValue.Type.Put, null));
        expected2.add(new KeyValue(row2, fam4, null, ts, KeyValue.Type.Put, null));
        res = new ArrayList();
        is.next(res);
        for (int i = 0; i < res.size(); ++i) {
            TestHRegion.assertEquals(expected2.get(i), res.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromMemStore_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("qualifier2");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.setMaxVersions(2);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("qualifier2");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        this.region.flushcache();
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        scan.setMaxVersions(2);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_ExplicitColumns_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[][] families = new byte[][]{fam1};
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("qualifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add(kv14);
        put.add(kv24);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv23);
        put.add(kv13);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv22);
        put.add(kv12);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv21);
        put.add(kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addColumn(fam1, qf1);
        scan.addColumn(fam1, qf2);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_Wildcard_FromMemStore_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("qualifier2");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[][] families = new byte[][]{fam1};
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, families);
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_Wildcard_FromFilesOnly_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("qualifier2");
        byte[] fam1 = Bytes.toBytes("fam1");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        Put put = null;
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        put = new Put(row1);
        put.add(kv13);
        put.add(kv12);
        put.add(kv11);
        put.add(kv23);
        put.add(kv22);
        put.add(kv21);
        this.region.put(put);
        this.region.flushcache();
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        scan.addFamily(fam1);
        scan.setMaxVersions(2);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testScanner_StopRow1542() throws IOException {
        byte[] tableName = Bytes.toBytes("test_table");
        byte[] family = Bytes.toBytes("testFamily");
        this.initHRegion(tableName, this.getName(), new byte[][]{family});
        byte[] row1 = Bytes.toBytes("row111");
        byte[] row2 = Bytes.toBytes("row222");
        byte[] row3 = Bytes.toBytes("row333");
        byte[] row4 = Bytes.toBytes("row444");
        byte[] row5 = Bytes.toBytes("row555");
        byte[] col1 = Bytes.toBytes("Pub111");
        byte[] col2 = Bytes.toBytes("Pub222");
        Put put = new Put(row1);
        put.add(family, col1, Bytes.toBytes(10L));
        this.region.put(put);
        put = new Put(row2);
        put.add(family, col1, Bytes.toBytes(15L));
        this.region.put(put);
        put = new Put(row3);
        put.add(family, col2, Bytes.toBytes(20L));
        this.region.put(put);
        put = new Put(row4);
        put.add(family, col2, Bytes.toBytes(30L));
        this.region.put(put);
        put = new Put(row5);
        put.add(family, col1, Bytes.toBytes(40L));
        this.region.put(put);
        Scan scan = new Scan(row3, row4);
        scan.setMaxVersions();
        scan.addColumn(family, col1);
        InternalScanner s = this.region.getScanner(scan);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        TestHRegion.assertEquals((boolean)false, (boolean)s.next(results));
        TestHRegion.assertEquals((int)0, (int)results.size());
    }

    public void testIncrementColumnValue_UpdatingInPlace() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)1, (int)store.memstore.kvset.size());
        TestHRegion.assertTrue((boolean)store.memstore.snapshot.isEmpty());
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_ConcurrentFlush() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        this.region.put(put);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    TestHRegion.this.region.flushcache();
                }
                catch (IOException e) {
                    LOG.info((Object)"test ICV, got IOE during flushcache()");
                }
            }
        };
        t.start();
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)r);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_UpdatingInPlace_Negative() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 3L;
        long amount = -1L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)result);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_AddingNew() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        put.add(fam1, this.qual2, Bytes.toBytes(value));
        this.region.put(put);
        long result = this.region.incrementColumnValue(this.row, fam1, this.qual3, amount, true);
        TestHRegion.assertEquals((long)amount, (long)result);
        Get get2 = new Get(this.row);
        get2.addColumn(fam1, this.qual3);
        Result rr = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)rr.size());
        this.assertICV(this.row, fam1, this.qual1, value);
        this.assertICV(this.row, fam1, this.qual2, value);
        this.assertICV(this.row, fam1, this.qual3, amount);
    }

    public void testIncrementColumnValue_UpdatingFromSF() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        put.add(fam1, this.qual2, Bytes.toBytes(value));
        this.region.put(put);
        this.region.flushcache();
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)0, (int)store.memstore.kvset.size());
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual1, amount, true);
        TestHRegion.assertEquals((long)(value + amount), (long)r);
        this.assertICV(this.row, fam1, this.qual1, value + amount);
    }

    public void testIncrementColumnValue_AddingNewAfterSFCheck() throws IOException {
        this.initHRegion(this.tableName, this.getName(), new byte[][]{fam1});
        long value = 1L;
        long amount = 3L;
        Put put = new Put(this.row);
        put.add(fam1, this.qual1, Bytes.toBytes(value));
        put.add(fam1, this.qual2, Bytes.toBytes(value));
        this.region.put(put);
        this.region.flushcache();
        Store store = this.region.getStore(fam1);
        TestHRegion.assertEquals((int)0, (int)store.memstore.kvset.size());
        long r = this.region.incrementColumnValue(this.row, fam1, this.qual3, amount, true);
        TestHRegion.assertEquals((long)amount, (long)r);
        this.assertICV(this.row, fam1, this.qual3, amount);
        this.region.flushcache();
        this.assertICV(this.row, fam1, this.qual3, amount);
    }

    private void assertICV(byte[] row, byte[] familiy, byte[] qualifier, long amount) throws IOException {
        Get get2 = new Get(row);
        get2.addColumn(familiy, qualifier);
        Result result = this.region.get(get2, null);
        TestHRegion.assertEquals((int)1, (int)result.size());
        KeyValue kv = result.raw()[0];
        long r = Bytes.toLong(kv.getValue());
        TestHRegion.assertEquals((long)amount, (long)r);
    }

    public void testScanner_Wildcard_FromMemStoreAndFiles_EnforceVersions() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] row1 = Bytes.toBytes("row1");
        byte[] fam1 = Bytes.toBytes("fam1");
        byte[] qf1 = Bytes.toBytes("qualifier1");
        byte[] qf2 = Bytes.toBytes("quateslifier2");
        long ts1 = 1L;
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        long ts4 = ts1 + 3L;
        String method = this.getName();
        this.initHRegion(tableName, method, new byte[][]{fam1});
        KeyValue kv14 = new KeyValue(row1, fam1, qf1, ts4, KeyValue.Type.Put, null);
        KeyValue kv13 = new KeyValue(row1, fam1, qf1, ts3, KeyValue.Type.Put, null);
        KeyValue kv12 = new KeyValue(row1, fam1, qf1, ts2, KeyValue.Type.Put, null);
        KeyValue kv11 = new KeyValue(row1, fam1, qf1, ts1, KeyValue.Type.Put, null);
        KeyValue kv24 = new KeyValue(row1, fam1, qf2, ts4, KeyValue.Type.Put, null);
        KeyValue kv23 = new KeyValue(row1, fam1, qf2, ts3, KeyValue.Type.Put, null);
        KeyValue kv22 = new KeyValue(row1, fam1, qf2, ts2, KeyValue.Type.Put, null);
        KeyValue kv21 = new KeyValue(row1, fam1, qf2, ts1, KeyValue.Type.Put, null);
        Put put = null;
        put = new Put(row1);
        put.add(kv14);
        put.add(kv24);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv23);
        put.add(kv13);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv22);
        put.add(kv12);
        this.region.put(put);
        this.region.flushcache();
        put = new Put(row1);
        put.add(kv21);
        put.add(kv11);
        this.region.put(put);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(kv14);
        expected.add(kv13);
        expected.add(kv12);
        expected.add(kv24);
        expected.add(kv23);
        expected.add(kv22);
        Scan scan = new Scan(row1);
        int versions = 3;
        scan.setMaxVersions(versions);
        ArrayList<KeyValue> actual = new ArrayList<KeyValue>();
        InternalScanner scanner = this.region.getScanner(scan);
        boolean hasNext = scanner.next(actual);
        TestHRegion.assertEquals((boolean)false, (boolean)hasNext);
        for (int i = 0; i < expected.size(); ++i) {
            TestHRegion.assertEquals(expected.get(i), actual.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicSplit() throws Exception {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[][] families = new byte[][]{fam1, fam2, fam3};
        HBaseConfiguration hc = this.initSplit();
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        try {
            LOG.info((Object)("" + TestHRegion.addContent(this.region, fam3)));
            this.region.flushcache();
            byte[] splitRow = this.region.compactStores();
            TestHRegion.assertNotNull((Object)splitRow);
            LOG.info((Object)("SplitRow: " + Bytes.toString(splitRow)));
            HRegion[] regions = this.split(this.region, splitRow);
            try {
                int i;
                for (i = 0; i < regions.length; ++i) {
                    regions[i] = this.openClosedRegion(regions[i]);
                }
                this.assertGet(regions[0], fam3, Bytes.toBytes(this.START_KEY));
                this.assertGet(regions[1], fam3, splitRow);
                this.assertScan(regions[0], fam3, Bytes.toBytes(this.START_KEY));
                this.assertScan(regions[1], fam3, splitRow);
                for (i = 0; i < regions.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        TestHRegion.addContent(regions[i], fam3);
                    }
                    TestHRegion.addContent(regions[i], fam2);
                    TestHRegion.addContent(regions[i], fam1);
                    regions[i].flushcache();
                }
                byte[][] midkeys = new byte[regions.length][];
                for (int i2 = 0; i2 < regions.length; ++i2) {
                    midkeys[i2] = regions[i2].compactStores();
                }
                TreeMap<String, HRegion> sortedMap = new TreeMap<String, HRegion>();
                for (int i3 = 0; i3 < regions.length; ++i3) {
                    HRegion[] rs = null;
                    if (midkeys[i3] == null) continue;
                    rs = this.split(regions[i3], midkeys[i3]);
                    for (int j = 0; j < rs.length; ++j) {
                        sortedMap.put(Bytes.toString(rs[j].getRegionName()), this.openClosedRegion(rs[j]));
                    }
                }
                LOG.info((Object)"Made 4 regions");
                int interval = 8;
                byte[] b = Bytes.toBytes(this.START_KEY);
                for (HRegion r : sortedMap.values()) {
                    this.assertGet(r, fam3, b);
                    b[0] = (byte)(b[0] + interval);
                }
            }
            finally {
                for (int i = 0; i < regions.length; ++i) {
                    try {
                        regions[i].close();
                        continue;
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitRegion() throws IOException {
        byte[] tableName = Bytes.toBytes("testtable");
        byte[] qualifier = Bytes.toBytes("qualifier");
        HBaseConfiguration hc = this.initSplit();
        int numRows = 10;
        byte[][] families = new byte[][]{fam1, fam3};
        String method = this.getName();
        this.initHRegion(tableName, method, hc, (byte[][])families);
        int startRow = 100;
        this.putData(startRow, numRows, qualifier, families);
        int splitRow = startRow + numRows;
        this.putData(splitRow, numRows, qualifier, families);
        this.region.flushcache();
        HRegion[] regions = null;
        try {
            regions = this.region.splitRegion(Bytes.toBytes("" + splitRow));
            for (int i = 0; i < regions.length; ++i) {
                regions[i] = this.openClosedRegion(regions[i]);
            }
            TestHRegion.assertEquals((int)2, (int)regions.length);
            this.verifyData(regions[0], startRow, numRows, qualifier, families);
            this.verifyData(regions[1], splitRow, numRows, qualifier, families);
        }
        finally {
            if (this.region != null) {
                this.region.close();
                this.region.getLog().closeAndDelete();
            }
        }
    }

    public void testFlushCacheWhileScanning() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testFlushCacheWhileScanning");
        byte[] family = Bytes.toBytes("family");
        int numRows = 1000;
        int flushAndScanInterval = 10;
        int compactInterval = 10 * flushAndScanInterval;
        String method = "testFlushCacheWhileScanning";
        this.initHRegion(tableName, method, new byte[][]{family});
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Scan scan = new Scan();
        scan.addFamily(family);
        scan.setFilter(new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes(5L))));
        int expectedCount = 0;
        ArrayList<KeyValue> res = new ArrayList<KeyValue>();
        boolean toggle = true;
        for (long i = 0L; i < (long)numRows; ++i) {
            Put put = new Put(Bytes.toBytes(i));
            put.add(family, this.qual1, Bytes.toBytes(i % 10L));
            this.region.put(put);
            if (i != 0L && i % (long)compactInterval == 0L) {
                this.region.compactStores(true);
            }
            if (i % 10L == 5L) {
                ++expectedCount;
            }
            if (i == 0L || i % (long)flushAndScanInterval != 0L) continue;
            res.clear();
            InternalScanner scanner = this.region.getScanner(scan);
            if (toggle) {
                flushThread.flush();
            }
            while (scanner.next(res)) {
            }
            if (!toggle) {
                flushThread.flush();
            }
            Assert.assertEquals((String)("i=" + i), (int)expectedCount, (int)res.size());
            toggle = !toggle;
        }
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testWritesWhileScanning() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testWritesWhileScanning");
        int testCount = 100;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int flushInterval = 7;
        int compactInterval = 5 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes("family" + i);
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes("qual" + i);
        }
        String method = "testWritesWhileScanning";
        this.initHRegion(tableName, method, families);
        PutThread putThread = new PutThread(numRows, families, qualifiers);
        putThread.start();
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Scan scan = new Scan();
        scan.setFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("row0"))));
        int expectedCount = numFamilies * numQualifiers;
        ArrayList<KeyValue> res = new ArrayList<KeyValue>();
        long prevTimestamp = 0L;
        for (int i = 0; i < testCount; ++i) {
            if (i != 0 && i % compactInterval == 0) {
                this.region.compactStores(true);
            }
            if (i != 0 && i % flushInterval == 0) {
                flushThread.flush();
            }
            boolean previousEmpty = res.isEmpty();
            res.clear();
            InternalScanner scanner = this.region.getScanner(scan);
            while (scanner.next(res)) {
            }
            if (res.isEmpty() && previousEmpty && i <= compactInterval) continue;
            Assert.assertEquals((String)("i=" + i), (int)expectedCount, (int)res.size());
            long timestamp = ((KeyValue)res.get(0)).getTimestamp();
            Assert.assertTrue((timestamp >= prevTimestamp ? 1 : 0) != 0);
            prevTimestamp = timestamp;
        }
        putThread.done();
        putThread.join();
        putThread.checkNoError();
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testWritesWhileGetting() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes("testWritesWhileScanning");
        int testCount = 200;
        int numRows = 1;
        int numFamilies = 10;
        int numQualifiers = 100;
        int flushInterval = 10;
        int compactInterval = 10 * flushInterval;
        byte[][] families = new byte[numFamilies][];
        for (int i = 0; i < numFamilies; ++i) {
            families[i] = Bytes.toBytes("family" + i);
        }
        byte[][] qualifiers = new byte[numQualifiers][];
        for (int i = 0; i < numQualifiers; ++i) {
            qualifiers[i] = Bytes.toBytes("qual" + i);
        }
        String method = "testWritesWhileScanning";
        this.initHRegion(tableName, method, families);
        PutThread putThread = new PutThread(numRows, families, qualifiers);
        putThread.start();
        FlushThread flushThread = new FlushThread();
        flushThread.start();
        Get get2 = new Get(Bytes.toBytes("row0"));
        Result result = null;
        int expectedCount = numFamilies * numQualifiers;
        long prevTimestamp = 0L;
        for (int i = 0; i < testCount; ++i) {
            if (i != 0 && i % compactInterval == 0) {
                this.region.compactStores(true);
            }
            if (i != 0 && i % flushInterval == 0) {
                flushThread.flush();
            }
            boolean previousEmpty = result == null || result.isEmpty();
            result = this.region.get(get2, null);
            if (result.isEmpty() && previousEmpty && i <= compactInterval) continue;
            Assert.assertEquals((String)("i=" + i), (int)expectedCount, (int)result.size());
            long timestamp = result.getCellValue(families[0], qualifiers[0]).getTimestamp();
            Assert.assertTrue((timestamp >= prevTimestamp ? 1 : 0) != 0);
            prevTimestamp = timestamp;
        }
        putThread.done();
        putThread.join();
        putThread.checkNoError();
        flushThread.done();
        flushThread.join();
        flushThread.checkNoError();
    }

    public void testIndexesScanWithOneDeletedRow() throws IOException {
        byte[] tableName = Bytes.toBytes("testIndexesScanWithOneDeletedRow");
        byte[] family = Bytes.toBytes("family");
        String method = "testIndexesScanWithOneDeletedRow";
        this.initHRegion(tableName, method, new HBaseConfiguration(), (byte[][])new byte[][]{family});
        Put put = new Put(Bytes.toBytes(1L));
        put.add(family, this.qual1, 1L, Bytes.toBytes(1L));
        this.region.put(put);
        this.region.flushcache();
        Delete delete = new Delete(Bytes.toBytes(1L), 1L, null);
        this.region.delete(delete, null, true);
        put = new Put(Bytes.toBytes(2L));
        put.add(family, this.qual1, 2L, Bytes.toBytes(2L));
        this.region.put(put);
        Scan idxScan = new Scan();
        idxScan.addFamily(family);
        idxScan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.GREATER_OR_EQUAL, new BinaryComparator(Bytes.toBytes(0L))), new SingleColumnValueFilter(family, this.qual1, CompareFilter.CompareOp.LESS_OR_EQUAL, new BinaryComparator(Bytes.toBytes(3L))))));
        InternalScanner scanner = this.region.getScanner(idxScan);
        ArrayList<KeyValue> res = new ArrayList<KeyValue>();
        while (scanner.next(res)) {
        }
        TestHRegion.assertEquals((long)1L, (long)res.size());
    }

    private void putData(int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes("" + i));
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            this.region.put(put);
        }
    }

    private void verifyData(HRegion newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes("" + i);
            Get get2 = new Get(row);
            for (byte[] family : families) {
                get2.addColumn(family, qf);
            }
            Result result = newReg.get(get2, null);
            KeyValue[] raw = result.sorted();
            TestHRegion.assertEquals((int)families.length, (int)result.size());
            for (int j = 0; j < families.length; ++j) {
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(row, raw[j].getRow()));
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(families[j], raw[j].getFamily()));
                TestHRegion.assertEquals((int)0, (int)Bytes.compareTo(qf, raw[j].getQualifier()));
            }
        }
    }

    private void assertGet(HRegion r, byte[] family, byte[] k) throws IOException {
        Get get2 = new Get(k).addFamily(family).setMaxVersions();
        KeyValue[] results = r.get(get2, null).raw();
        for (int j = 0; j < results.length; ++j) {
            byte[] tmp = results[j].getValue();
            TestHRegion.assertTrue((boolean)Bytes.equals(k, tmp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertScan(HRegion r, byte[] fs, byte[] firstValue) throws IOException {
        block7: {
            byte[][] families = new byte[][]{fs};
            Scan scan = new Scan();
            for (int i = 0; i < families.length; ++i) {
                scan.addFamily(families[i]);
            }
            InternalScanner s = r.getScanner(scan);
            try {
                ArrayList<KeyValue> curVals = new ArrayList<KeyValue>();
                boolean first = true;
                while (s.next(curVals)) {
                    for (KeyValue kv : curVals) {
                        byte[] val;
                        byte[] curval = val = kv.getValue();
                        if (first) {
                            first = false;
                            TestHRegion.assertTrue((Bytes.compareTo(curval, firstValue) == 0 ? 1 : 0) != 0);
                            continue;
                        }
                        break block7;
                    }
                }
            }
            finally {
                s.close();
            }
        }
    }

    protected HRegion[] split(HRegion r, byte[] splitRow) throws IOException {
        this.assertGet(r, fam3, splitRow);
        HRegion[] regions = r.splitRegion(splitRow);
        TestHRegion.assertEquals((int)regions.length, (int)2);
        return regions;
    }

    private HBaseConfiguration initSplit() {
        HBaseConfiguration conf = new HBaseConfiguration();
        conf.setInt("hbase.hstore.compactionThreshold", 2);
        conf.setInt("hbase.master.lease.period", 10000);
        conf.setInt("hbase.master.lease.thread.wakefrequency", 5000);
        conf.setInt("hbase.regionserver.lease.period", 10000);
        conf.setLong("hbase.client.pause", 15000L);
        conf.setLong("hbase.hregion.max.filesize", 131072L);
        return conf;
    }

    private void initHRegion(byte[] tableName, String callingMethod, byte[] ... families) throws IOException {
        this.initHRegion(tableName, callingMethod, new HBaseConfiguration(), families);
    }

    protected void initHRegion(byte[] tableName, String callingMethod, HBaseConfiguration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = this.constructTableDescriptor(tableName, families);
        HRegionInfo info = new HRegionInfo(htd, null, null, false);
        Path path = new Path("test/build/data/TestHRegion/" + callingMethod);
        this.region = HRegion.createHRegion(info, path, conf);
    }

    protected HTableDescriptor constructTableDescriptor(byte[] tableName, byte[] ... families) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        return htd;
    }

    protected class PutThread
    extends Thread {
        private volatile boolean done;
        private Throwable error = null;
        private int numRows;
        private byte[][] families;
        private byte[][] qualifiers;

        private PutThread(int numRows, byte[][] families, byte[][] qualifiers) {
            this.numRows = numRows;
            this.families = families;
            this.qualifiers = qualifiers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            PutThread putThread = this;
            synchronized (putThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        @Override
        public void run() {
            this.done = false;
            int val = 0;
            while (!this.done) {
                try {
                    for (int r = 0; r < this.numRows; ++r) {
                        byte[] row = Bytes.toBytes("row" + r);
                        Put put = new Put(row);
                        for (int f = 0; f < this.families.length; ++f) {
                            for (int q = 0; q < this.qualifiers.length; ++q) {
                                put.add(this.families[f], this.qualifiers[q], val, Bytes.toBytes(val));
                            }
                        }
                        TestHRegion.this.region.put(put);
                        if (val > 0 && val % 47 == 0) {
                            Delete delete = new Delete(row, (long)val - 30L, null);
                            TestHRegion.this.region.delete(delete, null, true);
                        }
                        ++val;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"error while putting records", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }
    }

    protected class FlushThread
    extends Thread {
        private volatile boolean done;
        private Throwable error = null;

        protected FlushThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.done = true;
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.interrupt();
            }
        }

        public void checkNoError() {
            if (this.error != null) {
                Assert.assertNull((Object)this.error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.done = false;
            while (!this.done) {
                FlushThread flushThread = this;
                synchronized (flushThread) {
                    block8: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ignored) {
                            if (!this.done) break block8;
                            break;
                        }
                    }
                }
                try {
                    TestHRegion.this.region.flushcache();
                }
                catch (IOException e) {
                    if (this.done) break;
                    LOG.error((Object)"Error while flusing cache", (Throwable)e);
                    this.error = e;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            FlushThread flushThread = this;
            synchronized (flushThread) {
                this.notify();
            }
        }
    }
}

