/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MinorCompactingStoreScanner;

public class TestMinorCompactingStoreScanner
extends TestCase {
    public void testDeleteFamiliy() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", "cf", "a", 100L, KeyValue.Type.DeleteFamily, "dont-care"), KeyValueTestUtil.create("R1", "cf", "b", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "c", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "d", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "e", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "e", 11L, KeyValue.Type.DeleteColumn, "dont-care"), KeyValueTestUtil.create("R1", "cf", "f", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "g", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "g", 11L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R1", "cf", "h", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "i", 11L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R2", "cf", "a", 11L, KeyValue.Type.Put, "dont-care")};
        KeyValueScanner[] scanners = new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)};
        MinorCompactingStoreScanner scan = new MinorCompactingStoreScanner("cf", KeyValue.COMPARATOR, scanners);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        TestMinorCompactingStoreScanner.assertTrue((boolean)scan.next(results));
        TestMinorCompactingStoreScanner.assertEquals((int)3, (int)results.size());
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[5], results.get(1));
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[8], results.get(2));
        results.clear();
        TestMinorCompactingStoreScanner.assertFalse((boolean)scan.next(results));
        TestMinorCompactingStoreScanner.assertEquals((int)1, (int)results.size());
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
    }

    public void testDeleteVersion() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create("R1", "cf", "a", 15L, KeyValue.Type.Put, "dont-care"), KeyValueTestUtil.create("R1", "cf", "a", 10L, KeyValue.Type.Delete, "dont-care"), KeyValueTestUtil.create("R1", "cf", "a", 10L, KeyValue.Type.Put, "dont-care")};
        KeyValueScanner[] scanners = new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)};
        MinorCompactingStoreScanner scan = new MinorCompactingStoreScanner("cf", KeyValue.COMPARATOR, scanners);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        TestMinorCompactingStoreScanner.assertFalse((boolean)scan.next(results));
        TestMinorCompactingStoreScanner.assertEquals((int)2, (int)results.size());
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestMinorCompactingStoreScanner.assertEquals((Object)kvs[1], results.get(1));
    }
}

