/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.regionserver.WildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class TestWildcardColumnTracker
extends HBaseTestCase
implements HConstants {
    private boolean PRINT = false;

    public void testGet_SingleVersion() {
        if (this.PRINT) {
            System.out.println("SingleVersion");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        expected.add(QueryMatcher.MatchCode.INCLUDE);
        int maxVersions = 1;
        WildcardColumnTracker exp = new WildcardColumnTracker(maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col4);
        scanner.add(col5);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] col : scanner) {
            result.add(exp.checkColumn(col, 0, col.length));
        }
        TestWildcardColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestWildcardColumnTracker.assertEquals(expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }

    public void testGet_MultiVersion() {
        if (this.PRINT) {
            System.out.println("\nMultiVersion");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        int size = 5;
        for (int i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.INCLUDE);
            expected.add(QueryMatcher.MatchCode.INCLUDE);
            expected.add(QueryMatcher.MatchCode.SKIP);
        }
        int maxVersions = 2;
        WildcardColumnTracker exp = new WildcardColumnTracker(maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col1);
        scanner.add(col1);
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col2);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col3);
        scanner.add(col3);
        scanner.add(col4);
        scanner.add(col4);
        scanner.add(col4);
        scanner.add(col5);
        scanner.add(col5);
        scanner.add(col5);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] col : scanner) {
            result.add(exp.checkColumn(col, 0, col.length));
        }
        TestWildcardColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            TestWildcardColumnTracker.assertEquals(expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }

    public void testUpdate_SameColumns() {
        int i;
        int i2;
        if (this.PRINT) {
            System.out.println("\nUpdate_SameColumns");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        int size = 10;
        for (i2 = 0; i2 < size; ++i2) {
            expected.add(QueryMatcher.MatchCode.INCLUDE);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            expected.add(QueryMatcher.MatchCode.SKIP);
        }
        int maxVersions = 2;
        WildcardColumnTracker wild = new WildcardColumnTracker(maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col4);
        scanner.add(col5);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (i = 0; i < 3; ++i) {
            for (byte[] col : scanner) {
                result.add(wild.checkColumn(col, 0, col.length));
            }
            wild.update();
        }
        TestWildcardColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (i = 0; i < expected.size(); ++i) {
            TestWildcardColumnTracker.assertEquals(expected.get(i), result.get(i));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i) + ", actual " + result.get(i));
        }
    }

    public void testUpdate_NewColumns() {
        int i;
        if (this.PRINT) {
            System.out.println("\nUpdate_NewColumns");
        }
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        byte[] col6 = Bytes.toBytes("col6");
        byte[] col7 = Bytes.toBytes("col7");
        byte[] col8 = Bytes.toBytes("col8");
        byte[] col9 = Bytes.toBytes("col9");
        byte[] col0 = Bytes.toBytes("col0");
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        int size = 10;
        for (i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.INCLUDE);
        }
        for (i = 0; i < 5; ++i) {
            expected.add(QueryMatcher.MatchCode.SKIP);
        }
        int maxVersions = 1;
        WildcardColumnTracker wild = new WildcardColumnTracker(maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col0);
        scanner.add(col1);
        scanner.add(col2);
        scanner.add(col3);
        scanner.add(col4);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (byte[] col : scanner) {
            result.add(wild.checkColumn(col, 0, col.length));
        }
        wild.update();
        ArrayList<byte[]> scanner1 = new ArrayList<byte[]>();
        scanner1.add(col5);
        scanner1.add(col6);
        scanner1.add(col7);
        scanner1.add(col8);
        scanner1.add(col9);
        for (byte[] col : scanner1) {
            result.add(wild.checkColumn(col, 0, col.length));
        }
        wild.update();
        for (byte[] col : scanner) {
            result.add(wild.checkColumn(col, 0, col.length));
        }
        TestWildcardColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i2 = 0; i2 < expected.size(); ++i2) {
            TestWildcardColumnTracker.assertEquals(expected.get(i2), result.get(i2));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i2) + ", actual " + result.get(i2));
        }
    }

    public void testUpdate_MixedColumns() {
        int i;
        if (this.PRINT) {
            System.out.println("\nUpdate_NewColumns");
        }
        byte[] col0 = Bytes.toBytes("col0");
        byte[] col1 = Bytes.toBytes("col1");
        byte[] col2 = Bytes.toBytes("col2");
        byte[] col3 = Bytes.toBytes("col3");
        byte[] col4 = Bytes.toBytes("col4");
        byte[] col5 = Bytes.toBytes("col5");
        byte[] col6 = Bytes.toBytes("col6");
        byte[] col7 = Bytes.toBytes("col7");
        byte[] col8 = Bytes.toBytes("col8");
        byte[] col9 = Bytes.toBytes("col9");
        ArrayList<QueryMatcher.MatchCode> expected = new ArrayList<QueryMatcher.MatchCode>();
        int size = 5;
        for (i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.INCLUDE);
        }
        for (i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.SKIP);
        }
        for (i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.INCLUDE);
        }
        for (i = 0; i < size; ++i) {
            expected.add(QueryMatcher.MatchCode.SKIP);
        }
        int maxVersions = 1;
        WildcardColumnTracker wild = new WildcardColumnTracker(maxVersions);
        ArrayList<byte[]> scanner = new ArrayList<byte[]>();
        scanner.add(col0);
        scanner.add(col2);
        scanner.add(col4);
        scanner.add(col6);
        scanner.add(col8);
        ArrayList<QueryMatcher.MatchCode> result = new ArrayList<QueryMatcher.MatchCode>();
        for (int i2 = 0; i2 < 2; ++i2) {
            for (byte[] col : scanner) {
                result.add(wild.checkColumn(col, 0, col.length));
            }
            wild.update();
        }
        ArrayList<byte[]> scanner1 = new ArrayList<byte[]>();
        scanner1.add(col1);
        scanner1.add(col3);
        scanner1.add(col5);
        scanner1.add(col7);
        scanner1.add(col9);
        for (byte[] col : scanner1) {
            result.add(wild.checkColumn(col, 0, col.length));
        }
        wild.update();
        for (byte[] col : scanner) {
            result.add(wild.checkColumn(col, 0, col.length));
        }
        TestWildcardColumnTracker.assertEquals((int)expected.size(), (int)result.size());
        for (int i3 = 0; i3 < expected.size(); ++i3) {
            TestWildcardColumnTracker.assertEquals(expected.get(i3), result.get(i3));
            if (!this.PRINT) continue;
            System.out.println("Expected " + expected.get(i3) + ", actual " + result.get(i3));
        }
    }

    public void testStackOverflow() {
        byte[] col;
        int i;
        int maxVersions = 1;
        WildcardColumnTracker wild = new WildcardColumnTracker(maxVersions);
        for (i = 0; i < 100000; i += 2) {
            col = Bytes.toBytes("col" + i);
            wild.checkColumn(col, 0, col.length);
        }
        wild.update();
        for (i = 1; i < 100000; i += 2) {
            col = Bytes.toBytes("col" + i);
            wild.checkColumn(col, 0, col.length);
        }
    }
}

