/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import agilejson.TOJSON;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;

public class TableModel
extends AbstractModel {
    private Log LOG = LogFactory.getLog(TableModel.class);

    public TableModel(HBaseConfiguration config, HBaseAdmin admin) {
        super.initialize(config, admin);
    }

    public Result[] get(byte[] tableName) throws HBaseRestException {
        return this.get(tableName, this.getColumns(tableName));
    }

    public Result[] get(byte[] tableName, byte[][] columnNames) throws HBaseRestException {
        try {
            Result r;
            ArrayList<Result> a = new ArrayList<Result>();
            HTable table = new HTable(this.conf, tableName);
            Scan scan = new Scan();
            scan.addColumns(columnNames);
            ResultScanner s = table.getScanner(scan);
            while ((r = s.next()) != null) {
                a.add(r);
            }
            return a.toArray(new Result[0]);
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
    }

    protected boolean doesTableExist(byte[] tableName) throws HBaseRestException {
        try {
            return this.admin.tableExists(tableName);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    protected void disableTable(byte[] tableName) throws HBaseRestException {
        try {
            this.admin.disableTable(tableName);
        }
        catch (IOException e) {
            throw new HBaseRestException("IOException disabling table", e);
        }
    }

    protected void enableTable(byte[] tableName) throws HBaseRestException {
        try {
            this.admin.enableTable(tableName);
        }
        catch (IOException e) {
            throw new HBaseRestException("IOException enabiling table", e);
        }
    }

    public boolean updateTable(String tableName, ArrayList<HColumnDescriptor> columns) throws HBaseRestException {
        HTableDescriptor htc = null;
        try {
            htc = this.admin.getTableDescriptor(Bytes.toBytes(tableName));
        }
        catch (IOException e) {
            throw new HBaseRestException("Table does not exist");
        }
        for (HColumnDescriptor column : columns) {
            if (htc.hasFamily(Bytes.toBytes(column.getNameAsString()))) {
                try {
                    this.admin.disableTable(tableName);
                    this.admin.modifyColumn(tableName, column.getNameAsString(), column);
                    this.admin.enableTable(tableName);
                    continue;
                }
                catch (IOException e) {
                    throw new HBaseRestException("unable to modify column " + column.getNameAsString(), e);
                }
            }
            try {
                this.admin.disableTable(tableName);
                this.admin.addColumn(tableName, column);
                this.admin.enableTable(tableName);
            }
            catch (IOException e) {
                throw new HBaseRestException("unable to add column " + column.getNameAsString(), e);
            }
        }
        return true;
    }

    public HTableDescriptor getTableMetadata(String tableName) throws HBaseRestException {
        HTableDescriptor descriptor = null;
        try {
            HTableDescriptor[] tables = this.admin.listTables();
            for (int i = 0; i < tables.length; ++i) {
                if (!Bytes.toString(tables[i].getName()).equals(tableName)) continue;
                descriptor = tables[i];
                break;
            }
            if (descriptor != null) {
                return descriptor;
            }
        }
        catch (IOException e) {
            throw new HBaseRestException("error processing request.");
        }
        return descriptor;
    }

    public Regions getTableRegions(String tableName) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Regions regions = new Regions(table.getStartKeys());
            return regions;
        }
        catch (IOException e) {
            throw new HBaseRestException("Unable to get regions from table");
        }
    }

    public boolean post(byte[] tableName, HTableDescriptor htd) throws HBaseRestException {
        try {
            if (!this.admin.tableExists(tableName)) {
                this.admin.createTable(htd);
                return true;
            }
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
        return false;
    }

    public boolean delete(byte[] tableName) throws HBaseRestException {
        try {
            if (this.admin.tableExists(tableName)) {
                this.admin.disableTable(tableName);
                this.admin.deleteTable(tableName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
    }

    public static class Regions
    implements ISerializable {
        byte[][] regionKey;

        public Regions(byte[][] bs) {
            this.regionKey = bs;
        }

        private Regions() {
        }

        @TOJSON(fieldName="region")
        public byte[][] getRegionKey() {
            return this.regionKey;
        }

        public void setRegionKey(byte[][] regionKey) {
            this.regionKey = regionKey;
        }

        @Override
        public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
            serializer.serializeRegionData(this);
        }
    }
}

