/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.HBaseClusterTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MetaUtils;

public class DisabledTestMetaUtils
extends HBaseClusterTestCase {
    public void testColumnEdits() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        String oldColumn = "oldcolumn:";
        for (int i = 0; i < 5; ++i) {
            HTableDescriptor htd = new HTableDescriptor(this.getName() + i);
            htd.addFamily(new HColumnDescriptor("oldcolumn:"));
            admin.createTable(htd);
        }
        this.cluster.shutdown();
        this.cluster = null;
        MetaUtils utils = new MetaUtils(this.conf);
        byte[] editTable = Bytes.toBytes(this.getName() + 2);
        byte[] newColumn = Bytes.toBytes("newcolumn:");
        utils.addColumn(editTable, new HColumnDescriptor(newColumn));
        utils.deleteColumn(editTable, Bytes.toBytes("oldcolumn:"));
        utils.shutdown();
        HConnectionManager.deleteConnectionInfo(this.conf, false);
        this.cluster = new MiniHBaseCluster(this.conf, 1);
        HTable t = new HTable(this.conf, editTable);
        HTableDescriptor htd = t.getTableDescriptor();
        HColumnDescriptor hcd = htd.getFamily(newColumn);
        DisabledTestMetaUtils.assertTrue((hcd != null ? 1 : 0) != 0);
        DisabledTestMetaUtils.assertNull((Object)htd.getFamily(Bytes.toBytes("oldcolumn:")));
    }
}

