/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.util.Keying;

public class TestKeying
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testURI() throws Exception {
        this.checkTransform("http://abc:bcd@www.example.com/index.html?query=something#middle");
        this.checkTransform("file:///usr/bin/java");
        this.checkTransform("dns:www.powerset.com");
        this.checkTransform("dns://dns.powerset.com/www.powerset.com");
        this.checkTransform("http://one.two.three/index.html");
        this.checkTransform("https://one.two.three:9443/index.html");
        this.checkTransform("ftp://one.two.three/index.html");
        this.checkTransform("filename");
    }

    private void checkTransform(String u) {
        String k = Keying.createKey(u);
        String uri = Keying.keyToUri(k);
        System.out.println("Original url " + u + ", Transformed url " + k);
        TestKeying.assertEquals((String)u, (String)uri);
    }
}

