/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.io.WritableComparable;

public class HServerInfo
implements WritableComparable<HServerInfo> {
    private HServerAddress serverAddress;
    private long startCode;
    private HServerLoad load;
    private int infoPort;
    private String serverName = null;
    private String name;
    private static Map<String, String> dnsCache = new HashMap<String, String>();

    public HServerInfo() {
        this(new HServerAddress(), 0L, 60030, "default name");
    }

    public HServerInfo(HServerAddress serverAddress, long startCode, int infoPort, String name) {
        this.serverAddress = serverAddress;
        this.startCode = startCode;
        this.load = new HServerLoad();
        this.infoPort = infoPort;
        this.name = name;
    }

    public HServerInfo(HServerInfo other) {
        this.serverAddress = new HServerAddress(other.getServerAddress());
        this.startCode = other.getStartCode();
        this.load = other.getLoad();
        this.infoPort = other.getInfoPort();
        this.name = other.getName();
    }

    public HServerLoad getLoad() {
        return this.load;
    }

    public void setLoad(HServerLoad load) {
        this.load = load;
    }

    public synchronized HServerAddress getServerAddress() {
        return new HServerAddress(this.serverAddress);
    }

    public synchronized void setServerAddress(HServerAddress serverAddress) {
        this.serverAddress = serverAddress;
        this.serverName = null;
    }

    public synchronized long getStartCode() {
        return this.startCode;
    }

    public int getInfoPort() {
        return this.infoPort;
    }

    public void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    public synchronized void setStartCode(long startCode) {
        this.startCode = startCode;
        this.serverName = null;
    }

    public synchronized String getServerName() {
        if (this.serverName == null) {
            this.serverName = HServerInfo.getServerName(this.serverAddress, this.startCode);
        }
        return this.serverName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "address: " + this.serverAddress + ", startcode: " + this.startCode + ", load: (" + this.load.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((HServerInfo)obj) == 0;
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        this.serverAddress.readFields(in);
        this.startCode = in.readLong();
        this.load.readFields(in);
        this.infoPort = in.readInt();
        this.name = in.readUTF();
    }

    public void write(DataOutput out) throws IOException {
        this.serverAddress.write(out);
        out.writeLong(this.startCode);
        this.load.write(out);
        out.writeInt(this.infoPort);
        out.writeUTF(this.name);
    }

    public int compareTo(HServerInfo o) {
        return this.getServerName().compareTo(o.getServerName());
    }

    public static String getServerName(HServerInfo info) {
        return HServerInfo.getServerName(info.getServerAddress(), info.getStartCode());
    }

    public static String getServerName(String serverAddress, long startCode) {
        String name = null;
        if (serverAddress != null) {
            int colonIndex = serverAddress.lastIndexOf(58);
            if (colonIndex < 0) {
                throw new IllegalArgumentException("Not a host:port pair: " + serverAddress);
            }
            String host = serverAddress.substring(0, colonIndex);
            int port = Integer.valueOf(serverAddress.substring(colonIndex + 1));
            if (!dnsCache.containsKey(host)) {
                HServerAddress address = new HServerAddress(serverAddress);
                dnsCache.put(host, address.getHostname());
            }
            host = dnsCache.get(host);
            name = HServerInfo.getServerName(host, port, startCode);
        }
        return name;
    }

    public static String getServerName(HServerAddress address, long startCode) {
        return HServerInfo.getServerName(address.getHostname(), address.getPort(), startCode);
    }

    private static String getServerName(String hostName, int port, long startCode) {
        StringBuilder name = new StringBuilder(hostName);
        name.append(",");
        name.append(port);
        name.append(",");
        name.append(startCode);
        return name.toString();
    }
}

