/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;

public class PageFilter
implements Filter {
    private long pageSize = Long.MAX_VALUE;
    private int rowsAccepted = 0;

    public PageFilter() {
    }

    public PageFilter(long pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean filterAllRemaining() {
        return (long)this.rowsAccepted >= this.pageSize;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return false;
    }

    public void readFields(DataInput in) throws IOException {
        this.pageSize = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.pageSize);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        ++this.rowsAccepted;
        return (long)this.rowsAccepted > this.pageSize;
    }
}

