/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;

public class WhileMatchRowFilter
implements RowFilterInterface {
    private boolean filterAllRemaining = false;
    private RowFilterInterface filter;

    public WhileMatchRowFilter() {
    }

    public WhileMatchRowFilter(RowFilterInterface filter) {
        this.filter = filter;
    }

    public RowFilterInterface getInternalFilter() {
        return this.filter;
    }

    @Override
    public void reset() {
        this.filterAllRemaining = false;
        this.filter.reset();
    }

    @Override
    public boolean processAlways() {
        return true;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.filterAllRemaining || this.filter.filterAllRemaining();
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        this.changeFAR(this.filter.filterRowKey(rowKey, 0, rowKey.length));
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        this.changeFAR(this.filter.filterRowKey(rowKey, offset, length));
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        this.changeFAR(this.filter.filterColumn(rowKey, colKey, data));
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        this.changeFAR(this.filter.filterRow(columns));
        return this.filterAllRemaining();
    }

    @Override
    public boolean filterRow(List<KeyValue> results) {
        this.changeFAR(this.filter.filterRow(results));
        return this.filterAllRemaining();
    }

    private void changeFAR(boolean value) {
        this.filterAllRemaining = this.filterAllRemaining || value;
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] rowKey) {
        this.filter.rowProcessed(filtered, rowKey, 0, rowKey.length);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
        this.filter.rowProcessed(filtered, key, offset, length);
    }

    @Override
    public void validate(byte[][] columns) {
        this.filter.validate(columns);
    }

    public void readFields(DataInput in) throws IOException {
        String className = in.readUTF();
        try {
            this.filter = (RowFilterInterface)Class.forName(className).newInstance();
            this.filter.readFields(in);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to deserialize WhileMatchRowFilter.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to deserialize WhileMatchRowFilter.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize WhileMatchRowFilter.", e);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.filter.getClass().getName());
        this.filter.write(out);
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] colunmName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        this.changeFAR(this.filter.filterColumn(rowKey, roffset, rlength, colunmName, coffset, clength, columnValue, voffset, vlength));
        return this.filterAllRemaining();
    }
}

