/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import agilejson.TOJSON;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HbaseMapWritable;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.IRestSerializer;
import org.apache.hadoop.hbase.rest.serializer.ISerializable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Cell
implements Writable,
Iterable<Map.Entry<Long, byte[]>>,
ISerializable {
    protected final SortedMap<Long, byte[]> valueMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

        @Override
        public int compare(Long l1, Long l2) {
            return l2.compareTo(l1);
        }
    });

    public Cell() {
    }

    public Cell(String value, long timestamp) {
        this(Bytes.toBytes(value), timestamp);
    }

    public Cell(byte[] value, long timestamp) {
        this.valueMap.put(timestamp, value);
    }

    public Cell(ByteBuffer bb, long timestamp) {
        this.valueMap.put(timestamp, Bytes.toBytes(bb));
    }

    public Cell(String[] vals, long[] ts) {
        this(Bytes.toByteArrays(vals), ts);
    }

    public Cell(byte[][] vals, long[] ts) {
        if (vals.length != ts.length) {
            throw new IllegalArgumentException("number of values must be the same as the number of timestamps");
        }
        for (int i = 0; i < vals.length; ++i) {
            this.valueMap.put(ts[i], vals[i]);
        }
    }

    @TOJSON(base64=true)
    public byte[] getValue() {
        return (byte[])this.valueMap.get(this.valueMap.firstKey());
    }

    @TOJSON
    public long getTimestamp() {
        return this.valueMap.firstKey();
    }

    public int getNumValues() {
        return this.valueMap.size();
    }

    public void add(byte[] val, long ts) {
        if (!this.valueMap.containsKey(ts)) {
            this.valueMap.put(ts, val);
        }
    }

    public String toString() {
        if (this.valueMap.size() == 1) {
            return "timestamp=" + this.getTimestamp() + ", value=" + Bytes.toString(this.getValue());
        }
        StringBuilder s = new StringBuilder("{ ");
        int i = 0;
        for (Map.Entry<Long, byte[]> entry : this.valueMap.entrySet()) {
            if (i > 0) {
                s.append(", ");
            }
            s.append("[timestamp=");
            s.append(entry.getKey());
            s.append(", value=");
            s.append(Bytes.toString(entry.getValue()));
            s.append("]");
            ++i;
        }
        s.append(" }");
        return s.toString();
    }

    public void readFields(DataInput in) throws IOException {
        int nvalues = in.readInt();
        for (int i = 0; i < nvalues; ++i) {
            long timestamp = in.readLong();
            byte[] value = Bytes.readByteArray(in);
            this.valueMap.put(timestamp, value);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.valueMap.size());
        for (Map.Entry<Long, byte[]> entry : this.valueMap.entrySet()) {
            out.writeLong(entry.getKey());
            Bytes.writeByteArray(out, entry.getValue());
        }
    }

    @Override
    public Iterator<Map.Entry<Long, byte[]>> iterator() {
        return new CellIterator();
    }

    public static HbaseMapWritable<byte[], Cell> createCells(List<KeyValue> results) {
        HbaseMapWritable<byte[], Cell> cells = new HbaseMapWritable<byte[], Cell>();
        ListIterator<KeyValue> i = results.listIterator(results.size());
        while (i.hasPrevious()) {
            KeyValue kv = i.previous();
            byte[] column = kv.getColumn();
            Cell c = cells.get(column);
            if (c == null) {
                c = new Cell(kv.getValue(), kv.getTimestamp());
                cells.put(column, c);
                continue;
            }
            c.add(kv.getValue(), kv.getTimestamp());
        }
        return cells;
    }

    public static Cell[] createSingleCellArray(List<KeyValue> results) {
        if (results == null) {
            return null;
        }
        int index = 0;
        Cell[] cells = new Cell[results.size()];
        for (KeyValue kv : results) {
            cells[index++] = new Cell(kv.getValue(), kv.getTimestamp());
        }
        return cells;
    }

    @Override
    public void restSerialize(IRestSerializer serializer) throws HBaseRestException {
        serializer.serializeCell(this);
    }

    private class CellIterator
    implements Iterator<Map.Entry<Long, byte[]>> {
        private Iterator<Map.Entry<Long, byte[]>> it;

        CellIterator() {
            this.it = Cell.this.valueMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<Long, byte[]> next() {
            return this.it.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

