/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class ImmutableBytesWritable
implements WritableComparable<ImmutableBytesWritable> {
    private byte[] bytes;
    private int offset;
    private int length;

    public ImmutableBytesWritable() {
    }

    public ImmutableBytesWritable(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ImmutableBytesWritable(ImmutableBytesWritable ibw) {
        this(ibw.get(), 0, ibw.getSize());
    }

    public ImmutableBytesWritable(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] get() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.bytes;
    }

    public void set(byte[] b) {
        this.set(b, 0, b.length);
    }

    public void set(byte[] b, int offset, int length) {
        this.bytes = b;
        this.offset = offset;
        this.length = length;
    }

    public int getSize() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getLength() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.bytes = new byte[this.length];
        in.readFully(this.bytes, 0, this.length);
        this.offset = 0;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        return WritableComparator.hashBytes((byte[])this.bytes, (int)this.length);
    }

    public int compareTo(ImmutableBytesWritable right_obj) {
        return this.compareTo(right_obj.get());
    }

    public int compareTo(byte[] that) {
        int diff = this.length - that.length;
        return diff != 0 ? diff : WritableComparator.compareBytes((byte[])this.bytes, (int)0, (int)this.length, (byte[])that, (int)0, (int)that.length);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof byte[]) {
            return this.compareTo((byte[])right_obj) == 0;
        }
        if (right_obj instanceof ImmutableBytesWritable) {
            return this.compareTo((ImmutableBytesWritable)right_obj) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3 * this.bytes.length);
        for (int idx = 0; idx < this.bytes.length; ++idx) {
            String num;
            if (idx != 0) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    public static byte[][] toArray(List<byte[]> array) {
        byte[][] results = new byte[array.size()][];
        for (int i = 0; i < array.size(); ++i) {
            results[i] = array.get(i);
        }
        return results;
    }

    static {
        WritableComparator.define(ImmutableBytesWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BytesWritable.Comparator comparator = new BytesWritable.Comparator();

        public Comparator() {
            super(ImmutableBytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return this.comparator.compare(b1, s1, l1, b2, s2, l2);
        }
    }
}

