/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IndexConfiguration
extends Configuration {
    private static final Log LOG = LogFactory.getLog(IndexConfiguration.class);
    static final String HBASE_COLUMN_NAME = "hbase.column.name";
    static final String HBASE_COLUMN_STORE = "hbase.column.store";
    static final String HBASE_COLUMN_INDEX = "hbase.column.index";
    static final String HBASE_COLUMN_TOKENIZE = "hbase.column.tokenize";
    static final String HBASE_COLUMN_BOOST = "hbase.column.boost";
    static final String HBASE_COLUMN_OMIT_NORMS = "hbase.column.omit.norms";
    static final String HBASE_INDEX_ROWKEY_NAME = "hbase.index.rowkey.name";
    static final String HBASE_INDEX_ANALYZER_NAME = "hbase.index.analyzer.name";
    static final String HBASE_INDEX_MAX_BUFFERED_DOCS = "hbase.index.max.buffered.docs";
    static final String HBASE_INDEX_MAX_BUFFERED_DELS = "hbase.index.max.buffered.dels";
    static final String HBASE_INDEX_MAX_FIELD_LENGTH = "hbase.index.max.field.length";
    static final String HBASE_INDEX_MAX_MERGE_DOCS = "hbase.index.max.merge.docs";
    static final String HBASE_INDEX_MERGE_FACTOR = "hbase.index.merge.factor";
    static final String HBASE_INDEX_SIMILARITY_NAME = "hbase.index.similarity.name";
    static final String HBASE_INDEX_USE_COMPOUND_FILE = "hbase.index.use.compound.file";
    static final String HBASE_INDEX_OPTIMIZE = "hbase.index.optimize";
    private Map<String, ColumnConf> columnMap = new ConcurrentHashMap<String, ColumnConf>();

    public Iterator<String> columnNameIterator() {
        return this.columnMap.keySet().iterator();
    }

    public boolean isIndex(String columnName) {
        return this.getColumn(columnName).getBoolean(HBASE_COLUMN_INDEX, true);
    }

    public void setIndex(String columnName, boolean index) {
        this.getColumn(columnName).setBoolean(HBASE_COLUMN_INDEX, index);
    }

    public boolean isStore(String columnName) {
        return this.getColumn(columnName).getBoolean(HBASE_COLUMN_STORE, false);
    }

    public void setStore(String columnName, boolean store) {
        this.getColumn(columnName).setBoolean(HBASE_COLUMN_STORE, store);
    }

    public boolean isTokenize(String columnName) {
        return this.getColumn(columnName).getBoolean(HBASE_COLUMN_TOKENIZE, true);
    }

    public void setTokenize(String columnName, boolean tokenize) {
        this.getColumn(columnName).setBoolean(HBASE_COLUMN_TOKENIZE, tokenize);
    }

    public float getBoost(String columnName) {
        return this.getColumn(columnName).getFloat(HBASE_COLUMN_BOOST, 1.0f);
    }

    public void setBoost(String columnName, float boost) {
        this.getColumn(columnName).setFloat(HBASE_COLUMN_BOOST, boost);
    }

    public boolean isOmitNorms(String columnName) {
        return this.getColumn(columnName).getBoolean(HBASE_COLUMN_OMIT_NORMS, true);
    }

    public void setOmitNorms(String columnName, boolean omitNorms) {
        this.getColumn(columnName).setBoolean(HBASE_COLUMN_OMIT_NORMS, omitNorms);
    }

    private ColumnConf getColumn(String columnName) {
        ColumnConf column = this.columnMap.get(columnName);
        if (column == null) {
            column = new ColumnConf();
            this.columnMap.put(columnName, column);
        }
        return column;
    }

    public String getAnalyzerName() {
        return this.get(HBASE_INDEX_ANALYZER_NAME, "org.apache.lucene.analysis.standard.StandardAnalyzer");
    }

    public void setAnalyzerName(String analyzerName) {
        this.set(HBASE_INDEX_ANALYZER_NAME, analyzerName);
    }

    public int getMaxBufferedDeleteTerms() {
        return this.getInt(HBASE_INDEX_MAX_BUFFERED_DELS, 1000);
    }

    public void setMaxBufferedDeleteTerms(int maxBufferedDeleteTerms) {
        this.setInt(HBASE_INDEX_MAX_BUFFERED_DELS, maxBufferedDeleteTerms);
    }

    public int getMaxBufferedDocs() {
        return this.getInt(HBASE_INDEX_MAX_BUFFERED_DOCS, 10);
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.setInt(HBASE_INDEX_MAX_BUFFERED_DOCS, maxBufferedDocs);
    }

    public int getMaxFieldLength() {
        return this.getInt(HBASE_INDEX_MAX_FIELD_LENGTH, Integer.MAX_VALUE);
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.setInt(HBASE_INDEX_MAX_FIELD_LENGTH, maxFieldLength);
    }

    public int getMaxMergeDocs() {
        return this.getInt(HBASE_INDEX_MAX_MERGE_DOCS, Integer.MAX_VALUE);
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.setInt(HBASE_INDEX_MAX_MERGE_DOCS, maxMergeDocs);
    }

    public int getMergeFactor() {
        return this.getInt(HBASE_INDEX_MERGE_FACTOR, 10);
    }

    public void setMergeFactor(int mergeFactor) {
        this.setInt(HBASE_INDEX_MERGE_FACTOR, mergeFactor);
    }

    public String getRowkeyName() {
        return this.get(HBASE_INDEX_ROWKEY_NAME, "ROWKEY");
    }

    public void setRowkeyName(String rowkeyName) {
        this.set(HBASE_INDEX_ROWKEY_NAME, rowkeyName);
    }

    public String getSimilarityName() {
        return this.get(HBASE_INDEX_SIMILARITY_NAME, null);
    }

    public void setSimilarityName(String similarityName) {
        this.set(HBASE_INDEX_SIMILARITY_NAME, similarityName);
    }

    public boolean isUseCompoundFile() {
        return this.getBoolean(HBASE_INDEX_USE_COMPOUND_FILE, false);
    }

    public void setUseCompoundFile(boolean useCompoundFile) {
        this.setBoolean(HBASE_INDEX_USE_COMPOUND_FILE, useCompoundFile);
    }

    public boolean doOptimize() {
        return this.getBoolean(HBASE_INDEX_OPTIMIZE, true);
    }

    public void setDoOptimize(boolean doOptimize) {
        this.setBoolean(HBASE_INDEX_OPTIMIZE, doOptimize);
    }

    public void addFromXML(String content) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(content.getBytes()));
            Element root = doc.getDocumentElement();
            if (!"configuration".equals(root.getTagName())) {
                LOG.fatal((Object)"bad conf file: top-level element not <configuration>");
            }
            NodeList props = root.getChildNodes();
            for (int i = 0; i < props.getLength(); ++i) {
                Node propNode = props.item(i);
                if (!(propNode instanceof Element)) continue;
                Element prop = (Element)propNode;
                if ("property".equals(prop.getTagName())) {
                    this.propertyFromXML(prop, null);
                    continue;
                }
                if ("column".equals(prop.getTagName())) {
                    this.columnConfFromXML(prop);
                    continue;
                }
                LOG.warn((Object)"bad conf content: element neither <property> nor <column>");
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)("error parsing conf content: " + e));
            throw new RuntimeException(e);
        }
    }

    private void propertyFromXML(Element prop, Properties properties) {
        NodeList fields = prop.getChildNodes();
        String attr = null;
        String value = null;
        for (int j = 0; j < fields.getLength(); ++j) {
            Node fieldNode = fields.item(j);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            if ("name".equals(field.getTagName())) {
                attr = ((Text)field.getFirstChild()).getData();
            }
            if (!"value".equals(field.getTagName()) || !field.hasChildNodes()) continue;
            value = ((Text)field.getFirstChild()).getData();
        }
        if (attr != null && value != null) {
            if (properties == null) {
                this.set(attr, value);
            } else {
                properties.setProperty(attr, value);
            }
        }
    }

    private void columnConfFromXML(Element column) {
        ColumnConf columnConf = new ColumnConf();
        NodeList props = column.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node propNode = props.item(i);
            if (!(propNode instanceof Element)) continue;
            Element prop = (Element)propNode;
            if ("property".equals(prop.getTagName())) {
                this.propertyFromXML(prop, columnConf);
                continue;
            }
            LOG.warn((Object)"bad conf content: element not <property>");
        }
        if (columnConf.getProperty(HBASE_COLUMN_NAME) != null) {
            this.columnMap.put(columnConf.getProperty(HBASE_COLUMN_NAME), columnConf);
        } else {
            LOG.warn((Object)"bad column conf: name not specified");
        }
    }

    public void write(OutputStream out) {
        try {
            Document doc = this.writeDocument();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Document writeDocument() {
        Iterator iter = this.iterator();
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            conf.appendChild(doc.createTextNode("\n"));
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.writeProperty(doc, conf, name, value);
            }
            Iterator<String> columnIter = this.columnNameIterator();
            while (columnIter.hasNext()) {
                this.writeColumn(doc, conf, columnIter.next());
            }
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProperty(Document doc, Element parent, String name, String value) {
        Element propNode = doc.createElement("property");
        parent.appendChild(propNode);
        Element nameNode = doc.createElement("name");
        nameNode.appendChild(doc.createTextNode(name));
        propNode.appendChild(nameNode);
        Element valueNode = doc.createElement("value");
        valueNode.appendChild(doc.createTextNode(value));
        propNode.appendChild(valueNode);
        parent.appendChild(doc.createTextNode("\n"));
    }

    private void writeColumn(Document doc, Element parent, String columnName) {
        Element column = doc.createElement("column");
        parent.appendChild(column);
        column.appendChild(doc.createTextNode("\n"));
        ColumnConf columnConf = this.getColumn(columnName);
        for (Map.Entry<Object, Object> entry : columnConf.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            this.writeProperty(doc, column, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            Document doc = this.writeDocument();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static class ColumnConf
    extends Properties {
        private static final long serialVersionUID = 7419012290580607821L;

        boolean getBoolean(String name, boolean defaultValue) {
            String valueString = this.getProperty(name);
            if ("true".equals(valueString)) {
                return true;
            }
            if ("false".equals(valueString)) {
                return false;
            }
            return defaultValue;
        }

        void setBoolean(String name, boolean value) {
            this.setProperty(name, Boolean.toString(value));
        }

        float getFloat(String name, float defaultValue) {
            String valueString = this.getProperty(name);
            if (valueString == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(valueString);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        void setFloat(String name, float value) {
            this.setProperty(name, Float.toString(value));
        }
    }
}

