/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RetryableMetaOperation;
import org.apache.hadoop.hbase.util.Bytes;

abstract class TableOperation
implements HConstants {
    private final Set<MetaRegion> metaRegions;
    protected final byte[] tableName;
    protected final Set<HRegionInfo> unservedRegions = new TreeSet<HRegionInfo>();
    protected HMaster master;

    protected TableOperation(HMaster master, byte[] tableName) throws IOException {
        this.master = master;
        if (!this.master.isMasterRunning()) {
            throw new MasterNotRunningException();
        }
        this.tableName = tableName;
        if (!Bytes.equals(HConstants.META_TABLE_NAME, this.tableName) && master.regionManager.metaScannerThread.waitForMetaRegionsOrClose()) {
            throw new MasterNotRunningException();
        }
        this.metaRegions = master.regionManager.getMetaRegionsForTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process() throws IOException {
        Object object = this.master.regionManager.metaScannerThread.scannerLock;
        synchronized (object) {
            for (MetaRegion m : this.metaRegions) {
                new ProcessTableOperation(m, this.master).doWithRetries();
            }
        }
    }

    protected boolean isBeingServed(String serverName) {
        boolean result = false;
        if (serverName != null && serverName.length() > 0) {
            HServerInfo s = this.master.serverManager.getServerInfo(serverName);
            result = s != null;
        }
        return result;
    }

    protected boolean isEnabled(HRegionInfo info) {
        return !info.isOffline();
    }

    protected abstract void processScanItem(String var1, HRegionInfo var2) throws IOException;

    protected abstract void postProcessMeta(MetaRegion var1, HRegionInterface var2) throws IOException;

    private class ProcessTableOperation
    extends RetryableMetaOperation<Boolean> {
        ProcessTableOperation(MetaRegion m, HMaster master) {
            super(m, master);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws IOException {
            boolean tableExists = false;
            byte[] tableNameMetaStart = Bytes.toBytes(Bytes.toString(TableOperation.this.tableName) + ",,");
            Scan scan = new Scan(tableNameMetaStart).addFamily(HConstants.CATALOG_FAMILY);
            long scannerId = this.server.openScanner(this.m.getRegionName(), scan);
            int rows = this.master.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
            scan.setCaching(rows);
            ArrayList<byte[]> emptyRows = new ArrayList<byte[]>();
            try {
                Result values;
                while ((values = this.server.next(scannerId)) != null) {
                    if (values.isEmpty()) {
                        break;
                    }
                    HRegionInfo info = this.master.getHRegionInfo(values.getRow(), values);
                    if (info == null) {
                        emptyRows.add(values.getRow());
                        this.LOG.error((Object)(Bytes.toString(HConstants.CATALOG_FAMILY) + ":" + Bytes.toString(HConstants.REGIONINFO_QUALIFIER) + " not found on " + Bytes.toStringBinary(values.getRow())));
                        continue;
                    }
                    String serverAddress = Bytes.toString(values.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
                    long startCode = Bytes.toLong(values.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
                    String serverName = null;
                    if (serverAddress != null && serverAddress.length() > 0) {
                        serverName = HServerInfo.getServerName(serverAddress, startCode);
                    }
                    if (Bytes.compareTo(info.getTableDesc().getName(), TableOperation.this.tableName) > 0) {
                        break;
                    }
                    tableExists = true;
                    if (!TableOperation.this.isBeingServed(serverName) || !TableOperation.this.isEnabled(info)) {
                        TableOperation.this.unservedRegions.add(info);
                    }
                    TableOperation.this.processScanItem(serverName, info);
                }
            }
            finally {
                if (scannerId != -1L) {
                    try {
                        this.server.close(scannerId);
                    }
                    catch (IOException e) {
                        e = RemoteExceptionHandler.checkIOException(e);
                        this.LOG.error((Object)"closing scanner", (Throwable)e);
                    }
                }
                scannerId = -1L;
            }
            if (emptyRows.size() > 0) {
                this.LOG.warn((Object)("Found " + emptyRows.size() + " rows with empty HRegionInfo while scanning meta region " + Bytes.toString(this.m.getRegionName())));
                this.master.deleteEmptyMetaRows(this.server, this.m.getRegionName(), emptyRows);
            }
            if (!tableExists) {
                throw new TableNotFoundException(Bytes.toString(TableOperation.this.tableName));
            }
            TableOperation.this.postProcessMeta(this.m, this.server);
            TableOperation.this.unservedRegions.clear();
            return Boolean.TRUE;
        }
    }
}

