/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

class CompactSplitThread
extends Thread
implements HConstants {
    static final Log LOG = LogFactory.getLog(CompactSplitThread.class);
    private HTable root = null;
    private HTable meta = null;
    private final long frequency;
    private final ReentrantLock lock = new ReentrantLock();
    private final HRegionServer server;
    private final HBaseConfiguration conf;
    private final BlockingQueue<HRegion> compactionQueue = new LinkedBlockingQueue<HRegion>();
    private final HashSet<HRegion> regionsInQueue = new HashSet();

    public CompactSplitThread(HRegionServer server) {
        this.server = server;
        this.conf = server.conf;
        this.frequency = this.conf.getLong("hbase.regionserver.thread.splitcompactcheckfrequency", 20000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.server.isStopRequested() && this.server.isInSafeMode()) {
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException ex) {}
        }
        while (!this.server.isStopRequested()) {
            HRegion r = null;
            try {
                r = this.compactionQueue.poll(this.frequency, TimeUnit.MILLISECONDS);
                if (r == null || this.server.isStopRequested()) continue;
                HashSet<HRegion> hashSet = this.regionsInQueue;
                synchronized (hashSet) {
                    this.regionsInQueue.remove(r);
                }
                this.lock.lock();
                try {
                    byte[] midKey = r.compactStores();
                    if (midKey == null || this.server.isStopRequested()) continue;
                    this.split(r, midKey);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ex) {
            }
            catch (IOException ex) {
                LOG.error((Object)("Compaction/Split failed" + (r != null ? " for region " + r.getRegionNameAsString() : "")), (Throwable)RemoteExceptionHandler.checkIOException(ex));
                if (this.server.checkFileSystem()) continue;
                break;
            }
            catch (Exception ex) {
                LOG.error((Object)("Compaction failed" + (r != null ? " for region " + r.getRegionNameAsString() : "")), (Throwable)ex);
                if (this.server.checkFileSystem()) continue;
                break;
            }
        }
        this.regionsInQueue.clear();
        this.compactionQueue.clear();
        LOG.info((Object)(this.getName() + " exiting"));
    }

    public synchronized void compactionRequested(HRegion r, String why) {
        this.compactionRequested(r, false, why);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compactionRequested(HRegion r, boolean force, String why) {
        if (this.server.stopRequested.get()) {
            return;
        }
        r.setForceMajorCompaction(force);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compaction " + (force ? "(major) " : "") + "requested for region " + r.getRegionNameAsString() + "/" + r.getRegionInfo().getEncodedName() + (why != null && !why.isEmpty() ? " because: " + why : "")));
        }
        HashSet<HRegion> hashSet = this.regionsInQueue;
        synchronized (hashSet) {
            if (!this.regionsInQueue.contains(r)) {
                this.compactionQueue.add(r);
                this.regionsInQueue.add(r);
            }
        }
    }

    private void split(HRegion region, byte[] midKey) throws IOException {
        HRegionInfo oldRegionInfo = region.getRegionInfo();
        long startTime = System.currentTimeMillis();
        HRegion[] newRegions = region.splitRegion(midKey);
        if (newRegions == null) {
            return;
        }
        HTable t = null;
        if (region.getRegionInfo().isMetaTable()) {
            if (this.root == null) {
                this.root = new HTable(this.conf, ROOT_TABLE_NAME);
            }
            t = this.root;
        } else {
            if (this.meta == null) {
                this.meta = new HTable(this.conf, META_TABLE_NAME);
            }
            t = this.meta;
        }
        oldRegionInfo.setOffline(true);
        oldRegionInfo.setSplit(true);
        this.server.removeFromOnlineRegions(oldRegionInfo);
        Put put = new Put(oldRegionInfo.getRegionName());
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)oldRegionInfo));
        put.add(CATALOG_FAMILY, SPLITA_QUALIFIER, Writables.getBytes((Writable)newRegions[0].getRegionInfo()));
        put.add(CATALOG_FAMILY, SPLITB_QUALIFIER, Writables.getBytes((Writable)newRegions[1].getRegionInfo()));
        t.put(put);
        for (int i = 0; i < newRegions.length; ++i) {
            put = new Put(newRegions[i].getRegionName());
            put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)newRegions[i].getRegionInfo()));
            t.put(put);
        }
        this.server.reportSplit(oldRegionInfo, newRegions[0].getRegionInfo(), newRegions[1].getRegionInfo());
        LOG.info((Object)("region split, META updated, and report to master all successful. Old region=" + oldRegionInfo.toString() + ", new regions: " + newRegions[0].toString() + ", " + newRegions[1].toString() + ". Split took " + StringUtils.formatTimeDiff((long)System.currentTimeMillis(), (long)startTime)));
    }

    void interruptIfNecessary() {
        if (this.lock.tryLock()) {
            this.interrupt();
        }
    }

    public int getCompactionQueueSize() {
        return this.compactionQueue.size();
    }
}

