/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

public class DeleteCompare {
    public static DeleteCode deleteCompare(KeyValue mem, byte[] deleteBuffer, int deleteRowOffset, short deleteRowLength, int deleteQualifierOffset, int deleteQualifierLength, int deleteTimeOffset, byte deleteType, KeyValue.KeyComparator comparator) {
        short memRowLen;
        int res;
        byte[] memBuffer = mem.getBuffer();
        int memOffset = mem.getOffset();
        int memKeyLen = Bytes.toInt(memBuffer, memOffset);
        memOffset += 4;
        memOffset += 4;
        if ((res = comparator.compareRows(memBuffer, memOffset += 2, memRowLen = Bytes.toShort(memBuffer, memOffset), deleteBuffer, deleteRowOffset, deleteRowLength)) > 0) {
            return DeleteCode.DONE;
        }
        if (res < 0) {
            return DeleteCode.SKIP;
        }
        byte memFamLen = memBuffer[memOffset += memRowLen];
        int memQualifierLen = memKeyLen - memRowLen - memFamLen - 2 - 1 - 8 - 1;
        int tsOffset = (memOffset += 1 + memFamLen) + memQualifierLen;
        int timeRes = Bytes.compareTo(memBuffer, tsOffset, 8, deleteBuffer, deleteTimeOffset, 8);
        if (deleteType == KeyValue.Type.DeleteFamily.getCode()) {
            if (timeRes <= 0) {
                return DeleteCode.DELETE;
            }
            return DeleteCode.SKIP;
        }
        res = Bytes.compareTo(memBuffer, memOffset, memQualifierLen, deleteBuffer, deleteQualifierOffset, deleteQualifierLength);
        if (res < 0) {
            return DeleteCode.SKIP;
        }
        if (res > 0) {
            return DeleteCode.DONE;
        }
        if (timeRes == 0) {
            return DeleteCode.DELETE;
        }
        if (timeRes < 0) {
            if (deleteType == KeyValue.Type.DeleteColumn.getCode()) {
                return DeleteCode.DELETE;
            }
            return DeleteCode.DONE;
        }
        return DeleteCode.SKIP;
    }

    static enum DeleteCode {
        SKIP,
        DELETE,
        DONE;

    }
}

