/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.descriptors.ScannerIdentifier;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;

public class ScannerModel
extends AbstractModel {
    protected static final ScannerMaster scannerMaster = new ScannerMaster();

    public ScannerModel(HBaseConfiguration config, HBaseAdmin admin) {
        super.initialize(config, admin);
    }

    public Result[] scannerGet(Integer id, Long numRows) throws HBaseRestException {
        try {
            ArrayList<Result> a = new ArrayList<Result>();
            ResultScanner s = scannerMaster.getScanner(id);
            if (s == null) {
                throw new HBaseRestException("ScannerId: " + id + " is unavailable.  Please create a new scanner");
            }
            int i = 0;
            while ((long)i < numRows) {
                Result r = s.next();
                if (r == null) {
                    scannerMaster.scannerClose(id);
                    break;
                }
                a.add(r);
                ++i;
            }
            return a.toArray(new Result[0]);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public Result[] scannerGet(Integer id) throws HBaseRestException {
        try {
            Result r;
            ArrayList<Result> a = new ArrayList<Result>();
            ResultScanner s = scannerMaster.getScanner(id);
            while ((r = s.next()) != null) {
                a.add(r);
            }
            scannerMaster.scannerClose(id);
            return a.toArray(new Result[0]);
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public boolean scannerClose(Integer id) throws HBaseRestException {
        ResultScanner s = scannerMaster.removeScanner(id);
        if (s == null) {
            throw new HBaseRestException("Scanner id: " + id + " does not exist");
        }
        return true;
    }

    public ScannerIdentifier scannerOpen(byte[] tableName) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName));
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, long timestamp) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), timestamp);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[] startRow) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), startRow);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[] startRow, long timestamp) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), startRow, timestamp);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), filter);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, long timestamp, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), timestamp, filter);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[] startRow, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), startRow, filter);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[] startRow, long timestamp, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, this.getColumns(tableName), startRow, timestamp, filter);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, long timestamp) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Scan scan = new Scan();
            scan.addColumns(columns);
            scan.setTimeRange(0L, timestamp);
            return new ScannerIdentifier(scannerMaster.addScanner(table.getScanner(scan)));
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns) throws HBaseRestException {
        return this.scannerOpen(tableName, columns, Long.MAX_VALUE);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, byte[] startRow, long timestamp) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Scan scan = new Scan(startRow);
            scan.addColumns(columns);
            scan.setTimeRange(0L, timestamp);
            return new ScannerIdentifier(scannerMaster.addScanner(table.getScanner(scan)));
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, byte[] startRow) throws HBaseRestException {
        return this.scannerOpen(tableName, columns, startRow, Long.MAX_VALUE);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, long timestamp, RowFilterInterface filter) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Scan scan = new Scan();
            scan.addColumns(columns);
            scan.setTimeRange(0L, timestamp);
            return new ScannerIdentifier(scannerMaster.addScanner(table.getScanner(scan)));
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, columns, Long.MAX_VALUE, filter);
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, byte[] startRow, long timestamp, RowFilterInterface filter) throws HBaseRestException {
        try {
            HTable table = new HTable(this.conf, tableName);
            Scan scan = new Scan(startRow);
            scan.addColumns(columns);
            scan.setTimeRange(0L, timestamp);
            return new ScannerIdentifier(scannerMaster.addScanner(table.getScanner(scan)));
        }
        catch (IOException e) {
            throw new HBaseRestException(e);
        }
    }

    public ScannerIdentifier scannerOpen(byte[] tableName, byte[][] columns, byte[] startRow, RowFilterInterface filter) throws HBaseRestException {
        return this.scannerOpen(tableName, columns, startRow, Long.MAX_VALUE, filter);
    }

    protected static class ScannerMaster {
        protected static final Map<Integer, ResultScanner> scannerMap = new ConcurrentHashMap<Integer, ResultScanner>();
        protected static final AtomicInteger nextScannerId = new AtomicInteger(1);

        protected ScannerMaster() {
        }

        public Integer addScanner(ResultScanner scanner) {
            Integer i = nextScannerId.getAndIncrement();
            scannerMap.put(i, scanner);
            return i;
        }

        public ResultScanner getScanner(Integer id) {
            return scannerMap.get(id);
        }

        public ResultScanner removeScanner(Integer id) {
            return scannerMap.remove(id);
        }

        public void scannerClose(Integer id) {
            ResultScanner s = scannerMap.remove(id);
            s.close();
        }
    }
}

