/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Serializable;
import java.util.Arrays;

public final class Pair<T1, T2>
implements Serializable {
    private static final long serialVersionUID = -3986244606585552569L;
    protected T1 first = null;
    protected T2 second = null;
    private int hashcode;

    public Pair(T1 a, T2 b) {
        this.first = a;
        this.second = b;
        this.hashcode = this.first != null ? Pair.generateHashCode(this.first) : 0;
        this.hashcode = 31 * this.hashcode + (this.second != null ? Pair.generateHashCode(this.second) : 0);
    }

    private static int generateHashCode(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof long[]) {
                return Arrays.hashCode((long[])o);
            }
            if (o instanceof int[]) {
                return Arrays.hashCode((int[])o);
            }
            if (o instanceof short[]) {
                return Arrays.hashCode((short[])o);
            }
            if (o instanceof char[]) {
                return Arrays.hashCode((char[])o);
            }
            if (o instanceof byte[]) {
                return Arrays.hashCode((byte[])o);
            }
            if (o instanceof double[]) {
                return Arrays.hashCode((double[])o);
            }
            if (o instanceof float[]) {
                return Arrays.hashCode((float[])o);
            }
            if (o instanceof boolean[]) {
                return Arrays.hashCode((boolean[])o);
            }
            return Arrays.hashCode((Object[])o);
        }
        return o.hashCode();
    }

    public T1 getFirst() {
        return this.first;
    }

    public T2 getSecond() {
        return this.second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 one, T2 two) {
        return new Pair<T1, T2>(one, two);
    }

    private static boolean equals(Object x, Object y) {
        if (x == null || y == null) {
            return x == y;
        }
        Class<?> clazz = x.getClass();
        if (clazz.isArray() && clazz == y.getClass()) {
            if (x instanceof long[]) {
                return Arrays.equals((long[])x, (long[])y);
            }
            if (x instanceof int[]) {
                return Arrays.equals((int[])x, (int[])y);
            }
            if (x instanceof short[]) {
                return Arrays.equals((short[])x, (short[])y);
            }
            if (x instanceof char[]) {
                return Arrays.equals((char[])x, (char[])y);
            }
            if (x instanceof byte[]) {
                return Arrays.equals((byte[])x, (byte[])y);
            }
            if (x instanceof double[]) {
                return Arrays.equals((double[])x, (double[])y);
            }
            if (x instanceof float[]) {
                return Arrays.equals((float[])x, (float[])y);
            }
            if (x instanceof boolean[]) {
                return Arrays.equals((boolean[])x, (boolean[])y);
            }
            return Arrays.deepEquals((Object[])x, (Object[])y);
        }
        return x.equals(y);
    }

    public boolean equals(Object other) {
        return other instanceof Pair && Pair.equals(this.first, ((Pair)other).first) && Pair.equals(this.second, ((Pair)other).second);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return "{" + this.getFirst() + "," + this.getSecond() + "}";
    }
}

