/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.DDLTask");
    transient HiveConf conf;
    private static final int separator = 9;
    private static final int terminator = 10;
    private static String INTERMEDIATE_ARCHIVED_DIR_SUFFIX;
    private static String INTERMEDIATE_ORIGINAL_DIR_SUFFIX;
    private static String INTERMEDIATE_EXTRACTED_DIR_SUFFIX;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        this.conf = conf;
        INTERMEDIATE_ARCHIVED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ARCHIVED);
        INTERMEDIATE_ORIGINAL_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_ORIGINAL);
        INTERMEDIATE_EXTRACTED_DIR_SUFFIX = HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_INT_EXTRACTED);
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            MsckDesc msckDesc;
            Hive db = Hive.get(this.conf);
            CreateDatabaseDesc createDatabaseDesc = ((DDLWork)this.work).getCreateDatabaseDesc();
            if (null != createDatabaseDesc) {
                return this.createDatabase(db, createDatabaseDesc);
            }
            DropDatabaseDesc dropDatabaseDesc = ((DDLWork)this.work).getDropDatabaseDesc();
            if (dropDatabaseDesc != null) {
                return this.dropDatabase(db, dropDatabaseDesc);
            }
            SwitchDatabaseDesc switchDatabaseDesc = ((DDLWork)this.work).getSwitchDatabaseDesc();
            if (switchDatabaseDesc != null) {
                return this.switchDatabase(db, switchDatabaseDesc);
            }
            CreateTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            CreateTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            DropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                return this.dropTable(db, dropTbl);
            }
            AlterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            CreateViewDesc crtView = ((DDLWork)this.work).getCreateViewDesc();
            if (crtView != null) {
                return this.createView(db, crtView);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartition(db, addPartitionDesc);
            }
            AlterTableSimpleDesc simpleDesc = ((DDLWork)this.work).getAlterTblSimpleDesc();
            if (simpleDesc != null) {
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.TOUCH) {
                    return this.touch(db, simpleDesc);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.ARCHIVE) {
                    return this.archive(db, simpleDesc, driverContext);
                }
                if (simpleDesc.getType() == AlterTableDesc.AlterTableTypes.UNARCHIVE) {
                    return this.unarchive(db, simpleDesc);
                }
            }
            if ((msckDesc = ((DDLWork)this.work).getMsckDesc()) != null) {
                return this.msck(db, msckDesc);
            }
            DescTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            DescFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            ShowDatabasesDesc showDatabases = ((DDLWork)this.work).getShowDatabasesDesc();
            if (showDatabases != null) {
                return this.showDatabases(db, showDatabases);
            }
            ShowTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            ShowTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            ShowFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            ShowPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
        }
        catch (InvalidTableException e) {
            this.console.printError("Table " + e.getTableName() + " does not exist");
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("FAILED: Error in metadata: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        assert (false);
        return 0;
    }

    private int addPartition(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = db.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.ADDPARTITION);
        Partition checkPart = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        if (checkPart != null && addPartitionDesc.getIfNotExists()) {
            return 0;
        }
        if (addPartitionDesc.getLocation() == null) {
            db.createPartition(tbl, addPartitionDesc.getPartSpec());
        } else {
            db.createPartition(tbl, addPartitionDesc.getPartSpec(), new Path(tbl.getPath(), addPartitionDesc.getLocation()));
        }
        Partition part = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        return 0;
    }

    private int touch(Hive db, AlterTableSimpleDesc touchDesc) throws HiveException {
        String dbName = touchDesc.getDbName();
        String tblName = touchDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.TOUCH);
        if (touchDesc.getPartSpec() == null) {
            try {
                db.alterTable(tblName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException("Uable to update table");
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(tbl));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        } else {
            Partition part = db.getPartition(tbl, touchDesc.getPartSpec(), false);
            if (part == null) {
                throw new HiveException("Specified partition does not exist");
            }
            try {
                db.alterPartition(tblName, part);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
            ((DDLWork)this.work).getInputs().add(new ReadEntity(part));
            ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        }
        return 0;
    }

    private boolean isArchived(Partition p) {
        Map<String, String> params = p.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    private void setIsArchived(Partition p, boolean state) {
        Map<String, String> params = p.getParameters();
        if (state) {
            params.put("is_archived", "true");
        } else {
            params.remove("is_archived");
        }
    }

    private String getOriginalLocation(Partition p) {
        Map<String, String> params = p.getParameters();
        return params.get("original_location");
    }

    private void setOriginalLocation(Partition p, String loc) {
        Map<String, String> params = p.getParameters();
        if (loc == null) {
            params.remove("original_location");
        } else {
            params.put("original_location", loc);
        }
    }

    private String getArchiveDirOnly(Path parentDir, String archiveName) {
        URI parentUri = parentDir.toUri();
        Path harDir = new Path(parentUri.getPath(), archiveName);
        return harDir.toString();
    }

    private void setArchived(Partition p, Path parentDir, String dirInArchive, String archiveName) throws URISyntaxException {
        assert (!this.isArchived(p));
        Map<String, String> params = p.getParameters();
        URI parentUri = parentDir.toUri();
        String parentHost = parentUri.getHost();
        String harHost = null;
        harHost = parentHost == null ? "" : parentUri.getScheme() + "-" + parentHost;
        URI harUri = null;
        harUri = dirInArchive.length() == 0 ? new URI("har", parentUri.getUserInfo(), harHost, parentUri.getPort(), this.getArchiveDirOnly(parentDir, archiveName), parentUri.getQuery(), parentUri.getFragment()) : new URI("har", parentUri.getUserInfo(), harHost, parentUri.getPort(), new Path(this.getArchiveDirOnly(parentDir, archiveName), dirInArchive).toUri().getPath(), parentUri.getQuery(), parentUri.getFragment());
        this.setIsArchived(p, true);
        this.setOriginalLocation(p, parentDir.toString());
        p.setLocation(harUri.toString());
    }

    private void setUnArchived(Partition p) {
        assert (this.isArchived(p));
        String parentDir = this.getOriginalLocation(p);
        this.setIsArchived(p, false);
        this.setOriginalLocation(p, null);
        assert (parentDir != null);
        p.setLocation(parentDir);
    }

    private boolean pathExists(FileSystem fs, Path p) throws HiveException {
        try {
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void moveDir(FileSystem fs, Path from, Path to) throws HiveException {
        try {
            if (!fs.rename(from, to)) {
                throw new HiveException("Moving " + from + " to " + to + " failed!");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void deleteDir(Path dir) throws HiveException {
        try {
            Warehouse wh = new Warehouse((Configuration)this.conf);
            wh.deleteDir(dir, true);
        }
        catch (MetaException e) {
            throw new HiveException(e);
        }
    }

    private int archive(Hive db, AlterTableSimpleDesc simpleDesc, DriverContext driverContext) throws HiveException {
        String dbName = simpleDesc.getDbName();
        String tblName = simpleDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.ARCHIVE);
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        Partition p = db.getPartition(tbl, partSpec, false);
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("ARCHIVE can only be performed on managed tables");
        }
        if (p == null) {
            throw new HiveException("Specified partition does not exist");
        }
        if (this.isArchived(p)) {
            Path originalDir = new Path(this.getOriginalLocation(p));
            Path leftOverIntermediateOriginal = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
            try {
                if (this.pathExists(leftOverIntermediateOriginal.getFileSystem((Configuration)this.conf), leftOverIntermediateOriginal)) {
                    this.console.printInfo("Deleting " + leftOverIntermediateOriginal + " left over from a previous archiving operation");
                    this.deleteDir(leftOverIntermediateOriginal);
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            throw new HiveException("Specified partition is already archived");
        }
        Path originalDir = p.getPartitionPath();
        Path intermediateArchivedDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateOriginalDir = new Path(originalDir.getParent(), originalDir.getName() + INTERMEDIATE_ORIGINAL_DIR_SUFFIX);
        String archiveName = "data.har";
        FileSystem fs = null;
        try {
            fs = originalDir.getFileSystem((Configuration)this.conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (!this.pathExists(fs, intermediateArchivedDir) && !this.pathExists(fs, intermediateOriginalDir)) {
            Path tmpDir = new Path(driverContext.getCtx().getMRScratchDir(), "partlevel");
            this.console.printInfo("Creating " + archiveName + " for " + originalDir.toString());
            this.console.printInfo("in " + tmpDir);
            this.console.printInfo("Please wait... (this may take a while)");
            HadoopShims shim = ShimLoader.getHadoopShims();
            int ret = 0;
            try {
                ret = shim.createHadoopArchive(this.conf, originalDir, tmpDir, archiveName);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
            if (ret != 0) {
                throw new HiveException("Error while creating HAR");
            }
            try {
                this.console.printInfo("Moving " + tmpDir + " to " + intermediateArchivedDir);
                if (this.pathExists(fs, intermediateArchivedDir)) {
                    throw new HiveException("The intermediate archive directory already exists.");
                }
                fs.rename(tmpDir, intermediateArchivedDir);
            }
            catch (IOException e) {
                throw new HiveException("Error while moving tmp directory");
            }
        }
        if (this.pathExists(fs, intermediateArchivedDir)) {
            this.console.printInfo("Intermediate archive directory " + intermediateArchivedDir + " already exists. Assuming it contains an archived version of the partition");
        }
        if (!this.pathExists(fs, intermediateOriginalDir)) {
            this.console.printInfo("Moving " + originalDir + " to " + intermediateOriginalDir);
            this.moveDir(fs, originalDir, intermediateOriginalDir);
        } else {
            this.console.printInfo(intermediateOriginalDir + " already exists. " + "Assuming it contains the original files in the partition");
        }
        if (!this.pathExists(fs, originalDir)) {
            this.console.printInfo("Moving " + intermediateArchivedDir + " to " + originalDir);
            this.moveDir(fs, intermediateArchivedDir, originalDir);
        } else {
            this.console.printInfo(originalDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        try {
            boolean parentSettable = this.conf.getBoolVar(HiveConf.ConfVars.HIVEHARPARENTDIRSETTABLE);
            String dirInArchive = "";
            if (!parentSettable && (dirInArchive = originalDir.toUri().getPath()).length() > 1 && dirInArchive.charAt(0) == '/') {
                dirInArchive = dirInArchive.substring(1);
            }
            this.setArchived(p, originalDir, dirInArchive, archiveName);
            db.alterPartition(tblName, p);
        }
        catch (Exception e) {
            throw new HiveException("Unable to change the partition info for HAR", e);
        }
        this.deleteDir(intermediateOriginalDir);
        return 0;
    }

    private int unarchive(Hive db, AlterTableSimpleDesc simpleDesc) throws HiveException {
        String dbName = simpleDesc.getDbName();
        String tblName = simpleDesc.getTableName();
        Table tbl = db.getTable(dbName, tblName);
        this.validateAlterTableType(tbl, AlterTableDesc.AlterTableTypes.UNARCHIVE);
        if (simpleDesc.getPartSpec() == null) {
            throw new HiveException("ARCHIVE is for partitions only");
        }
        LinkedHashMap<String, String> partSpec = simpleDesc.getPartSpec();
        Partition p = db.getPartition(tbl, partSpec, false);
        if (tbl.getTableType() != TableType.MANAGED_TABLE) {
            throw new HiveException("UNARCHIVE can only be performed on managed tables");
        }
        if (p == null) {
            throw new HiveException("Specified partition does not exist");
        }
        if (!this.isArchived(p)) {
            Path location = new Path(p.getLocation());
            Path leftOverArchiveDir = new Path(location.getParent(), location.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
            try {
                if (this.pathExists(location.getFileSystem((Configuration)this.conf), leftOverArchiveDir)) {
                    this.console.printInfo("Deleting " + leftOverArchiveDir + " left over " + "from a previous unarchiving operation");
                    this.deleteDir(leftOverArchiveDir);
                }
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            throw new HiveException("Specified partition is not archived");
        }
        Path originalLocation = new Path(this.getOriginalLocation(p));
        Path sourceDir = new Path(p.getLocation());
        Path intermediateArchiveDir = new Path(originalLocation.getParent(), originalLocation.getName() + INTERMEDIATE_ARCHIVED_DIR_SUFFIX);
        Path intermediateExtractedDir = new Path(originalLocation.getParent(), originalLocation.getName() + INTERMEDIATE_EXTRACTED_DIR_SUFFIX);
        Path tmpDir = new Path(this.driverContext.getCtx().getMRScratchDir());
        FileSystem fs = null;
        try {
            fs = tmpDir.getFileSystem((Configuration)this.conf);
            FileStatus[] filesInTmpDir = fs.listStatus(tmpDir);
            if (filesInTmpDir.length != 0) {
                for (FileStatus file : filesInTmpDir) {
                    this.console.printInfo(file.getPath().toString());
                }
                throw new HiveException("Temporary directory " + tmpDir + " is not empty");
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        if (originalLocation == null) {
            throw new HiveException("Missing archive data in the partition");
        }
        if (!"har".equals(sourceDir.toUri().getScheme())) {
            throw new HiveException("Location should refer to a HAR");
        }
        if (!this.pathExists(fs, intermediateExtractedDir) && !this.pathExists(fs, intermediateArchiveDir)) {
            try {
                String copySource = new Path(sourceDir, "*").toString();
                String copyDest = tmpDir.toString();
                ArrayList<String> args = new ArrayList<String>();
                args.add("-cp");
                args.add(copySource);
                args.add(copyDest);
                this.console.printInfo("Copying " + copySource + " to " + copyDest);
                FsShell fss = new FsShell((Configuration)this.conf);
                int ret = 0;
                try {
                    ret = ToolRunner.run((Tool)fss, (String[])args.toArray(new String[0]));
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
                if (ret != 0) {
                    throw new HiveException("Error while copying files from archive");
                }
                this.console.printInfo("Moving " + tmpDir + " to " + intermediateExtractedDir);
                if (fs.exists(intermediateExtractedDir)) {
                    throw new HiveException("Invalid state: the intermediate extracted directory already exists.");
                }
                fs.rename(tmpDir, intermediateExtractedDir);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        if (!this.pathExists(fs, intermediateArchiveDir)) {
            try {
                this.console.printInfo("Moving " + originalLocation + " to " + intermediateArchiveDir);
                fs.rename(originalLocation, intermediateArchiveDir);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(intermediateArchiveDir + " already exists. " + "Assuming it contains the archived version of the partition");
        }
        if (!this.pathExists(fs, originalLocation)) {
            try {
                this.console.printInfo("Moving " + intermediateExtractedDir + " to " + originalLocation);
                fs.rename(intermediateExtractedDir, originalLocation);
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
        } else {
            this.console.printInfo(originalLocation + " already exists. " + "Assuming it contains the extracted files in the partition");
        }
        this.setUnArchived(p);
        try {
            db.alterPartition(tblName, p);
        }
        catch (InvalidOperationException e) {
            throw new HiveException(e);
        }
        this.deleteDir(intermediateArchiveDir);
        return 0;
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes alterType) throws HiveException {
        if (tbl.isView()) {
            switch (alterType) {
                case ADDPROPS: {
                    break;
                }
                default: {
                    throw new HiveException("Cannot use this form of ALTER TABLE on a view");
                }
            }
        }
        if (tbl.isNonNative()) {
            throw new HiveException("Cannot use ALTER TABLE on a non-native table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        CheckResult result = new CheckResult();
        ArrayList<String> repairOutput = new ArrayList<String>();
        try {
            HiveMetaStoreChecker checker = new HiveMetaStoreChecker(db);
            checker.checkMetastore(db.getCurrentDatabase(), msckDesc.getTableName(), msckDesc.getPartSpecs(), result);
            if (!msckDesc.isRepairPartitions()) return 0;
            Table table = db.getTable(msckDesc.getTableName());
            Iterator<CheckResult.PartitionResult> i$ = result.getPartitionsNotInMs().iterator();
            while (i$.hasNext()) {
                CheckResult.PartitionResult part = i$.next();
                try {
                    db.createPartition(table, Warehouse.makeSpecFromName((String)part.getPartitionName()));
                    repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Repair error, could not add partition to metastore: ", (Throwable)e);
                }
            }
            return 0;
        }
        catch (HiveException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            BufferedWriter resultOut = null;
            try {
                Path resFile = new Path(msckDesc.getResFile());
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to save metacheck output: ", (Throwable)e);
                int fs = 1;
                return fs;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, ShowPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable(tabName);
        if (!tbl.isPartitioned()) {
            this.console.printError("Table " + tabName + " is not a partitioned table");
            return 1;
        }
        parts = showParts.getPartSpec() != null ? db.getPartitionNames(db.getCurrentDatabase(), tbl.getTableName(), showParts.getPartSpec(), (short)-1) : db.getPartitionNames(db.getCurrentDatabase(), tbl.getTableName(), (short)-1);
        try {
            Path resFile = new Path(showParts.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            Iterator<String> iterParts = parts.iterator();
            while (iterParts.hasNext()) {
                outStream.writeBytes(iterParts.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (IOException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showDatabases(Hive db, ShowDatabasesDesc showDatabasesDesc) throws HiveException {
        List<String> databases = null;
        if (showDatabasesDesc.getPattern() != null) {
            LOG.info((Object)("pattern: " + showDatabasesDesc.getPattern()));
            databases = db.getDatabasesByPattern(showDatabasesDesc.getPattern());
        } else {
            databases = db.getAllDatabases();
        }
        LOG.info((Object)("results : " + databases.size()));
        try {
            Path resFile = new Path(showDatabasesDesc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            for (String database : databases) {
                outStream.writeBytes(database);
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show databases: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show databases: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTables(Hive db, ShowTablesDesc showTbls) throws HiveException {
        List<String> tbls = null;
        if (showTbls.getPattern() != null) {
            LOG.info((Object)("pattern: " + showTbls.getPattern()));
            tbls = db.getTablesByPattern(showTbls.getPattern());
            LOG.info((Object)("results : " + tbls.size()));
        } else {
            tbls = db.getAllTables();
        }
        try {
            Path resFile = new Path(showTbls.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            TreeSet<String> sortedTbls = new TreeSet<String>(tbls);
            Iterator iterTbls = sortedTbls.iterator();
            while (iterTbls.hasNext()) {
                outStream.writeBytes((String)iterTbls.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showFunctions(ShowFunctionsDesc showFuncs) throws HiveException {
        Set<String> funcs = null;
        if (showFuncs.getPattern() != null) {
            LOG.info((Object)("pattern: " + showFuncs.getPattern()));
            funcs = FunctionRegistry.getFunctionNames(showFuncs.getPattern());
            LOG.info((Object)("results : " + funcs.size()));
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        try {
            Path resFile = new Path(showFuncs.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            Iterator iterFuncs = sortedFuncs.iterator();
            while (iterFuncs.hasNext()) {
                outStream.writeBytes((String)iterFuncs.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int describeFunction(DescFunctionDesc descFunc) throws HiveException {
        String funcName = descFunc.getName();
        try {
            Path resFile = new Path(descFunc.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            Description desc = null;
            Class<?> funcClass = null;
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            if (functionInfo != null) {
                funcClass = functionInfo.getFunctionClass();
            }
            if (funcClass != null) {
                desc = funcClass.getAnnotation(Description.class);
            }
            if (desc != null) {
                outStream.writeBytes(desc.value().replace("_FUNC_", funcName));
                if (descFunc.isExtended()) {
                    Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                    if (synonyms.size() > 0) {
                        outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, ", "));
                    }
                    if (desc.extended().length() > 0) {
                        outStream.writeBytes("\n" + desc.extended().replace("_FUNC_", funcName));
                    }
                }
            } else if (funcClass != null) {
                outStream.writeBytes("There is no documentation for function '" + funcName + "'");
            } else {
                outStream.writeBytes("Function '" + funcName + "' does not exist.");
            }
            outStream.write(10);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTableStatus(Hive db, ShowTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            if (par == null) {
                throw new HiveException("Partition " + part + " for table " + showTblStatus.getPattern() + " does not exist.");
            }
            tbls.add(tbl);
        } else {
            LOG.info((Object)("pattern: " + showTblStatus.getPattern()));
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info((Object)("results : " + tblStr.size()));
        }
        try {
            Path resFile = new Path(showTblStatus.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            for (Table tbl : tbls) {
                String tableName = tbl.getTableName();
                String tblLoc = null;
                String inputFormattCls = null;
                String outputFormattCls = null;
                if (part != null) {
                    if (par != null) {
                        tblLoc = par.getDataLocation().toString();
                        inputFormattCls = par.getInputFormatClass().getName();
                        outputFormattCls = par.getOutputFormatClass().getName();
                    }
                } else {
                    tblLoc = tbl.getDataLocation().toString();
                    inputFormattCls = tbl.getInputFormatClass().getName();
                    outputFormattCls = tbl.getOutputFormatClass().getName();
                }
                String owner = tbl.getOwner();
                List<FieldSchema> cols = tbl.getCols();
                String ddlCols = MetaStoreUtils.getDDLFromFieldSchema((String)"columns", cols);
                boolean isPartitioned = tbl.isPartitioned();
                String partitionCols = "";
                if (isPartitioned) {
                    partitionCols = MetaStoreUtils.getDDLFromFieldSchema((String)"partition_columns", tbl.getPartCols());
                }
                outStream.writeBytes("tableName:" + tableName);
                outStream.write(10);
                outStream.writeBytes("owner:" + owner);
                outStream.write(10);
                outStream.writeBytes("location:" + tblLoc);
                outStream.write(10);
                outStream.writeBytes("inputformat:" + inputFormattCls);
                outStream.write(10);
                outStream.writeBytes("outputformat:" + outputFormattCls);
                outStream.write(10);
                outStream.writeBytes("columns:" + ddlCols);
                outStream.write(10);
                outStream.writeBytes("partitioned:" + isPartitioned);
                outStream.write(10);
                outStream.writeBytes("partitionColumns:" + partitionCols);
                outStream.write(10);
                Path tablLoc = tbl.getPath();
                ArrayList<Path> locations = new ArrayList<Path>();
                if (isPartitioned) {
                    if (par == null) {
                        for (Partition curPart : db.getPartitions(tbl)) {
                            locations.add(new Path(curPart.getTPartition().getSd().getLocation()));
                        }
                    } else {
                        locations.add(new Path(par.getTPartition().getSd().getLocation()));
                    }
                } else {
                    locations.add(tablLoc);
                }
                this.writeFileSystemStats((DataOutput)outStream, locations, tablLoc, false, 0);
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private int describeTable(Hive db, DescTableDesc descTbl) throws HiveException {
        String colPath;
        String tableName = colPath.substring(0, (colPath = descTbl.getTableName()).indexOf(46) == -1 ? colPath.length() : colPath.indexOf(46));
        Table tbl = db.getTable(db.getCurrentDatabase(), tableName, false);
        Partition part = null;
        try {
            Path resFile = new Path(descTbl.getResFile());
            if (tbl == null) {
                FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                DataOutput outStream = (DataOutput)fs.open(resFile);
                String errMsg = "Table " + tableName + " does not exist";
                outStream.write(errMsg.getBytes("UTF-8"));
                ((FSDataOutputStream)outStream).close();
                return 0;
            }
            if (descTbl.getPartSpec() != null) {
                part = db.getPartition(tbl, descTbl.getPartSpec(), false);
                if (part == null) {
                    FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
                    DataOutput outStream = (DataOutput)fs.open(resFile);
                    String errMsg = "Partition " + descTbl.getPartSpec() + " for table " + tableName + " does not exist";
                    outStream.write(errMsg.getBytes("UTF-8"));
                    ((FSDataOutputStream)outStream).close();
                    return 0;
                }
                tbl = part.getTable();
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        try {
            LOG.info((Object)("DDLTask: got data for " + tbl.getTableName()));
            List<FieldSchema> cols = null;
            if (colPath.equals(tableName)) {
                cols = tbl.getCols();
                if (part != null) {
                    cols = part.getCols();
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, tbl.getDeserializer());
            }
            Path resFile = new Path(descTbl.getResFile());
            FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(resFile);
            for (FieldSchema col : cols) {
                outStream.writeBytes(col.getName());
                outStream.write(9);
                outStream.writeBytes(col.getType());
                outStream.write(9);
                outStream.writeBytes(col.getComment() == null ? "" : col.getComment());
                outStream.write(10);
            }
            if (tableName.equals(colPath)) {
                List<FieldSchema> partCols = tbl.getPartCols();
                for (FieldSchema col : partCols) {
                    outStream.writeBytes(col.getName());
                    outStream.write(9);
                    outStream.writeBytes(col.getType());
                    outStream.write(9);
                    outStream.writeBytes(col.getComment() == null ? "" : col.getComment());
                    outStream.write(10);
                }
                if (descTbl.isExt()) {
                    outStream.write(10);
                    if (part != null) {
                        outStream.writeBytes("Detailed Partition Information");
                        outStream.write(9);
                        outStream.writeBytes(part.getTPartition().toString());
                        outStream.write(9);
                        outStream.write(10);
                    } else {
                        outStream.writeBytes("Detailed Table Information");
                        outStream.write(9);
                        outStream.writeBytes(tbl.getTTable().toString());
                        outStream.write(9);
                        outStream.write(10);
                    }
                }
            }
            LOG.info((Object)("DDLTask: written data for " + tbl.getTableName()));
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return 0;
    }

    private void writeFileSystemStats(DataOutput outStream, List<Path> locations, Path tabLoc, boolean partSpecified, int indent) throws IOException {
        int k;
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        boolean unknown = false;
        FileSystem fs = tabLoc.getFileSystem((Configuration)this.conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tabLoc);
            lastAccessTime = ShimLoader.getHadoopShims().getAccessTime(tmpStatus);
            lastUpdateTime = tmpStatus.getModificationTime();
            if (partSpecified) {
                tmpStatus = fs.getFileStatus(locations.get(0));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot access File System. File System status will be unknown: ", (Throwable)e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(tabLoc);
                    FileStatus[] files = fs.listStatus(loc);
                    long accessTime = ShimLoader.getHadoopShims().getAccessTime(status);
                    long updateTime = status.getModificationTime();
                    if (!status.isDir()) continue;
                    if (accessTime > lastAccessTime) {
                        lastAccessTime = accessTime;
                    }
                    if (updateTime > lastUpdateTime) {
                        lastUpdateTime = updateTime;
                    }
                    for (FileStatus currentStatus : files) {
                        if (currentStatus.isDir()) continue;
                        ++numOfFiles;
                        long fileLen = currentStatus.getLen();
                        totalFileSize += fileLen;
                        if (fileLen > maxFileSize) {
                            maxFileSize = fileLen;
                        }
                        if (fileLen < minFileSize) {
                            minFileSize = fileLen;
                        }
                        accessTime = ShimLoader.getHadoopShims().getAccessTime(currentStatus);
                        updateTime = currentStatus.getModificationTime();
                        if (accessTime > lastAccessTime) {
                            lastAccessTime = accessTime;
                        }
                        if (updateTime <= lastUpdateTime) continue;
                        lastUpdateTime = updateTime;
                    }
                }
                catch (IOException e) {
                }
            }
        }
        String unknownString = "unknown";
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalNumberFiles:");
        outStream.writeBytes(unknown ? unknownString : "" + numOfFiles);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + totalFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("maxFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + maxFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("minFileSize:");
        if (numOfFiles > 0) {
            outStream.writeBytes(unknown ? unknownString : "" + minFileSize);
        } else {
            outStream.writeBytes(unknown ? unknownString : "0");
        }
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastAccessTime:");
        outStream.writeBytes(unknown || lastAccessTime < 0L ? unknownString : "" + lastAccessTime);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastUpdateTime:");
        outStream.writeBytes(unknown ? unknownString : "" + lastUpdateTime);
        outStream.write(10);
    }

    private int alterTable(Hive db, AlterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable(alterTbl.getOldName());
        this.validateAlterTableType(tbl, alterTbl.getOp());
        if (tbl.isView()) {
            if (!alterTbl.getExpectView()) {
                throw new HiveException("Cannot alter a view with ALTER TABLE");
            }
        } else if (alterTbl.getExpectView()) {
            throw new HiveException("Cannot alter a base table with ALTER VIEW");
        }
        Table oldTbl = tbl.copy();
        if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAME) {
            tbl.setTableName(alterTbl.getNewName());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCOLS) {
            ArrayList<FieldSchema> newCols = alterTbl.getNewCols();
            List<FieldSchema> oldCols = tbl.getCols();
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                tbl.getTTable().getSd().setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        this.console.printError("Column '" + newColName + "' exists");
                        return 1;
                    }
                    oldCols.add(newCol);
                }
                tbl.getTTable().getSd().setCols(oldCols);
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.RENAMECOLUMN) {
            List<FieldSchema> oldCols = tbl.getCols();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    this.console.printError("Column '" + newName + "' exists");
                    return 1;
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                this.console.printError("Column '" + oldName + "' does not exist");
                return 1;
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                this.console.printError("Column '" + afterCol + "' does not exist");
                return 1;
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            tbl.getTTable().getSd().setCols(newCols);
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.REPLACECOLS) {
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(tbl.getSerializationLib().equals(MetadataTypedColumnsetSerDe.class.getName()) || tbl.getSerializationLib().equals(LazySimpleSerDe.class.getName()) || tbl.getSerializationLib().equals(ColumnarSerDe.class.getName()) || tbl.getSerializationLib().equals(DynamicSerDe.class.getName()))) {
                this.console.printError("Replace columns is not supported for this table. SerDe may be incompatible.");
                return 1;
            }
            tbl.getTTable().getSd().setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDEPROPS) {
            tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDSERDE) {
            tbl.setSerializationLib(alterTbl.getSerdeName());
            if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
            tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getTableName(), tbl.getDeserializer()));
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDFILEFORMAT) {
            tbl.getTTable().getSd().setInputFormat(alterTbl.getInputFormat());
            tbl.getTTable().getSd().setOutputFormat(alterTbl.getOutputFormat());
            if (alterTbl.getSerdeName() != null) {
                tbl.setSerializationLib(alterTbl.getSerdeName());
            }
        } else if (alterTbl.getOp() == AlterTableDesc.AlterTableTypes.ADDCLUSTERSORTCOLUMN) {
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            tbl.getTTable().getSd().setBucketCols(alterTbl.getBucketColumns());
            tbl.getTTable().getSd().setNumBuckets(alterTbl.getNumberBuckets());
            tbl.getTTable().getSd().setSortCols(alterTbl.getSortColumns());
        } else {
            this.console.printError("Unsupported Alter commnad");
            return 1;
        }
        try {
            tbl.setProperty("last_modified_by", this.conf.getUser());
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        tbl.setProperty("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        try {
            tbl.checkValidity();
        }
        catch (HiveException e) {
            this.console.printError("Invalid table columns : " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        try {
            db.alterTable(alterTbl.getOldName(), tbl);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            return 1;
        }
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int dropTable(Hive db, DropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable(dropTbl.getTableName());
        }
        catch (InvalidTableException e) {
            // empty catch block
        }
        if (tbl != null) {
            if (tbl.isView()) {
                if (!dropTbl.getExpectView()) {
                    throw new HiveException("Cannot drop a view with DROP TABLE");
                }
            } else if (dropTbl.getExpectView()) {
                throw new HiveException("Cannot drop a base table with DROP VIEW");
            }
        }
        if (dropTbl.getPartSpecs() == null) {
            db.dropTable(db.getCurrentDatabase(), dropTbl.getTableName());
            if (tbl != null) {
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
            }
        } else {
            List<String> partitionNames = db.getPartitionNames(db.getCurrentDatabase(), dropTbl.getTableName(), (short)-1);
            HashSet<LinkedHashMap> partitions = new HashSet<LinkedHashMap>();
            for (int i = 0; i < partitionNames.size(); ++i) {
                try {
                    partitions.add(Warehouse.makeSpecFromName((String)partitionNames.get(i)));
                    continue;
                }
                catch (MetaException e) {
                    LOG.warn((Object)("Unrecognized partition name from metastore: " + partitionNames.get(i)));
                }
            }
            ArrayList<Partition> partsToDelete = new ArrayList<Partition>();
            for (LinkedHashMap<String, String> partSpec : dropTbl.getPartSpecs()) {
                Iterator it = partitions.iterator();
                while (it.hasNext()) {
                    Map part = (Map)it.next();
                    boolean match = true;
                    for (Map.Entry item : partSpec.entrySet()) {
                        if (((String)item.getValue()).equals(part.get(item.getKey()))) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    partsToDelete.add(db.getPartition(tbl, part, false));
                    it.remove();
                }
            }
            for (Partition partition : partsToDelete) {
                this.console.printInfo("Dropping the partition " + partition.getName());
                db.dropPartition(db.getCurrentDatabase(), dropTbl.getTableName(), partition.getValues(), true);
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition));
            }
        }
        return 0;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = SerDeUtils.lookupDeserializer(serdeName);
            if (d != null) {
                LOG.debug((Object)("Found class for " + serdeName));
            }
        }
        catch (SerDeException e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createDatabase(Hive db, CreateDatabaseDesc crtDb) throws HiveException, AlreadyExistsException {
        Database database = new Database();
        database.setName(crtDb.getName());
        database.setDescription(crtDb.getComment());
        database.setLocationUri(crtDb.getLocationUri());
        db.createDatabase(database, crtDb.getIfNotExists());
        return 0;
    }

    private int dropDatabase(Hive db, DropDatabaseDesc dropDb) throws HiveException, NoSuchObjectException {
        db.dropDatabase(dropDb.getDatabaseName(), true, dropDb.getIfExists());
        return 0;
    }

    private int switchDatabase(Hive db, SwitchDatabaseDesc switchDb) throws HiveException {
        String dbName = switchDb.getDatabaseName();
        if (!db.databaseExists(dbName)) {
            throw new HiveException("ERROR: The database " + dbName + " does not exist.");
        }
        db.setCurrentDatabase(dbName);
        return 0;
    }

    private int createTable(Hive db, CreateTableDesc crtTbl) throws HiveException {
        int rc;
        Table tbl = new Table(db.getCurrentDatabase(), crtTbl.getTableName());
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tbl.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getStorageHandler() != null) {
            tbl.setProperty("storage_handler", crtTbl.getStorageHandler());
        }
        HiveStorageHandler storageHandler = tbl.getStorageHandler();
        if (crtTbl.getSerName() != null) {
            tbl.setSerializationLib(crtTbl.getSerName());
        } else {
            if (crtTbl.getFieldDelim() != null) {
                tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
                tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
            }
            if (crtTbl.getFieldEscape() != null) {
                tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
            }
            if (crtTbl.getCollItemDelim() != null) {
                tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
            }
            if (crtTbl.getMapKeyDelim() != null) {
                tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
            }
            if (crtTbl.getLineDelim() != null) {
                tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
            }
        }
        if (crtTbl.getSerdeProps() != null) {
            for (Map.Entry<String, String> m : crtTbl.getSerdeProps().entrySet()) {
                tbl.setSerdeParam(m.getKey(), m.getValue());
            }
        }
        if (crtTbl.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtTbl.getTblProps());
        }
        if (crtTbl.getSerName() == null) {
            if (storageHandler == null) {
                LOG.info((Object)("Default to LazySimpleSerDe for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                String serDeClassName = storageHandler.getSerDeClass().getName();
                LOG.info((Object)("Use StorageHandler-supplied " + serDeClassName + " for table " + crtTbl.getTableName()));
                tbl.setSerializationLib(serDeClassName);
            }
        } else {
            this.validateSerDe(crtTbl.getSerName());
        }
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        if (crtTbl.getBucketCols() != null) {
            tbl.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
        }
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        tbl.getTTable().getSd().setInputFormat(tbl.getInputFormatClass().getName());
        tbl.getTTable().getSd().setOutputFormat(tbl.getOutputFormatClass().getName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
            tbl.setTableType(TableType.EXTERNAL_TABLE);
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
            return rc;
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createTableLike(Hive db, CreateTableLikeDesc crtTbl) throws HiveException {
        Table tbl = db.getTable(crtTbl.getLikeTableName());
        tbl.setTableName(crtTbl.getTableName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
        } else {
            tbl.setProperty("EXTERNAL", "FALSE");
        }
        if (crtTbl.getLocation() != null) {
            tbl.setDataLocation(new Path(crtTbl.getLocation()).toUri());
        } else {
            tbl.unsetDataLocation();
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createView(Hive db, CreateViewDesc crtView) throws HiveException {
        int rc;
        Table tbl = new Table(db.getCurrentDatabase(), crtView.getViewName());
        tbl.setTableType(TableType.VIRTUAL_VIEW);
        tbl.setSerializationLib(null);
        tbl.clearSerDeInfo();
        tbl.setViewOriginalText(crtView.getViewOriginalText());
        tbl.setViewExpandedText(crtView.getViewExpandedText());
        tbl.setFields(crtView.getSchema());
        if (crtView.getComment() != null) {
            tbl.setProperty("comment", crtView.getComment());
        }
        if (crtView.getTblProps() != null) {
            tbl.getTTable().getParameters().putAll(crtView.getTblProps());
        }
        if ((rc = this.setGenericTableAttributes(tbl)) != 0) {
            return rc;
        }
        db.createTable(tbl, crtView.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int setGenericTableAttributes(Table tbl) {
        try {
            tbl.setOwner(this.conf.getUser());
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        tbl.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        return 0;
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    @Override
    public String getName() {
        return "DDL";
    }
}

