/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FetchOperator
implements Serializable {
    static Log LOG = LogFactory.getLog((String)FetchOperator.class.getName());
    static SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private boolean isNativeTable;
    private FetchWork work;
    private int splitNum;
    private PartitionDesc currPart;
    private TableDesc currTbl;
    private boolean tblDataDone;
    private transient RecordReader<WritableComparable, Writable> currRecReader;
    private transient InputSplit[] inputSplits;
    private transient InputFormat inputFormat;
    private transient JobConf job;
    private transient WritableComparable key;
    private transient Writable value;
    private transient Deserializer serde;
    private transient Iterator<Path> iterPath;
    private transient Iterator<PartitionDesc> iterPartDesc;
    private transient Path currPath;
    private transient StructObjectInspector rowObjectInspector;
    private transient Object[] rowWithPart;
    private static Map<Class, InputFormat<WritableComparable, Writable>> inputFormats = new HashMap<Class, InputFormat<WritableComparable, Writable>>();

    public FetchOperator() {
    }

    public FetchOperator(FetchWork work, JobConf job) {
        this.work = work;
        this.initialize(job);
    }

    public void initialize(JobConf job) {
        this.job = job;
        this.tblDataDone = false;
        this.rowWithPart = new Object[2];
        this.isNativeTable = this.work.getTblDesc() != null ? !this.work.getTblDesc().isNonNative() : true;
    }

    public FetchWork getWork() {
        return this.work;
    }

    public void setWork(FetchWork work) {
        this.work = work;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public void setSplitNum(int splitNum) {
        this.splitNum = splitNum;
    }

    public PartitionDesc getCurrPart() {
        return this.currPart;
    }

    public void setCurrPart(PartitionDesc currPart) {
        this.currPart = currPart;
    }

    public TableDesc getCurrTbl() {
        return this.currTbl;
    }

    public void setCurrTbl(TableDesc currTbl) {
        this.currTbl = currTbl;
    }

    public boolean isTblDataDone() {
        return this.tblDataDone;
    }

    public void setTblDataDone(boolean tblDataDone) {
        this.tblDataDone = tblDataDone;
    }

    static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, Configuration conf) throws IOException {
        if (!inputFormats.containsKey(inputFormatClass)) {
            try {
                InputFormat newInstance = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)conf);
                inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)newInstance);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!");
            }
        }
        return inputFormats.get(inputFormatClass);
    }

    private void setPrtnDesc() throws Exception {
        String[] partKeys;
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> partValues = new ArrayList<String>();
        String pcols = this.currPart.getTableDesc().getProperties().getProperty("partition_columns");
        LinkedHashMap<String, String> partSpec = this.currPart.getPartSpec();
        ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
        for (String key : partKeys = pcols.trim().split("/")) {
            partNames.add(key);
            partValues.add(partSpec.get(key));
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        this.rowObjectInspector = (StructObjectInspector)this.serde.getObjectInspector();
        this.rowWithPart[1] = partValues;
        this.rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(this.rowObjectInspector, partObjectInspector));
    }

    private void getNextPath() throws Exception {
        if (this.iterPath == null) {
            if (this.work.getTblDir() != null) {
                if (!this.tblDataDone) {
                    this.currPath = this.work.getTblDirPath();
                    this.currTbl = this.work.getTblDesc();
                    if (this.isNativeTable) {
                        FileSystem fs = this.currPath.getFileSystem((Configuration)this.job);
                        if (fs.exists(this.currPath)) {
                            FileStatus[] fStats;
                            for (FileStatus fStat : fStats = this.listStatusUnderPath(fs, this.currPath)) {
                                if (fStat.getLen() <= 0L) continue;
                                this.tblDataDone = true;
                                break;
                            }
                        }
                    } else {
                        this.tblDataDone = true;
                    }
                    if (!this.tblDataDone) {
                        this.currPath = null;
                    }
                    return;
                }
                this.currTbl = null;
                this.currPath = null;
                return;
            }
            this.iterPath = FetchWork.convertStringToPathArray(this.work.getPartDir()).iterator();
            this.iterPartDesc = this.work.getPartDesc().iterator();
        }
        while (this.iterPath.hasNext()) {
            FileStatus[] fStats;
            FileSystem fs;
            Path nxt = this.iterPath.next();
            PartitionDesc prt = null;
            if (this.iterPartDesc != null) {
                prt = this.iterPartDesc.next();
            }
            if (!(fs = nxt.getFileSystem((Configuration)this.job)).exists(nxt)) continue;
            for (FileStatus fStat : fStats = this.listStatusUnderPath(fs, nxt)) {
                if (fStat.getLen() <= 0L) continue;
                this.currPath = nxt;
                if (this.iterPartDesc != null) {
                    this.currPart = prt;
                }
                return;
            }
        }
    }

    private RecordReader<WritableComparable, Writable> getRecordReader() throws Exception {
        if (this.currPath == null) {
            this.getNextPath();
            if (this.currPath == null) {
                return null;
            }
            this.job.set("mapred.input.dir", StringUtils.escapeString((String)this.currPath.toString()));
            PartitionDesc tmp = this.currTbl == null ? this.currPart : new PartitionDesc(this.currTbl, null);
            this.inputFormat = FetchOperator.getInputFormatFromCache(tmp.getInputFileFormatClass(), (Configuration)this.job);
            Utilities.copyTableJobPropertiesToConf(tmp.getTableDesc(), this.job);
            this.inputSplits = this.inputFormat.getSplits(this.job, 1);
            this.splitNum = 0;
            this.serde = tmp.getDeserializerClass().newInstance();
            this.serde.initialize((Configuration)this.job, tmp.getProperties());
            LOG.debug((Object)("Creating fetchTask with deserializer typeinfo: " + this.serde.getObjectInspector().getTypeName()));
            LOG.debug((Object)("deserializer properties: " + tmp.getProperties()));
            if (this.currPart != null) {
                this.setPrtnDesc();
            }
        }
        if (this.splitNum >= this.inputSplits.length) {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            this.currPath = null;
            return this.getRecordReader();
        }
        this.currRecReader = this.inputFormat.getRecordReader(this.inputSplits[this.splitNum++], this.job, Reporter.NULL);
        this.key = (WritableComparable)this.currRecReader.createKey();
        this.value = (Writable)this.currRecReader.createValue();
        return this.currRecReader;
    }

    public InspectableObject getNextRow() throws IOException {
        try {
            while (true) {
                boolean ret;
                if (this.currRecReader == null) {
                    this.currRecReader = this.getRecordReader();
                    if (this.currRecReader == null) {
                        return null;
                    }
                }
                if (ret = this.currRecReader.next((Object)this.key, (Object)this.value)) {
                    if (this.currPart == null) {
                        Object obj = this.serde.deserialize(this.value);
                        return new InspectableObject(obj, this.serde.getObjectInspector());
                    }
                    this.rowWithPart[0] = this.serde.deserialize(this.value);
                    return new InspectableObject(this.rowWithPart, this.rowObjectInspector);
                }
                this.currRecReader.close();
                this.currRecReader = null;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void clearFetchContext() throws HiveException {
        try {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            this.currPath = null;
            this.iterPath = null;
            this.iterPartDesc = null;
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void setupContext(Iterator<Path> iterPath, Iterator<PartitionDesc> iterPartDesc) {
        this.iterPath = iterPath;
        this.iterPartDesc = iterPartDesc;
        if (iterPartDesc == null) {
            if (this.work.getTblDir() != null) {
                this.currTbl = this.work.getTblDesc();
            } else {
                ArrayList<PartitionDesc> listParts = this.work.getPartDesc();
                this.currPart = (PartitionDesc)listParts.get(0);
            }
        }
    }

    public ObjectInspector getOutputObjectInspector() throws HiveException {
        try {
            if (this.work.getTblDir() != null) {
                TableDesc tbl = this.work.getTblDesc();
                Deserializer serde = tbl.getDeserializerClass().newInstance();
                serde.initialize((Configuration)this.job, tbl.getProperties());
                return serde.getObjectInspector();
            }
            ArrayList<PartitionDesc> listParts = this.work.getPartDesc();
            this.currPart = (PartitionDesc)listParts.get(0);
            this.serde = this.currPart.getTableDesc().getDeserializerClass().newInstance();
            this.serde.initialize((Configuration)this.job, this.currPart.getTableDesc().getProperties());
            this.setPrtnDesc();
            this.currPart = null;
            return this.rowObjectInspector;
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
    }

    private FileStatus[] listStatusUnderPath(FileSystem fs, Path p) throws IOException {
        HiveConf hiveConf = new HiveConf((Configuration)this.job, FetchOperator.class);
        boolean recursive = hiveConf.getBoolVar(HiveConf.ConfVars.HADOOPMAPREDINPUTDIRRECURSIVE);
        if (!recursive) {
            return fs.listStatus(p);
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        for (FileStatus stat : fs.listStatus(p)) {
            FileUtils.listStatusRecursively(fs, stat, results);
        }
        return results.toArray(new FileStatus[results.size()]);
    }
}

