/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectValue;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends AbstractMapJoinOperator<MapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    protected transient Map<Byte, HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue>> mapJoinTables;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Mapside join size exceeds hive.mapjoin.maxsize. Please increase that or remove the mapjoin hint."};
    static transient Map<Integer, MapJoinObjectCtx> mapMetadata = new HashMap<Integer, MapJoinObjectCtx>();
    static transient int nextVal = 0;
    transient int metadataKeyTag;
    transient int[] metadataValueTag;
    transient int maxMapJoinSize;

    public static Map<Integer, MapJoinObjectCtx> getMapMetadata() {
        return mapMetadata;
    }

    public MapJoinOperator() {
    }

    public MapJoinOperator(AbstractMapJoinOperator<? extends MapJoinDesc> mjop) {
        super(mjop);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int pos;
        super.initializeOp(hconf);
        this.maxMapJoinSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAXMAPJOINSIZE);
        this.metadataValueTag = new int[this.numAliases];
        for (pos = 0; pos < this.numAliases; ++pos) {
            this.metadataValueTag[pos] = -1;
        }
        this.mapJoinTables = new HashMap<Byte, HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue>>();
        for (pos = 0; pos < this.numAliases; ++pos) {
            if (pos == this.posBigTable) continue;
            int cacheSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINCACHEROWS);
            HashMapWrapper hashTable = new HashMapWrapper(cacheSize);
            this.mapJoinTables.put((byte)pos, hashTable);
        }
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + FATAL_ERR_MSG[(int)counterCode]);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (tag == this.posBigTable) {
            this.getExecContext().processInputFileChangeForLocalWork();
        }
        try {
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            ArrayList<Object> key = MapJoinOperator.computeValues(row, (List)this.joinKeys.get(this.alias), (List)this.joinKeysObjectInspectors.get(this.alias));
            ArrayList<Object> value = MapJoinOperator.computeValues(row, (List)this.joinValues.get(this.alias), (List)this.joinValuesObjectInspectors.get(this.alias));
            if (tag != this.posBigTable) {
                if (this.firstRow) {
                    this.metadataKeyTag = nextVal++;
                    TableDesc keyTableDesc = ((MapJoinDesc)this.conf).getKeyTblDesc();
                    SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
                    keySerializer.initialize(null, keyTableDesc.getProperties());
                    mapMetadata.put(this.metadataKeyTag, new MapJoinObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(keySerializer.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), keySerializer, keyTableDesc, this.hconf));
                    this.firstRow = false;
                }
                this.reportProgress();
                if (this.numMapRowsRead > this.maxMapJoinSize && this.reporter != null && this.counterNameToEnum != null) {
                    LOG.warn((Object)"Too many rows in map join tables. Fatal error counter will be incremented!!");
                    this.incrCounter(fatalErrorCntr, 1L);
                    fatalError = true;
                    return;
                }
                HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue> hashTable = this.mapJoinTables.get(this.alias);
                MapJoinObjectKey keyMap = new MapJoinObjectKey(this.metadataKeyTag, key);
                MapJoinObjectValue o = hashTable.get(keyMap);
                RowContainer res = null;
                boolean needNewKey = true;
                if (o == null) {
                    int bucketSize = HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
                    res = this.getRowContainer(this.hconf, (byte)tag, order[tag], bucketSize);
                    res.add(value);
                } else {
                    res = o.getObj();
                    res.add(value);
                    if (hashTable.cacheSize() > 0) {
                        o.setObj(res);
                        needNewKey = false;
                    }
                }
                if (this.metadataValueTag[tag] == -1) {
                    ++nextVal;
                    TableDesc valueTableDesc = ((MapJoinDesc)this.conf).getValueTblDescs().get(tag);
                    SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
                    valueSerDe.initialize(null, valueTableDesc.getProperties());
                    mapMetadata.put(this.metadataValueTag[tag], new MapJoinObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(valueSerDe.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), valueSerDe, valueTableDesc, this.hconf));
                }
                if (needNewKey) {
                    MapJoinObjectKey keyObj = new MapJoinObjectKey(this.metadataKeyTag, key);
                    MapJoinObjectValue valueObj = new MapJoinObjectValue(this.metadataValueTag[tag], res);
                    valueObj.setConf(this.hconf);
                    valueObj.setConf(this.hconf);
                    if (res.size() > this.mapJoinRowsKey && res.size() % 100 == 0) {
                        LOG.warn((Object)("Number of values for a given key " + keyObj + " are " + res.size()));
                        LOG.warn((Object)("used memory " + Runtime.getRuntime().totalMemory()));
                    }
                    hashTable.put(keyObj, valueObj);
                }
                return;
            }
            ((RowContainer)this.storage.get(this.alias)).add(value);
            for (Byte pos : order) {
                if (pos.intValue() == tag) continue;
                MapJoinObjectKey keyMap = new MapJoinObjectKey(this.metadataKeyTag, key);
                MapJoinObjectValue o = this.mapJoinTables.get(pos).get(keyMap);
                if (o == null) {
                    if (this.noOuterJoin) {
                        this.storage.put(pos, this.emptyList);
                        continue;
                    }
                    this.storage.put(pos, this.dummyObjVectors[pos.intValue()]);
                    continue;
                }
                this.storage.put(pos, o.getObj());
            }
            this.checkAndGenObject();
            ((RowContainer)this.storage.get(this.alias)).clear();
            for (Byte pos : order) {
                if (pos.intValue() == tag) continue;
                this.storage.put(pos, null);
            }
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.mapJoinTables != null) {
            for (HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue> hashTable : this.mapJoinTables.values()) {
                hashTable.close();
            }
        }
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return "MAPJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    public static class MapJoinObjectCtx {
        ObjectInspector standardOI;
        SerDe serde;
        TableDesc tblDesc;
        Configuration conf;

        public MapJoinObjectCtx(ObjectInspector standardOI, SerDe serde, TableDesc tblDesc, Configuration conf) {
            this.standardOI = standardOI;
            this.serde = serde;
            this.tblDesc = tblDesc;
            this.conf = conf;
        }

        public ObjectInspector getStandardOI() {
            return this.standardOI;
        }

        public SerDe getSerDe() {
            return this.serde;
        }

        public TableDesc getTblDesc() {
            return this.tblDesc;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

