/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Reduce Output Operator")
public class ReduceSinkDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<ExprNodeDesc> keyCols;
    private ArrayList<String> outputKeyColumnNames;
    private ArrayList<ExprNodeDesc> valueCols;
    private ArrayList<String> outputValueColumnNames;
    private TableDesc keySerializeInfo;
    private TableDesc valueSerializeInfo;
    private int tag;
    private ArrayList<ExprNodeDesc> partitionCols;
    private int numReducers;

    public ReduceSinkDesc() {
    }

    public ReduceSinkDesc(ArrayList<ExprNodeDesc> keyCols, ArrayList<ExprNodeDesc> valueCols, ArrayList<String> outputKeyColumnNames, ArrayList<String> outputValueolumnNames, int tag, ArrayList<ExprNodeDesc> partitionCols, int numReducers, TableDesc keySerializeInfo, TableDesc valueSerializeInfo) {
        this.keyCols = keyCols;
        this.valueCols = valueCols;
        this.outputKeyColumnNames = outputKeyColumnNames;
        this.outputValueColumnNames = outputValueolumnNames;
        this.tag = tag;
        this.numReducers = numReducers;
        this.partitionCols = partitionCols;
        this.keySerializeInfo = keySerializeInfo;
        this.valueSerializeInfo = valueSerializeInfo;
    }

    public ArrayList<String> getOutputKeyColumnNames() {
        return this.outputKeyColumnNames;
    }

    public void setOutputKeyColumnNames(ArrayList<String> outputKeyColumnNames) {
        this.outputKeyColumnNames = outputKeyColumnNames;
    }

    public ArrayList<String> getOutputValueColumnNames() {
        return this.outputValueColumnNames;
    }

    public void setOutputValueColumnNames(ArrayList<String> outputValueColumnNames) {
        this.outputValueColumnNames = outputValueColumnNames;
    }

    @Explain(displayName="key expressions")
    public ArrayList<ExprNodeDesc> getKeyCols() {
        return this.keyCols;
    }

    public void setKeyCols(ArrayList<ExprNodeDesc> keyCols) {
        this.keyCols = keyCols;
    }

    @Explain(displayName="value expressions")
    public ArrayList<ExprNodeDesc> getValueCols() {
        return this.valueCols;
    }

    public void setValueCols(ArrayList<ExprNodeDesc> valueCols) {
        this.valueCols = valueCols;
    }

    @Explain(displayName="Map-reduce partition columns")
    public ArrayList<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(ArrayList<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    @Explain(displayName="tag")
    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public int getNumReducers() {
        return this.numReducers;
    }

    public void setNumReducers(int numReducers) {
        this.numReducers = numReducers;
    }

    public TableDesc getKeySerializeInfo() {
        return this.keySerializeInfo;
    }

    public void setKeySerializeInfo(TableDesc keySerializeInfo) {
        this.keySerializeInfo = keySerializeInfo;
    }

    public TableDesc getValueSerializeInfo() {
        return this.valueSerializeInfo;
    }

    public void setValueSerializeInfo(TableDesc valueSerializeInfo) {
        this.valueSerializeInfo = valueSerializeInfo;
    }

    @Explain(displayName="sort order")
    public String getOrder() {
        return this.keySerializeInfo.getProperties().getProperty("serialization.sort.order");
    }

    public void setOrder(String orderStr) {
        this.keySerializeInfo.getProperties().setProperty("serialization.sort.order", orderStr);
    }
}

