/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

public class SessionState {
    protected HiveConf conf;
    protected boolean isSilent;
    protected HiveHistory hiveHist;
    public InputStream in;
    public PrintStream out;
    public PrintStream err;
    public PrintStream childOut;
    public PrintStream childErr;
    private String commandType;
    LineageState ls;
    private static ThreadLocal<SessionState> tss = new ThreadLocal();
    public static final String HIVE_L4J = "hive-log4j.properties";
    public static final String HIVE_EXEC_L4J = "hive-exec-log4j.properties";
    private static LogHelper _console;
    private final HashMap<ResourceType, HashSet<String>> resource_map = new HashMap();

    public LineageState getLineageState() {
        return this.ls;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public boolean getIsSilent() {
        if (this.conf != null) {
            return this.conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        }
        return this.isSilent;
    }

    public void setIsSilent(boolean isSilent) {
        if (this.conf != null) {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT, isSilent);
        }
        this.isSilent = isSilent;
    }

    public SessionState() {
        this(null);
    }

    public SessionState(HiveConf conf) {
        this.conf = conf;
        this.isSilent = conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        this.ls = new LineageState();
    }

    public void setCmd(String cmdString) {
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, cmdString);
    }

    public String getCmd() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYSTRING);
    }

    public String getQueryId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public String getSessionId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
    }

    public static SessionState start(HiveConf conf) {
        SessionState ss = new SessionState(conf);
        ss.getConf().setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        ss.hiveHist = new HiveHistory(ss);
        tss.set(ss);
        return ss;
    }

    public static SessionState start(SessionState startSs) {
        tss.set(startSs);
        if (StringUtils.isEmpty(startSs.getConf().getVar(HiveConf.ConfVars.HIVESESSIONID))) {
            startSs.getConf().setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        }
        if (startSs.hiveHist == null) {
            startSs.hiveHist = new HiveHistory(startSs);
        }
        return startSs;
    }

    public static SessionState get() {
        return tss.get();
    }

    public HiveHistory getHiveHistory() {
        return this.hiveHist;
    }

    private static String makeSessionId() {
        GregorianCalendar gc = new GregorianCalendar();
        String userid = System.getProperty("user.name");
        return userid + "_" + String.format("%1$4d%2$02d%3$02d%4$02d%5$02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12));
    }

    public static void initHiveLog4j() {
        URL hive_l4j = SessionState.class.getClassLoader().getResource(HIVE_L4J);
        if (hive_l4j == null) {
            System.out.println("hive-log4j.properties not found");
        } else {
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((URL)hive_l4j);
        }
    }

    public static LogHelper getConsole() {
        if (_console == null) {
            Log LOG = LogFactory.getLog((String)"SessionState");
            _console = new LogHelper(LOG);
        }
        return _console;
    }

    public static String validateFile(Set<String> curFiles, String newFile) {
        SessionState ss = SessionState.get();
        LogHelper console = SessionState.getConsole();
        Configuration conf = ss == null ? new Configuration() : ss.getConf();
        try {
            if (Utilities.realFile(newFile, conf) != null) {
                return newFile;
            }
            console.printError(newFile + " does not exist");
            return null;
        }
        catch (IOException e) {
            console.printError("Unable to validate " + newFile + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public static boolean registerJar(String newJar) {
        LogHelper console = SessionState.getConsole();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(Utilities.addToClassPath(loader, StringUtils.split(newJar, ",")));
            console.printInfo("Added " + newJar + " to class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to register " + newJar + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static boolean unregisterJar(String jarsToUnregister) {
        LogHelper console = SessionState.getConsole();
        try {
            Utilities.removeFromClassPath(StringUtils.split(jarsToUnregister, ","));
            console.printInfo("Deleted " + jarsToUnregister + " from class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to unregister " + jarsToUnregister + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static ResourceType find_resource_type(String s) {
        s = s.trim().toUpperCase();
        try {
            return ResourceType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            if (!s.endsWith("S")) {
                return null;
            }
            s = s.substring(0, s.length() - 1);
            try {
                return ResourceType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public void add_resource(ResourceType t, String value) {
        if (this.resource_map.get((Object)t) == null) {
            this.resource_map.put(t, new HashSet());
        }
        String fnlVal = value;
        if (t.hook != null && (fnlVal = t.hook.preHook((Set<String>)this.resource_map.get((Object)t), value)) == null) {
            return;
        }
        this.resource_map.get((Object)t).add(fnlVal);
    }

    public boolean delete_resource(ResourceType t, String value) {
        if (this.resource_map.get((Object)t) == null) {
            return false;
        }
        if (t.hook != null && !t.hook.postHook((Set<String>)this.resource_map.get((Object)t), value)) {
            return false;
        }
        return this.resource_map.get((Object)t).remove(value);
    }

    public Set<String> list_resource(ResourceType t, List<String> filter) {
        if (this.resource_map.get((Object)t) == null) {
            return null;
        }
        Set orig = this.resource_map.get((Object)t);
        if (filter == null) {
            return orig;
        }
        HashSet<String> fnl = new HashSet<String>();
        for (String one : orig) {
            if (!filter.contains(one)) continue;
            fnl.add(one);
        }
        return fnl;
    }

    public void delete_resource(ResourceType t) {
        if (this.resource_map.get((Object)t) != null) {
            for (String value : this.resource_map.get((Object)t)) {
                this.delete_resource(t, value);
            }
            this.resource_map.remove((Object)t);
        }
    }

    public String getCommandType() {
        return this.commandType;
    }

    public void setCommandType(String commandType) {
        this.commandType = commandType;
    }

    public static enum ResourceType {
        FILE(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                return SessionState.validateFile(cur, s);
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return true;
            }
        }),
        JAR(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                String newJar = SessionState.validateFile(cur, s);
                if (newJar != null) {
                    return SessionState.registerJar(newJar) ? newJar : null;
                }
                return null;
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return SessionState.unregisterJar(s);
            }
        }),
        ARCHIVE(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                return SessionState.validateFile(cur, s);
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return true;
            }
        });

        public ResourceHook hook;

        private ResourceType(ResourceHook hook) {
            this.hook = hook;
        }
    }

    public static interface ResourceHook {
        public String preHook(Set<String> var1, String var2);

        public boolean postHook(Set<String> var1, String var2);
    }

    public static class LogHelper {
        protected Log LOG;
        protected boolean isSilent;

        public LogHelper(Log LOG) {
            this(LOG, false);
        }

        public LogHelper(Log LOG, boolean isSilent) {
            this.LOG = LOG;
            this.isSilent = isSilent;
        }

        public PrintStream getOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.out != null ? ss.out : System.out;
        }

        public PrintStream getErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.err != null ? ss.err : System.err;
        }

        public PrintStream getChildOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childOut != null ? ss.childOut : this.getOutStream();
        }

        public PrintStream getChildErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childErr != null ? ss.childErr : this.getErrStream();
        }

        public boolean getIsSilent() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsSilent() : this.isSilent;
        }

        public void printInfo(String info) {
            this.printInfo(info, null);
        }

        public void printInfo(String info, String detail) {
            if (!this.getIsSilent()) {
                this.getErrStream().println(info);
            }
            this.LOG.info((Object)(info + StringUtils.defaultString(detail)));
        }

        public void printError(String error) {
            this.printError(error, null);
        }

        public void printError(String error, String detail) {
            this.getErrStream().println(error);
            this.LOG.error((Object)(error + StringUtils.defaultString(detail)));
        }
    }
}

