/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.UDFBaseCompare;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="<>", value="a _FUNC_ b - Returns TRUE if a is not equal to b")
public class UDFOPNotEqual
extends UDFBaseCompare {
    private BooleanWritable resultCache = new BooleanWritable();

    public BooleanWritable evaluate(Text a, Text b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(!a.equals((Object)b));
        }
        return r;
    }

    public BooleanWritable evaluate(ByteWritable a, ByteWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(ShortWritable a, ShortWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(IntWritable a, IntWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(LongWritable a, LongWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }

    public BooleanWritable evaluate(FloatWritable a, FloatWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }

    @Override
    public BooleanWritable evaluate(DoubleWritable a, DoubleWritable b) {
        BooleanWritable r = this.resultCache;
        if (a == null || b == null) {
            r = null;
        } else {
            r.set(a.get() != b.get());
        }
        return r;
    }
}

