/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.util.StringUtils;

@Description(name="histogram_numeric", value="_FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.")
public class GenericUDAFHistogramNumeric
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFHistogramNumeric.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 2) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Please specify exactly two arguments.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Only numeric type arguments are accepted but " + parameters[0].getTypeName() + " was passed as parameter 1.");
            }
        }
        if (parameters[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + parameters[1].getTypeName() + " was passed as parameter 2.");
        }
        if (((PrimitiveTypeInfo)parameters[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
            throw new UDFArgumentTypeException(1, "Only an integer argument is accepted as parameter 2, but " + parameters[1].getTypeName() + " was passed instead.");
        }
        return new GenericUDAFHistogramNumericEvaluator();
    }

    public static class GenericUDAFHistogramNumericEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private PrimitiveObjectInspector nbinsOI;
        private StandardListObjectInspector loi;
        Random prng;
        private boolean warned = false;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            this.prng = new Random(31183L);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                assert (parameters.length == 2);
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                this.nbinsOI = (PrimitiveObjectInspector)parameters[1];
            } else {
                this.loi = (StandardListObjectInspector)parameters[0];
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            }
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
            ArrayList<String> fname = new ArrayList<String>();
            fname.add("x");
            fname.add("y");
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi));
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ArrayList<DoubleWritable> partialResult = new ArrayList<DoubleWritable>();
            StdAgg myagg = (StdAgg)agg;
            partialResult.add(new DoubleWritable(myagg.nbins));
            if (myagg.hist != null) {
                for (int i = 0; i < myagg.nusedbins; ++i) {
                    partialResult.add(new DoubleWritable(myagg.hist[i].x));
                    partialResult.add(new DoubleWritable(myagg.hist[i].y));
                }
            }
            return partialResult;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            if (myagg.nusedbins < 1) {
                return null;
            }
            ArrayList<DoubleWritable[]> result = new ArrayList<DoubleWritable[]>();
            for (int i = 0; i < myagg.nusedbins; ++i) {
                DoubleWritable[] bin = new DoubleWritable[]{new DoubleWritable(myagg.hist[i].x), new DoubleWritable(myagg.hist[i].y)};
                result.add(bin);
            }
            return result;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            ArrayList partialHistogram = (ArrayList)this.loi.getList(partial);
            StdAgg myagg = (StdAgg)agg;
            if (myagg.nbins == 0 || myagg.nusedbins == 0) {
                myagg.nbins = (int)((DoubleWritable)partialHistogram.get(0)).get();
                myagg.nusedbins = (partialHistogram.size() - 1) / 2;
                myagg.hist = new StdAgg.Coord[myagg.nbins + 1];
                for (int i = 1; i < partialHistogram.size(); i += 2) {
                    myagg.hist[(i - 1) / 2] = new StdAgg.Coord();
                    myagg.hist[(i - 1) / 2].x = ((DoubleWritable)partialHistogram.get(i)).get();
                    myagg.hist[(i - 1) / 2].y = ((DoubleWritable)partialHistogram.get(i + 1)).get();
                }
            } else {
                int i;
                Object[] tmp_histogram = new StdAgg.Coord[myagg.nusedbins + (partialHistogram.size() - 1) / 2];
                for (int j = 0; j < tmp_histogram.length; ++j) {
                    tmp_histogram[j] = new StdAgg.Coord();
                }
                for (i = 0; i < myagg.nusedbins; ++i) {
                    tmp_histogram[i].x = myagg.hist[i].x;
                    ((StdAgg.Coord)tmp_histogram[i]).y = myagg.hist[i].y;
                }
                int j = 1;
                while (j < partialHistogram.size()) {
                    ((StdAgg.Coord)tmp_histogram[i]).x = ((DoubleWritable)partialHistogram.get(j)).get();
                    ((StdAgg.Coord)tmp_histogram[i]).y = ((DoubleWritable)partialHistogram.get(j + 1)).get();
                    j += 2;
                    ++i;
                }
                Arrays.sort(tmp_histogram);
                myagg.hist = tmp_histogram;
                myagg.nusedbins += (partialHistogram.size() - 1) / 2;
                this.trim(myagg);
            }
        }

        private void insert(StdAgg myagg, double v) {
            StdAgg.Coord[] histogram = myagg.hist;
            int bin = 0;
            int l = 0;
            int r = myagg.nusedbins;
            while (l < r) {
                bin = (l + r) / 2;
                if (histogram[bin].x > v) {
                    r = bin;
                    continue;
                }
                if (!(histogram[bin].x < v)) break;
                l = ++bin;
            }
            if (bin < myagg.nusedbins && histogram[bin].x == v) {
                histogram[bin].y += 1.0;
            } else {
                for (int i = myagg.nusedbins; i > bin; --i) {
                    myagg.hist[i].x = myagg.hist[i - 1].x;
                    myagg.hist[i].y = myagg.hist[i - 1].y;
                }
                myagg.hist[bin].x = v;
                myagg.hist[bin].y = 1.0;
                if (++myagg.nusedbins > myagg.nbins) {
                    this.trim(myagg);
                }
            }
        }

        private void trim(StdAgg myagg) {
            if (myagg.nusedbins <= myagg.nbins) {
                return;
            }
            StdAgg.Coord[] histogram = myagg.hist;
            while (myagg.nusedbins > myagg.nbins) {
                double smallestdiff = histogram[1].x - histogram[0].x;
                int smallestdiffloc = 0;
                int smallestdiffcount = 1;
                for (int i = 1; i < myagg.nusedbins - 1; ++i) {
                    double diff = histogram[i + 1].x - histogram[i].x;
                    if (diff < smallestdiff) {
                        smallestdiff = diff;
                        smallestdiffloc = i;
                        smallestdiffcount = 1;
                        continue;
                    }
                    if (diff != smallestdiff) continue;
                    ++smallestdiffcount;
                    if (!(this.prng.nextDouble() <= 1.0 / (double)smallestdiffcount)) continue;
                    smallestdiffloc = i;
                }
                double d = histogram[smallestdiffloc].y + histogram[smallestdiffloc + 1].y;
                histogram[smallestdiffloc].x *= histogram[smallestdiffloc].y / d;
                histogram[smallestdiffloc].x += histogram[smallestdiffloc + 1].x / d * histogram[smallestdiffloc + 1].y;
                histogram[smallestdiffloc].y = d;
                for (int i = smallestdiffloc + 1; i < myagg.nusedbins - 1; ++i) {
                    histogram[i].x = histogram[i + 1].x;
                    histogram[i].y = histogram[i + 1].y;
                }
                --myagg.nusedbins;
            }
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object p;
            assert (parameters.length == 2);
            if (parameters[0] == null || parameters[1] == null) {
                return;
            }
            StdAgg myagg = (StdAgg)agg;
            if (myagg.nbins == 0) {
                try {
                    myagg.nbins = PrimitiveObjectInspectorUtils.getInt(parameters[1], this.nbinsOI);
                }
                catch (NumberFormatException e) {
                    throw new HiveException(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                }
                if (myagg.nbins < 2) {
                    throw new HiveException(this.getClass().getSimpleName() + " needs nbins to be at least 2," + " but you supplied " + myagg.nbins + ".");
                }
                myagg.hist = new StdAgg.Coord[myagg.nbins + 1];
                for (int i = 0; i < myagg.nbins + 1; ++i) {
                    myagg.hist[i] = new StdAgg.Coord();
                }
                myagg.nusedbins = 0;
            }
            if ((p = parameters[0]) != null) {
                double v = PrimitiveObjectInspectorUtils.getDouble(p, this.inputOI);
                this.insert(myagg, v);
            }
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            StdAgg result = new StdAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            StdAgg myagg = (StdAgg)agg;
            myagg.nbins = 0;
            myagg.nusedbins = 0;
            myagg.hist = null;
        }

        static class StdAgg
        implements GenericUDAFEvaluator.AggregationBuffer {
            int nbins;
            int nusedbins;
            Coord[] hist;

            StdAgg() {
            }

            static class Coord
            implements Comparable {
                double x;
                double y;

                Coord() {
                }

                public int compareTo(Object other) {
                    Coord o = (Coord)other;
                    if (this.x < o.x) {
                        return -1;
                    }
                    if (this.x > o.x) {
                        return 1;
                    }
                    return 0;
                }
            }
        }
    }
}

