/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;

public final class ObjectInspectorUtils {
    protected static final Log LOG = LogFactory.getLog((String)ObjectInspectorUtils.class.getName());

    public static ObjectInspector getStandardObjectInspector(ObjectInspector oi) {
        return ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorCopyOption.DEFAULT);
    }

    public static ObjectInspector getStandardObjectInspector(ObjectInspector oi, ObjectInspectorCopyOption objectInspectorOption) {
        ObjectInspector result = null;
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (objectInspectorOption) {
                    case DEFAULT: {
                        if (poi.preferWritable()) {
                            result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(poi.getPrimitiveCategory());
                            break;
                        }
                        result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(poi.getPrimitiveCategory());
                        break;
                    }
                    case JAVA: {
                        result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(poi.getPrimitiveCategory());
                        break;
                    }
                    case WRITABLE: {
                        result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(poi.getPrimitiveCategory());
                    }
                }
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                result = ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(loi.getListElementObjectInspector(), objectInspectorOption));
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                result = ObjectInspectorFactory.getStandardMapObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(moi.getMapKeyObjectInspector(), objectInspectorOption), ObjectInspectorUtils.getStandardObjectInspector(moi.getMapValueObjectInspector(), objectInspectorOption));
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fields.size());
                for (StructField structField : fields) {
                    fieldNames.add(structField.getFieldName());
                    fieldObjectInspectors.add(ObjectInspectorUtils.getStandardObjectInspector(structField.getFieldObjectInspector(), objectInspectorOption));
                }
                result = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
                break;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return result;
    }

    public static void partialCopyToStandardObject(List<Object> result, Object row, int startCol, int numCols, StructObjectInspector soi, ObjectInspectorCopyOption objectInspectorOption) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        int i = 0;
        int j = 0;
        for (StructField structField : fields) {
            if (i++ < startCol) continue;
            result.add(ObjectInspectorUtils.copyToStandardObject(soi.getStructFieldData(row, structField), structField.getFieldObjectInspector(), objectInspectorOption));
            if (j != numCols) continue;
            break;
        }
    }

    public static Object copyToStandardObject(Object o, ObjectInspector oi) {
        return ObjectInspectorUtils.copyToStandardObject(o, oi, ObjectInspectorCopyOption.DEFAULT);
    }

    public static Object copyToStandardObject(Object o, ObjectInspector oi, ObjectInspectorCopyOption objectInspectorOption) {
        if (o == null) {
            return null;
        }
        Cloneable result = null;
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector loi = (PrimitiveObjectInspector)oi;
                switch (objectInspectorOption) {
                    case DEFAULT: {
                        if (loi.preferWritable()) {
                            result = loi.getPrimitiveWritableObject(loi.copyObject(o));
                            break;
                        }
                        result = loi.getPrimitiveJavaObject(o);
                        break;
                    }
                    case JAVA: {
                        result = loi.getPrimitiveJavaObject(o);
                        break;
                    }
                    case WRITABLE: {
                        result = loi.getPrimitiveWritableObject(loi.copyObject(o));
                    }
                }
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                int length = loi.getListLength(o);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(ObjectInspectorUtils.copyToStandardObject(loi.getListElement(o, i), loi.getListElementObjectInspector(), objectInspectorOption));
                }
                result = list;
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                Map<?, ?> omap = moi.getMap(o);
                for (Map.Entry<?, ?> entry : omap.entrySet()) {
                    map.put(ObjectInspectorUtils.copyToStandardObject(entry.getKey(), moi.getMapKeyObjectInspector(), objectInspectorOption), ObjectInspectorUtils.copyToStandardObject(entry.getValue(), moi.getMapValueObjectInspector(), objectInspectorOption));
                }
                result = map;
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                ArrayList<Object> struct = new ArrayList<Object>(fields.size());
                for (StructField structField : fields) {
                    struct.add(ObjectInspectorUtils.copyToStandardObject(soi.getStructFieldData(o, structField), structField.getFieldObjectInspector(), objectInspectorOption));
                }
                result = struct;
                break;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return result;
    }

    public static String getStandardStructTypeName(StructObjectInspector soi) {
        StringBuilder sb = new StringBuilder();
        sb.append("struct<");
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fields.get(i).getFieldName());
            sb.append(":");
            sb.append(fields.get(i).getFieldObjectInspector().getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public static StructField getStandardStructFieldRef(String fieldName, List<? extends StructField> fields) {
        int i;
        fieldName = fieldName.toLowerCase();
        for (i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getFieldName().equals(fieldName)) continue;
            return fields.get(i);
        }
        try {
            i = Integer.parseInt(fieldName);
            if (i >= 0 && i < fields.size()) {
                return fields.get(i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new RuntimeException("cannot find field " + fieldName + " from " + fields);
    }

    public static Field[] getDeclaredNonStaticFields(Class<?> c) {
        Field[] f = c.getDeclaredFields();
        ArrayList<Field> af = new ArrayList<Field>();
        for (int i = 0; i < f.length; ++i) {
            if (Modifier.isStatic(f[i].getModifiers())) continue;
            af.add(f[i]);
        }
        Field[] r = new Field[af.size()];
        for (int i = 0; i < af.size(); ++i) {
            r[i] = (Field)af.get(i);
        }
        return r;
    }

    public static String getObjectInspectorName(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                return oi.getClass().getSimpleName();
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                return oi.getClass().getSimpleName() + "<" + ObjectInspectorUtils.getObjectInspectorName(loi.getListElementObjectInspector()) + ">";
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                return oi.getClass().getSimpleName() + "<" + ObjectInspectorUtils.getObjectInspectorName(moi.getMapKeyObjectInspector()) + "," + ObjectInspectorUtils.getObjectInspectorName(moi.getMapValueObjectInspector()) + ">";
            }
            case STRUCT: {
                StringBuilder result = new StringBuilder();
                result.append(oi.getClass().getSimpleName() + "<");
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    result.append(fields.get(i).getFieldName());
                    result.append(":");
                    result.append(ObjectInspectorUtils.getObjectInspectorName(fields.get(i).getFieldObjectInspector()));
                    if (i == fields.size() - 1) {
                        result.append(">");
                        continue;
                    }
                    result.append(",");
                }
                return result.toString();
            }
        }
        throw new RuntimeException("Unknown ObjectInspector category!");
    }

    public static int hashCode(Object o, ObjectInspector objIns) {
        if (o == null) {
            return 0;
        }
        switch (objIns.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objIns;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return 0;
                    }
                    case BOOLEAN: {
                        return ((BooleanObjectInspector)poi).get(o) ? 1 : 0;
                    }
                    case BYTE: {
                        return ((ByteObjectInspector)poi).get(o);
                    }
                    case SHORT: {
                        return ((ShortObjectInspector)poi).get(o);
                    }
                    case INT: {
                        return ((IntObjectInspector)poi).get(o);
                    }
                    case LONG: {
                        long a = ((LongObjectInspector)poi).get(o);
                        return (int)(a >>> 32 ^ a);
                    }
                    case FLOAT: {
                        return Float.floatToIntBits(((FloatObjectInspector)poi).get(o));
                    }
                    case DOUBLE: {
                        long a = Double.doubleToLongBits(((DoubleObjectInspector)poi).get(o));
                        return (int)(a >>> 32 ^ a);
                    }
                    case STRING: {
                        Text t = ((StringObjectInspector)poi).getPrimitiveWritableObject(o);
                        int r = 0;
                        for (int i = 0; i < t.getLength(); ++i) {
                            r = r * 31 + t.getBytes()[i];
                        }
                        return r;
                    }
                }
                throw new RuntimeException("Unknown type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
        }
        throw new RuntimeException("Hash code on complex types not supported yet.");
    }

    public static int compare(Object[] o1, ObjectInspector[] oi1, Object[] o2, ObjectInspector[] oi2) {
        assert (o1.length == oi1.length);
        assert (o2.length == oi2.length);
        assert (o1.length == o2.length);
        for (int i = 0; i < o1.length; ++i) {
            int r = ObjectInspectorUtils.compare(o1[i], oi1[i], o2[i], oi2[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public static boolean compareSupported(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                return true;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                return ObjectInspectorUtils.compareSupported(loi.getListElementObjectInspector());
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int f = 0; f < fields.size(); ++f) {
                    if (ObjectInspectorUtils.compareSupported(fields.get(f).getFieldObjectInspector())) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                return false;
            }
        }
        return false;
    }

    public static int compare(Object o1, ObjectInspector oi1, Object o2, ObjectInspector oi2) {
        if (oi1.getCategory() != oi2.getCategory()) {
            return oi1.getCategory().compareTo(oi2.getCategory());
        }
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        switch (oi1.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi1 = (PrimitiveObjectInspector)oi1;
                PrimitiveObjectInspector poi2 = (PrimitiveObjectInspector)oi2;
                if (poi1.getPrimitiveCategory() != poi2.getPrimitiveCategory()) {
                    return poi1.getPrimitiveCategory().compareTo(poi2.getPrimitiveCategory());
                }
                switch (poi1.getPrimitiveCategory()) {
                    case VOID: {
                        return 0;
                    }
                    case BOOLEAN: {
                        int v1 = ((BooleanObjectInspector)poi1).get(o1) ? 1 : 0;
                        int v2 = ((BooleanObjectInspector)poi2).get(o2) ? 1 : 0;
                        return v1 - v2;
                    }
                    case BYTE: {
                        byte v1 = ((ByteObjectInspector)poi1).get(o1);
                        byte v2 = ((ByteObjectInspector)poi2).get(o2);
                        return v1 - v2;
                    }
                    case SHORT: {
                        short v1 = ((ShortObjectInspector)poi1).get(o1);
                        short v2 = ((ShortObjectInspector)poi2).get(o2);
                        return v1 - v2;
                    }
                    case INT: {
                        int v1 = ((IntObjectInspector)poi1).get(o1);
                        int v2 = ((IntObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case LONG: {
                        long v1 = ((LongObjectInspector)poi1).get(o1);
                        long v2 = ((LongObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case FLOAT: {
                        float v1 = ((FloatObjectInspector)poi1).get(o1);
                        float v2 = ((FloatObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case DOUBLE: {
                        double v1 = ((DoubleObjectInspector)poi1).get(o1);
                        double v2 = ((DoubleObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case STRING: {
                        if (poi1.preferWritable() || poi2.preferWritable()) {
                            Text t1 = (Text)poi1.getPrimitiveWritableObject(o1);
                            Text t2 = (Text)poi2.getPrimitiveWritableObject(o2);
                            return t1 == null ? (t2 == null ? 0 : -1) : (t2 == null ? 1 : ShimLoader.getHadoopShims().compareText(t1, t2));
                        }
                        String s1 = (String)poi1.getPrimitiveJavaObject(o1);
                        String s2 = (String)poi2.getPrimitiveJavaObject(o2);
                        return s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : s1.compareTo(s2));
                    }
                }
                throw new RuntimeException("Unknown type: " + (Object)((Object)poi1.getPrimitiveCategory()));
            }
            case STRUCT: {
                StructObjectInspector soi1 = (StructObjectInspector)oi1;
                StructObjectInspector soi2 = (StructObjectInspector)oi2;
                List<? extends StructField> fields1 = soi1.getAllStructFieldRefs();
                List<? extends StructField> fields2 = soi2.getAllStructFieldRefs();
                int minimum = Math.min(fields1.size(), fields2.size());
                for (int i = 0; i < minimum; ++i) {
                    int r = ObjectInspectorUtils.compare(soi1.getStructFieldData(o1, fields1.get(i)), fields1.get(i).getFieldObjectInspector(), soi2.getStructFieldData(o2, fields2.get(i)), fields2.get(i).getFieldObjectInspector());
                    if (r == 0) continue;
                    return r;
                }
                return fields1.size() - fields2.size();
            }
            case LIST: {
                ListObjectInspector loi1 = (ListObjectInspector)oi1;
                ListObjectInspector loi2 = (ListObjectInspector)oi2;
                int minimum = Math.min(loi1.getListLength(o1), loi2.getListLength(o2));
                for (int i = 0; i < minimum; ++i) {
                    int r = ObjectInspectorUtils.compare(loi1.getListElement(o1, i), loi1.getListElementObjectInspector(), loi2.getListElement(o2, i), loi2.getListElementObjectInspector());
                    if (r == 0) continue;
                    return r;
                }
                return loi1.getListLength(o1) - loi2.getListLength(o2);
            }
            case MAP: {
                throw new RuntimeException("Compare on map type not supported!");
            }
        }
        throw new RuntimeException("Compare on unknown type: " + (Object)((Object)oi1.getCategory()));
    }

    public static String getFieldNames(StructObjectInspector soi) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fields.get(i).getFieldName());
        }
        return sb.toString();
    }

    public static String getFieldTypes(StructObjectInspector soi) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()).getTypeName());
        }
        return sb.toString();
    }

    public static String getTypeNameFromJavaClass(Type t) {
        try {
            ObjectInspector oi = ObjectInspectorFactory.getReflectionObjectInspector(t, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            return oi.getTypeName();
        }
        catch (Throwable e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return "unknown";
        }
    }

    public static boolean compareTypes(ObjectInspector o1, ObjectInspector o2) {
        ObjectInspector.Category c2;
        ObjectInspector.Category c1 = o1.getCategory();
        if (!c1.equals((Object)(c2 = o2.getCategory()))) {
            return false;
        }
        if (c1.equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            return o1.getTypeName().equals(o2.getTypeName());
        }
        if (c1.equals((Object)ObjectInspector.Category.LIST)) {
            ObjectInspector child1 = ((ListObjectInspector)o1).getListElementObjectInspector();
            ObjectInspector child2 = ((ListObjectInspector)o2).getListElementObjectInspector();
            return ObjectInspectorUtils.compareTypes(child1, child2);
        }
        if (c1.equals((Object)ObjectInspector.Category.MAP)) {
            ObjectInspector childVal2;
            ObjectInspector childVal1;
            ObjectInspector childKey2;
            MapObjectInspector mapOI1 = (MapObjectInspector)o1;
            MapObjectInspector mapOI2 = (MapObjectInspector)o2;
            ObjectInspector childKey1 = mapOI1.getMapKeyObjectInspector();
            return ObjectInspectorUtils.compareTypes(childKey1, childKey2 = mapOI2.getMapKeyObjectInspector()) && ObjectInspectorUtils.compareTypes(childVal1 = mapOI1.getMapValueObjectInspector(), childVal2 = mapOI2.getMapValueObjectInspector());
        }
        if (c1.equals((Object)ObjectInspector.Category.STRUCT)) {
            StructObjectInspector structOI1 = (StructObjectInspector)o1;
            StructObjectInspector structOI2 = (StructObjectInspector)o2;
            List<? extends StructField> childFieldsList1 = structOI1.getAllStructFieldRefs();
            List<? extends StructField> childFieldsList2 = structOI2.getAllStructFieldRefs();
            if (childFieldsList1 == null && childFieldsList2 == null) {
                return true;
            }
            if (childFieldsList1.size() != childFieldsList2.size()) {
                return false;
            }
            Iterator<? extends StructField> it1 = childFieldsList1.iterator();
            Iterator<? extends StructField> it2 = childFieldsList2.iterator();
            while (it1.hasNext()) {
                StructField field1 = it1.next();
                StructField field2 = it2.next();
                if (ObjectInspectorUtils.compareTypes(field1.getFieldObjectInspector(), field2.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("Unknown category encountered: " + (Object)((Object)c1));
    }

    private ObjectInspectorUtils() {
    }

    public static enum ObjectInspectorCopyOption {
        DEFAULT,
        JAVA,
        WRITABLE;

    }
}

