/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.mapred.TableInputFormatBase;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class HiveHBaseTableInputFormat<K extends ImmutableBytesWritable, V extends RowResult>
implements InputFormat<K, V>,
JobConfigurable {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableInputFormat.class);
    private HBaseExposedTableInputFormat hbaseInputFormat = new HBaseExposedTableInputFormat();

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        boolean addAll;
        HBaseSplit hbaseSplit = (HBaseSplit)split;
        String hbaseTableName = job.get("hbase.table.name");
        this.hbaseInputFormat.setHBaseTable(new HTable(new HBaseConfiguration((Configuration)job), Bytes.toBytes((String)hbaseTableName)));
        String columnMapping = hbaseSplit.getColumnsMapping();
        List<String> columns = HBaseSerDe.parseColumnMapping(columnMapping);
        ArrayList readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)job);
        if (columns.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        ArrayList<byte[]> scanColumns = new ArrayList<byte[]>();
        boolean bl = addAll = readColIDs.size() == 0;
        if (!addAll) {
            Iterator<Object> i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int iColumn = (Integer)i$.next();
                String column = columns.get(iColumn);
                if (HBaseSerDe.isSpecialColumn(column)) continue;
                scanColumns.add(Bytes.toBytes((String)column));
            }
        }
        if (scanColumns.isEmpty()) {
            for (String column : columns) {
                if (HBaseSerDe.isSpecialColumn(column)) continue;
                scanColumns.add(Bytes.toBytes((String)column));
                if (addAll) continue;
                break;
            }
        }
        this.hbaseInputFormat.setScanColumns((byte[][])scanColumns.toArray((T[])new byte[0][]));
        return this.hbaseInputFormat.getRecordReader((InputSplit)hbaseSplit.getSplit(), job, reporter);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Path[] tableNames = FileInputFormat.getInputPaths((JobConf)job);
        String hbaseTableName = job.get("hbase.table.name");
        this.hbaseInputFormat.setHBaseTable(new HTable(new HBaseConfiguration((Configuration)job), hbaseTableName));
        String hbaseSchemaMapping = job.get("hbase.columns.mapping");
        if (hbaseSchemaMapping == null) {
            throw new IOException("hbase.columns.mapping required for HBase Table.");
        }
        List<String> columns = HBaseSerDe.parseColumnMapping(hbaseSchemaMapping);
        ArrayList<byte[]> inputColumns = new ArrayList<byte[]>();
        for (String column : columns) {
            if (HBaseSerDe.isSpecialColumn(column)) continue;
            inputColumns.add(Bytes.toBytes((String)column));
        }
        this.hbaseInputFormat.setScanColumns((byte[][])inputColumns.toArray((T[])new byte[0][]));
        InputSplit[] splits = this.hbaseInputFormat.getSplits(job, numSplits <= 0 ? 1 : numSplits);
        InputSplit[] results = new InputSplit[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            results[i] = new HBaseSplit((TableSplit)splits[i], hbaseSchemaMapping, tableNames[0]);
        }
        return results;
    }

    public void configure(JobConf job) {
        this.hbaseInputFormat.configure(job);
    }

    static class HBaseExposedTableInputFormat
    extends TableInputFormatBase
    implements JobConfigurable {
        HBaseExposedTableInputFormat() {
        }

        public void configure(JobConf job) {
        }

        public void setScanColumns(byte[][] scanColumns) {
            this.setInputColumns(scanColumns);
        }

        public void setHBaseTable(HTable table) {
            this.setHTable(table);
        }
    }
}

