/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Writable;

public class LazyHBaseCellMap
extends LazyMap {
    private RowResult rowResult;
    private String hbaseColumnFamily;

    public LazyHBaseCellMap(LazyMapObjectInspector oi) {
        super(oi);
    }

    public void init(ByteArrayRef bytes, int start, int length) {
    }

    public void init(RowResult rr, String columnFamily) {
        this.rowResult = rr;
        this.hbaseColumnFamily = columnFamily;
        this.setParsed(false);
    }

    private void parse() {
        if (this.cachedMap == null) {
            this.cachedMap = new LinkedHashMap();
        } else {
            this.cachedMap.clear();
        }
        Iterator iter = this.rowResult.keySet().iterator();
        byte[] columnFamily = this.hbaseColumnFamily.getBytes();
        while (iter.hasNext()) {
            byte[] columnValue;
            byte[] columnKey = (byte[])iter.next();
            if (columnFamily.length > columnKey.length || 0 != LazyUtils.compare((byte[])columnFamily, (int)0, (int)columnFamily.length, (byte[])columnKey, (int)0, (int)columnFamily.length) || (columnValue = this.rowResult.get(columnKey).getValue()) == null || columnValue.length == 0) continue;
            LazyPrimitive key = LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)((PrimitiveObjectInspector)((MapObjectInspector)this.getInspector()).getMapKeyObjectInspector()));
            ByteArrayRef keyRef = new ByteArrayRef();
            keyRef.setData(columnKey);
            key.init(keyRef, columnFamily.length, columnKey.length - columnFamily.length);
            LazyObject value = LazyFactory.createLazyObject((ObjectInspector)((MapObjectInspector)this.getInspector()).getMapValueObjectInspector());
            ByteArrayRef valueRef = new ByteArrayRef();
            valueRef.setData(columnValue);
            value.init(valueRef, 0, columnValue.length);
            this.cachedMap.put(key.getObject(), value.getObject());
        }
    }

    public Object getMapValueElement(Object key) {
        if (!this.getParsed()) {
            this.parse();
        }
        for (Map.Entry entry : this.cachedMap.entrySet()) {
            LazyPrimitive lazyKeyI = (LazyPrimitive)entry.getKey();
            Writable keyI = lazyKeyI.getWritableObject();
            if (keyI == null || !keyI.equals(key)) continue;
            LazyObject v = (LazyObject)entry.getValue();
            return v == null ? v : v.getObject();
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap;
    }

    public int getMapSize() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap.size();
    }
}

