/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class MathTanMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression ignore, List args) {
        if (args == null || args.size() == 0) {
            throw new NucleusUserException("Cannot invoke Math.tan without an argument");
        }
        SQLExpression expr = (SQLExpression)args.get(0);
        if (expr == null) {
            return new NullLiteral(this.stmt, null, null, false);
        }
        if (expr instanceof SQLLiteral) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                BigInteger absValue = new BigInteger(String.valueOf(Math.tan(originalValue)));
                return new ByteLiteral(this.stmt, expr.getJavaTypeMapping(), absValue, false);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double absValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.stmt, expr.getJavaTypeMapping(), absValue, false);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double absValue = new Double(Math.tan(originalValue));
                return new FloatingPointLiteral(this.stmt, expr.getJavaTypeMapping(), absValue, false);
            }
            throw new IllegalExpressionOperationException("Math.tan()", expr);
        }
        return this.exprFactory.invokeMethod(this.stmt, null, "tan", null, args);
    }
}

