/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Table
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Table");
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField RETENTION_FIELD_DESC = new TField("retention", 8, 6);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 7);
    private static final TField PARTITION_KEYS_FIELD_DESC = new TField("partitionKeys", 15, 8);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 9);
    private String tableName;
    public static final int TABLENAME = 1;
    private String dbName;
    public static final int DBNAME = 2;
    private String owner;
    public static final int OWNER = 3;
    private int createTime;
    public static final int CREATETIME = 4;
    private int lastAccessTime;
    public static final int LASTACCESSTIME = 5;
    private int retention;
    public static final int RETENTION = 6;
    private StorageDescriptor sd;
    public static final int SD = 7;
    private List<FieldSchema> partitionKeys;
    public static final int PARTITIONKEYS = 8;
    private Map<String, String> parameters;
    public static final int PARAMETERS = 9;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
            this.put(3, new FieldMetaData("owner", 3, new FieldValueMetaData(11)));
            this.put(4, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
            this.put(5, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
            this.put(6, new FieldMetaData("retention", 3, new FieldValueMetaData(8)));
            this.put(7, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
            this.put(8, new FieldMetaData("partitionKeys", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
            this.put(9, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        }
    });

    public Table() {
    }

    public Table(String tableName, String dbName, String owner, int createTime, int lastAccessTime, int retention, StorageDescriptor sd, List<FieldSchema> partitionKeys, Map<String, String> parameters) {
        this();
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.__isset.createTime = true;
        this.lastAccessTime = lastAccessTime;
        this.__isset.lastAccessTime = true;
        this.retention = retention;
        this.__isset.retention = true;
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
    }

    public Table(Table other) {
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetOwner()) {
            this.owner = other.owner;
        }
        this.__isset.createTime = other.__isset.createTime;
        this.createTime = other.createTime;
        this.__isset.lastAccessTime = other.__isset.lastAccessTime;
        this.lastAccessTime = other.lastAccessTime;
        this.__isset.retention = other.__isset.retention;
        this.retention = other.retention;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetPartitionKeys()) {
            ArrayList<FieldSchema> __this__partitionKeys = new ArrayList<FieldSchema>();
            for (FieldSchema fieldSchema : other.partitionKeys) {
                __this__partitionKeys.add(new FieldSchema(fieldSchema));
            }
            this.partitionKeys = __this__partitionKeys;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
    }

    public Table clone() {
        return new Table(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.__isset.createTime = true;
    }

    public void unsetCreateTime() {
        this.__isset.createTime = false;
    }

    public boolean isSetCreateTime() {
        return this.__isset.createTime;
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.__isset.lastAccessTime = true;
    }

    public void unsetLastAccessTime() {
        this.__isset.lastAccessTime = false;
    }

    public boolean isSetLastAccessTime() {
        return this.__isset.lastAccessTime;
    }

    public int getRetention() {
        return this.retention;
    }

    public void setRetention(int retention) {
        this.retention = retention;
        this.__isset.retention = true;
    }

    public void unsetRetention() {
        this.__isset.retention = false;
    }

    public boolean isSetRetention() {
        return this.__isset.retention;
    }

    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public int getPartitionKeysSize() {
        return this.partitionKeys == null ? 0 : this.partitionKeys.size();
    }

    public Iterator<FieldSchema> getPartitionKeysIterator() {
        return this.partitionKeys == null ? null : this.partitionKeys.iterator();
    }

    public void addToPartitionKeys(FieldSchema elem) {
        if (this.partitionKeys == null) {
            this.partitionKeys = new ArrayList<FieldSchema>();
        }
        this.partitionKeys.add(elem);
    }

    public List<FieldSchema> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(List<FieldSchema> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void unsetPartitionKeys() {
        this.partitionKeys = null;
    }

    public boolean isSetPartitionKeys() {
        return this.partitionKeys != null;
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetRetention();
                    break;
                }
                this.setRetention((Integer)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetPartitionKeys();
                    break;
                }
                this.setPartitionKeys((List)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getTableName();
            }
            case 2: {
                return this.getDbName();
            }
            case 3: {
                return this.getOwner();
            }
            case 4: {
                return new Integer(this.getCreateTime());
            }
            case 5: {
                return new Integer(this.getLastAccessTime());
            }
            case 6: {
                return new Integer(this.getRetention());
            }
            case 7: {
                return this.getSd();
            }
            case 8: {
                return this.getPartitionKeys();
            }
            case 9: {
                return this.getParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetTableName();
            }
            case 2: {
                return this.isSetDbName();
            }
            case 3: {
                return this.isSetOwner();
            }
            case 4: {
                return this.isSetCreateTime();
            }
            case 5: {
                return this.isSetLastAccessTime();
            }
            case 6: {
                return this.isSetRetention();
            }
            case 7: {
                return this.isSetSd();
            }
            case 8: {
                return this.isSetPartitionKeys();
            }
            case 9: {
                return this.isSetParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Table) {
            return this.equals((Table)that);
        }
        return false;
    }

    public boolean equals(Table that) {
        if (that == null) {
            return false;
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_retention = true;
        boolean that_present_retention = true;
        if (this_present_retention || that_present_retention) {
            if (!this_present_retention || !that_present_retention) {
                return false;
            }
            if (this.retention != that.retention) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_partitionKeys = this.isSetPartitionKeys();
        boolean that_present_partitionKeys = that.isSetPartitionKeys();
        if (this_present_partitionKeys || that_present_partitionKeys) {
            if (!this_present_partitionKeys || !that_present_partitionKeys) {
                return false;
            }
            if (!((Object)this.partitionKeys).equals(that.partitionKeys)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.tableName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dbName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.owner = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.createTime = iprot.readI32();
                        this.__isset.createTime = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.lastAccessTime = iprot.readI32();
                        this.__isset.lastAccessTime = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.retention = iprot.readI32();
                        this.__isset.retention = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 7: {
                    if (field.type == 12) {
                        this.sd = new StorageDescriptor();
                        this.sd.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 8: {
                    if (field.type == 15) {
                        TList _list26 = iprot.readListBegin();
                        this.partitionKeys = new ArrayList<FieldSchema>(_list26.size);
                        for (int _i27 = 0; _i27 < _list26.size; ++_i27) {
                            FieldSchema _elem28 = new FieldSchema();
                            _elem28.read(iprot);
                            this.partitionKeys.add(_elem28);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 9: {
                    if (field.type == 13) {
                        TMap _map29 = iprot.readMapBegin();
                        this.parameters = new HashMap<String, String>(2 * _map29.size);
                        for (int _i30 = 0; _i30 < _map29.size; ++_i30) {
                            String _key31 = iprot.readString();
                            String _val32 = iprot.readString();
                            this.parameters.put(_key31, _val32);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.tableName != null) {
            oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
            oprot.writeString(this.tableName);
            oprot.writeFieldEnd();
        }
        if (this.dbName != null) {
            oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
            oprot.writeString(this.dbName);
            oprot.writeFieldEnd();
        }
        if (this.owner != null) {
            oprot.writeFieldBegin(OWNER_FIELD_DESC);
            oprot.writeString(this.owner);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
        oprot.writeI32(this.createTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
        oprot.writeI32(this.lastAccessTime);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(RETENTION_FIELD_DESC);
        oprot.writeI32(this.retention);
        oprot.writeFieldEnd();
        if (this.sd != null) {
            oprot.writeFieldBegin(SD_FIELD_DESC);
            this.sd.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.partitionKeys != null) {
            oprot.writeFieldBegin(PARTITION_KEYS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.partitionKeys.size()));
            for (FieldSchema fieldSchema : this.partitionKeys) {
                fieldSchema.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.parameters != null) {
            oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.parameters.size()));
            for (Map.Entry entry : this.parameters.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        boolean first = true;
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("retention:");
        sb.append(this.retention);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partitionKeys:");
        if (this.partitionKeys == null) {
            sb.append("null");
        } else {
            sb.append(this.partitionKeys);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(Table.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean createTime = false;
        public boolean lastAccessTime = false;
        public boolean retention = false;

        private Isset() {
        }
    }
}

