/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.pig.ResourceSchema;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.piggybank.storage.avro.AvroStorageLog;
import org.apache.pig.piggybank.storage.avro.AvroStorageUtils;

public class AvroSchema2Pig {
    public static String RECORD = "RECORD";
    public static String FIELD = "FIELD";
    public static String ARRAY_FIELD = "ARRAY_ELEM";
    public static String MAP_VALUE_FIELD = "m_value";

    public static ResourceSchema.ResourceFieldSchema getPigSchema(byte pigType, String fieldName) {
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(fieldName, pigType));
    }

    public static ResourceSchema convert(Schema schema) throws IOException {
        ResourceSchema tupleSchema;
        if (AvroStorageUtils.containsGenericUnion(schema)) {
            throw new IOException("We don't accept schema containing generic unions.");
        }
        HashSet<Schema> visitedRecords = new HashSet<Schema>();
        ResourceSchema.ResourceFieldSchema inSchema = AvroSchema2Pig.inconvert(schema, FIELD, visitedRecords);
        if (inSchema.getType() == 110) {
            tupleSchema = inSchema.getSchema();
        } else {
            ResourceSchema.ResourceFieldSchema tupleWrapper = AvroStorageUtils.wrapAsTuple(inSchema);
            ResourceSchema topSchema = new ResourceSchema();
            topSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{tupleWrapper});
            tupleSchema = topSchema;
        }
        return tupleSchema;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceSchema.ResourceFieldSchema inconvert(Schema in, String fieldName, Set<Schema> visitedRecords) throws IOException {
        AvroStorageLog.details("InConvert avro schema with field name " + fieldName);
        Schema.Type avroType = in.getType();
        ResourceSchema.ResourceFieldSchema fieldSchema = new ResourceSchema.ResourceFieldSchema();
        fieldSchema.setName(fieldName);
        if (avroType.equals((Object)Schema.Type.RECORD)) {
            AvroStorageLog.details("convert to a pig tuple");
            if (visitedRecords.contains(in)) {
                fieldSchema.setType((byte)50);
                return fieldSchema;
            } else {
                visitedRecords.add(in);
                fieldSchema.setType((byte)110);
                ResourceSchema tupleSchema = new ResourceSchema();
                List fields = in.getFields();
                ResourceSchema.ResourceFieldSchema[] childFields = new ResourceSchema.ResourceFieldSchema[fields.size()];
                int index = 0;
                for (Schema.Field field : fields) {
                    childFields[index++] = AvroSchema2Pig.inconvert(field.schema(), field.name(), visitedRecords);
                }
                tupleSchema.setFields(childFields);
                fieldSchema.setSchema(tupleSchema);
            }
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.ARRAY)) {
            AvroStorageLog.details("convert array to a pig bag");
            fieldSchema.setType((byte)120);
            Schema elemSchema = in.getElementType();
            ResourceSchema.ResourceFieldSchema subFieldSchema = AvroSchema2Pig.inconvert(elemSchema, ARRAY_FIELD, visitedRecords);
            AvroSchema2Pig.add2BagSchema(fieldSchema, subFieldSchema);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.MAP)) {
            AvroStorageLog.details("convert map to a pig map");
            fieldSchema.setType((byte)100);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.UNION)) {
            if (!AvroStorageUtils.isAcceptableUnion(in)) throw new IOException("Do not support generic union:" + in);
            Schema acceptSchema = AvroStorageUtils.getAcceptedType(in);
            ResourceSchema.ResourceFieldSchema realFieldSchema = AvroSchema2Pig.inconvert(acceptSchema, null, visitedRecords);
            fieldSchema.setType(realFieldSchema.getType());
            fieldSchema.setSchema(realFieldSchema.getSchema());
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.FIXED)) {
            fieldSchema.setType((byte)50);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.BOOLEAN)) {
            fieldSchema.setType((byte)5);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.BYTES)) {
            fieldSchema.setType((byte)50);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.DOUBLE)) {
            fieldSchema.setType((byte)25);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.ENUM)) {
            fieldSchema.setType((byte)55);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.FLOAT)) {
            fieldSchema.setType((byte)20);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.INT)) {
            fieldSchema.setType((byte)10);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.LONG)) {
            fieldSchema.setType((byte)15);
            return fieldSchema;
        } else if (avroType.equals((Object)Schema.Type.STRING)) {
            fieldSchema.setType((byte)55);
            return fieldSchema;
        } else {
            if (!avroType.equals((Object)Schema.Type.NULL)) throw new IOException("Unsupported avro type:" + avroType);
            fieldSchema.setType((byte)10);
        }
        return fieldSchema;
    }

    protected static void add2BagSchema(ResourceSchema.ResourceFieldSchema fieldSchema, ResourceSchema.ResourceFieldSchema subFieldSchema) throws IOException {
        ResourceSchema.ResourceFieldSchema wrapped = subFieldSchema.getType() == 110 ? subFieldSchema : AvroStorageUtils.wrapAsTuple(subFieldSchema);
        ResourceSchema listSchema = new ResourceSchema();
        listSchema.setFields(new ResourceSchema.ResourceFieldSchema[]{wrapped});
        fieldSchema.setSchema(listSchema);
    }
}

