/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.partition;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class PathPartitioner {
    public Map<String, String> getPathPartitionKeyValues(String location) throws IOException {
        String[] pathSplit;
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (String pathSplitItem : pathSplit = location.split("/")) {
            this.parseAndPutKeyValue(pathSplitItem, partitionKeys);
        }
        return partitionKeys;
    }

    public Set<String> getPartitionKeys(String location, Configuration conf) throws IOException {
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem(conf);
        FileStatus[] fileStatusArr = null;
        LinkedHashSet<String> partitionKeys = new LinkedHashSet<String>();
        this.parseAndPutKeyValue(location, partitionKeys);
        block0: while ((fileStatusArr = fs.listStatus(path)) != null && !fs.isFile(path)) {
            for (FileStatus fileStatus : fileStatusArr) {
                path = fileStatus.getPath();
                if (fileStatus.getPath().getName().startsWith("_") || !fileStatus.isDir()) continue;
                this.parseAndPutKeyValue(path.getName(), partitionKeys);
                continue block0;
            }
        }
        return partitionKeys;
    }

    private final void parseAndPutKeyValue(String pathName, Map<String, String> partitionKeys) {
        String[] keyValue = this.parsePathKeyValue(pathName);
        if (keyValue != null) {
            partitionKeys.put(keyValue[0], keyValue[1]);
        }
    }

    private final void parseAndPutKeyValue(String pathName, Set<String> partitionKeys) {
        String[] keyValue = this.parsePathKeyValue(pathName);
        if (keyValue != null) {
            partitionKeys.add(keyValue[0]);
        }
    }

    public String[] parsePathKeyValue(String path) {
        String[] split;
        int slashIndex = path.lastIndexOf(47);
        String parsedPath = path;
        String[] keyValue = null;
        if (slashIndex > 0) {
            parsedPath = path.substring(slashIndex);
        }
        if (parsedPath.contains("=") && (split = parsedPath.split("=")).length == 2) {
            keyValue = split;
        }
        return keyValue;
    }
}

