/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;

public class SimpleScope
implements IScope {
    private World world;
    private ResolvedType enclosingType;
    protected FormalBinding[] bindings;
    private String[] importedPrefixes = javaLangPrefixArray;
    private String[] importedNames = ZERO_STRINGS;
    private static final String[] ZERO_STRINGS = new String[0];
    private static final String[] javaLangPrefixArray = new String[]{"java.lang."};

    public SimpleScope(World world, FormalBinding[] bindings) {
        this.world = world;
        this.bindings = bindings;
    }

    public UnresolvedType lookupType(String name, IHasPosition location) {
        int i;
        for (i = 0; i < this.importedNames.length; ++i) {
            String importedName = this.importedNames[i];
            if (!importedName.endsWith(name)) continue;
            return this.world.resolve(importedName);
        }
        for (i = 0; i < this.importedPrefixes.length; ++i) {
            String importedPrefix = this.importedPrefixes[i];
            ResolvedType tryType = this.world.resolve(UnresolvedType.forName(importedPrefix + name), true);
            if (tryType.isMissing()) continue;
            return tryType;
        }
        return this.world.resolve(UnresolvedType.forName(name), true);
    }

    public IMessageHandler getMessageHandler() {
        return this.world.getMessageHandler();
    }

    public FormalBinding lookupFormal(String name) {
        int len = this.bindings.length;
        for (int i = 0; i < len; ++i) {
            if (!this.bindings[i].getName().equals(name)) continue;
            return this.bindings[i];
        }
        return null;
    }

    public FormalBinding getFormal(int i) {
        return this.bindings[i];
    }

    public int getFormalCount() {
        return this.bindings.length;
    }

    public String[] getImportedNames() {
        return this.importedNames;
    }

    public String[] getImportedPrefixes() {
        return this.importedPrefixes;
    }

    public void setImportedNames(String[] importedNames) {
        this.importedNames = importedNames;
    }

    public void setImportedPrefixes(String[] importedPrefixes) {
        this.importedPrefixes = importedPrefixes;
    }

    public static FormalBinding[] makeFormalBindings(UnresolvedType[] types, String[] names) {
        int len = types.length;
        FormalBinding[] bindings = new FormalBinding[len];
        for (int i = 0; i < len; ++i) {
            bindings[i] = new FormalBinding(types[i], names[i], i);
        }
        return bindings;
    }

    public ISourceLocation makeSourceLocation(IHasPosition location) {
        return new SourceLocation(ISourceLocation.NO_FILE, 0);
    }

    public void message(IMessage.Kind kind, IHasPosition location1, IHasPosition location2, String message) {
        this.message(kind, location1, message);
        this.message(kind, location2, message);
    }

    public void message(IMessage.Kind kind, IHasPosition location, String message) {
        this.getMessageHandler().handleMessage(new Message(message, kind, null, this.makeSourceLocation(location)));
    }

    public void message(IMessage aMessage) {
        this.getMessageHandler().handleMessage(aMessage);
    }

    public World getWorld() {
        return this.world;
    }

    public ResolvedType getEnclosingType() {
        return this.enclosingType;
    }
}

