/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.Map;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.MapKeyLiteral;
import org.datanucleus.store.mapped.expression.MapValueLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class MapLiteral
extends ScalarExpression {
    private final boolean isEmpty;
    private final boolean containsNull;
    private final MapValueLiteral mapValueLiteral;
    private final MapKeyLiteral mapKeyLiteral;

    public MapLiteral(QueryExpression qs, JavaTypeMapping mapping, Map map) {
        super(qs);
        this.mapping = mapping;
        this.containsNull = map != null && map.containsValue(null);
        this.mapValueLiteral = new MapValueLiteral(qs, mapping, map);
        this.mapKeyLiteral = new MapKeyLiteral(qs, mapping, map);
        this.isEmpty = map == null || map.isEmpty() || map.size() == 1 && this.containsNull;
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        return this.mapValueLiteral.containsMethod(expr);
    }

    public BooleanExpression containsValueMethod(ScalarExpression expr) {
        return this.mapValueLiteral.containsMethod(expr);
    }

    public BooleanExpression containsKeyMethod(ScalarExpression expr) {
        return this.mapKeyLiteral.containsMethod(expr);
    }

    public BooleanExpression containsEntryMethod(ScalarExpression expr) {
        return this.mapKeyLiteral.containsMethod(expr).and(this.mapValueLiteral.containsMethod(expr));
    }

    public ScalarExpression getMethod(ScalarExpression expr) {
        return this.mapKeyLiteral.getMethod(expr);
    }

    public BooleanExpression isEmptyMethod() {
        return new BooleanLiteral(this.qs, this.mapping, this.isEmpty);
    }
}

