/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.collectDesc;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class CollectOperator
extends Operator<collectDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ArrayList<Object> rowList;
    protected transient ObjectInspector standardRowInspector;
    transient int maxSize;
    boolean firstRow = true;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.rowList = new ArrayList();
        this.maxSize = ((collectDesc)this.conf).getBufferSize();
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        ObjectInspector rowInspector = this.inputObjInspectors[tag];
        if (this.firstRow) {
            this.firstRow = false;
            this.standardRowInspector = ObjectInspectorUtils.getStandardObjectInspector(rowInspector);
        }
        if (this.rowList.size() < this.maxSize) {
            Object o = ObjectInspectorUtils.copyToStandardObject(row, rowInspector);
            this.rowList.add(o);
        }
        this.forward(row, rowInspector);
    }

    public void retrieve(InspectableObject result) {
        assert (result != null);
        if (this.rowList.isEmpty()) {
            result.o = null;
            result.oi = null;
        } else {
            result.o = this.rowList.remove(0);
            result.oi = this.standardRowInspector;
        }
    }
}

